/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchCreateDataTableValueRequest extends ConnectRequest implements
        ToCopyableBuilder<BatchCreateDataTableValueRequest.Builder, BatchCreateDataTableValueRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(BatchCreateDataTableValueRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> DATA_TABLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataTableId").getter(getter(BatchCreateDataTableValueRequest::dataTableId))
            .setter(setter(Builder::dataTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DataTableId").build()).build();

    private static final SdkField<List<DataTableValue>> VALUES_FIELD = SdkField
            .<List<DataTableValue>> builder(MarshallingType.LIST)
            .memberName("Values")
            .getter(getter(BatchCreateDataTableValueRequest::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataTableValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataTableValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            DATA_TABLE_ID_FIELD, VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final String dataTableId;

    private final List<DataTableValue> values;

    private BatchCreateDataTableValueRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.dataTableId = builder.dataTableId;
        this.values = builder.values;
    }

    /**
     * <p>
     * The unique identifier for the Amazon Connect instance.
     * </p>
     * 
     * @return The unique identifier for the Amazon Connect instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The unique identifier for the data table. Must also accept the table ARN with or without a version alias. If no
     * alias is provided, the default behavior is identical to providing the $LATEST alias.
     * </p>
     * 
     * @return The unique identifier for the data table. Must also accept the table ARN with or without a version alias.
     *         If no alias is provided, the default behavior is identical to providing the $LATEST alias.
     */
    public final String dataTableId() {
        return dataTableId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of values to create. Each value must specify the attribute name and optionally primary values if the table
     * has primary attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return A list of values to create. Each value must specify the attribute name and optionally primary values if
     *         the table has primary attributes.
     */
    public final List<DataTableValue> values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(dataTableId());
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateDataTableValueRequest)) {
            return false;
        }
        BatchCreateDataTableValueRequest other = (BatchCreateDataTableValueRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(dataTableId(), other.dataTableId())
                && hasValues() == other.hasValues() && Objects.equals(values(), other.values());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchCreateDataTableValueRequest").add("InstanceId", instanceId())
                .add("DataTableId", dataTableId()).add("Values", hasValues() ? values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "DataTableId":
            return Optional.ofNullable(clazz.cast(dataTableId()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("DataTableId", DATA_TABLE_ID_FIELD);
        map.put("Values", VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateDataTableValueRequest, T> g) {
        return obj -> g.apply((BatchCreateDataTableValueRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchCreateDataTableValueRequest> {
        /**
         * <p>
         * The unique identifier for the Amazon Connect instance.
         * </p>
         * 
         * @param instanceId
         *        The unique identifier for the Amazon Connect instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The unique identifier for the data table. Must also accept the table ARN with or without a version alias. If
         * no alias is provided, the default behavior is identical to providing the $LATEST alias.
         * </p>
         * 
         * @param dataTableId
         *        The unique identifier for the data table. Must also accept the table ARN with or without a version
         *        alias. If no alias is provided, the default behavior is identical to providing the $LATEST alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTableId(String dataTableId);

        /**
         * <p>
         * A list of values to create. Each value must specify the attribute name and optionally primary values if the
         * table has primary attributes.
         * </p>
         * 
         * @param values
         *        A list of values to create. Each value must specify the attribute name and optionally primary values
         *        if the table has primary attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<DataTableValue> values);

        /**
         * <p>
         * A list of values to create. Each value must specify the attribute name and optionally primary values if the
         * table has primary attributes.
         * </p>
         * 
         * @param values
         *        A list of values to create. Each value must specify the attribute name and optionally primary values
         *        if the table has primary attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(DataTableValue... values);

        /**
         * <p>
         * A list of values to create. Each value must specify the attribute name and optionally primary values if the
         * table has primary attributes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.DataTableValue.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connect.model.DataTableValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.DataTableValue.Builder#build()} is called immediately
         * and its result is passed to {@link #values(List<DataTableValue>)}.
         * 
         * @param values
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.DataTableValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #values(java.util.Collection<DataTableValue>)
         */
        Builder values(Consumer<DataTableValue.Builder>... values);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String dataTableId;

        private List<DataTableValue> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateDataTableValueRequest model) {
            super(model);
            instanceId(model.instanceId);
            dataTableId(model.dataTableId);
            values(model.values);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getDataTableId() {
            return dataTableId;
        }

        public final void setDataTableId(String dataTableId) {
            this.dataTableId = dataTableId;
        }

        @Override
        public final Builder dataTableId(String dataTableId) {
            this.dataTableId = dataTableId;
            return this;
        }

        public final List<DataTableValue.Builder> getValues() {
            List<DataTableValue.Builder> result = DataTableValueListCopier.copyToBuilder(this.values);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValues(Collection<DataTableValue.BuilderImpl> values) {
            this.values = DataTableValueListCopier.copyFromBuilder(values);
        }

        @Override
        public final Builder values(Collection<DataTableValue> values) {
            this.values = DataTableValueListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(DataTableValue... values) {
            values(Arrays.asList(values));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Consumer<DataTableValue.Builder>... values) {
            values(Stream.of(values).map(c -> DataTableValue.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchCreateDataTableValueRequest build() {
            return new BatchCreateDataTableValueRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
