/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.model.GetMetricDataRequest;
import software.amazon.awssdk.services.connect.model.GetMetricDataResponse;

public class GetMetricDataIterable
implements SdkIterable<GetMetricDataResponse> {
    private final ConnectClient client;
    private final GetMetricDataRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetMetricDataIterable(ConnectClient client, GetMetricDataRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetMetricDataResponseFetcher();
    }

    public Iterator<GetMetricDataResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final GetMetricDataIterable resume(GetMetricDataResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetMetricDataIterable(this.client, (GetMetricDataRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetMetricDataIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetMetricDataResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetMetricDataResponseFetcher
    implements SyncPageFetcher<GetMetricDataResponse> {
        private GetMetricDataResponseFetcher() {
        }

        public boolean hasNextPage(GetMetricDataResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetMetricDataResponse nextPage(GetMetricDataResponse previousPage) {
            if (previousPage == null) {
                return GetMetricDataIterable.this.client.getMetricData(GetMetricDataIterable.this.firstRequest);
            }
            return GetMetricDataIterable.this.client.getMetricData((GetMetricDataRequest)((Object)GetMetricDataIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

