/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ReplicationStatusSummary;
import software.amazon.awssdk.services.connect.model.ReplicationStatusSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReplicationConfiguration> {
    private static final SdkField<List<ReplicationStatusSummary>> REPLICATION_STATUS_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReplicationStatusSummaryList").getter(ReplicationConfiguration.getter(ReplicationConfiguration::replicationStatusSummaryList)).setter(ReplicationConfiguration.setter(Builder::replicationStatusSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationStatusSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReplicationStatusSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SOURCE_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceRegion").getter(ReplicationConfiguration.getter(ReplicationConfiguration::sourceRegion)).setter(ReplicationConfiguration.setter(Builder::sourceRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceRegion").build()}).build();
    private static final SdkField<String> GLOBAL_SIGN_IN_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlobalSignInEndpoint").getter(ReplicationConfiguration.getter(ReplicationConfiguration::globalSignInEndpoint)).setter(ReplicationConfiguration.setter(Builder::globalSignInEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalSignInEndpoint").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_STATUS_SUMMARY_LIST_FIELD, SOURCE_REGION_FIELD, GLOBAL_SIGN_IN_ENDPOINT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReplicationConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<ReplicationStatusSummary> replicationStatusSummaryList;
    private final String sourceRegion;
    private final String globalSignInEndpoint;

    private ReplicationConfiguration(BuilderImpl builder) {
        this.replicationStatusSummaryList = builder.replicationStatusSummaryList;
        this.sourceRegion = builder.sourceRegion;
        this.globalSignInEndpoint = builder.globalSignInEndpoint;
    }

    public final boolean hasReplicationStatusSummaryList() {
        return this.replicationStatusSummaryList != null && !(this.replicationStatusSummaryList instanceof SdkAutoConstructList);
    }

    public final List<ReplicationStatusSummary> replicationStatusSummaryList() {
        return this.replicationStatusSummaryList;
    }

    public final String sourceRegion() {
        return this.sourceRegion;
    }

    public final String globalSignInEndpoint() {
        return this.globalSignInEndpoint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicationStatusSummaryList() ? this.replicationStatusSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalSignInEndpoint());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationConfiguration)) {
            return false;
        }
        ReplicationConfiguration other = (ReplicationConfiguration)obj;
        return this.hasReplicationStatusSummaryList() == other.hasReplicationStatusSummaryList() && Objects.equals(this.replicationStatusSummaryList(), other.replicationStatusSummaryList()) && Objects.equals(this.sourceRegion(), other.sourceRegion()) && Objects.equals(this.globalSignInEndpoint(), other.globalSignInEndpoint());
    }

    public final String toString() {
        return ToString.builder((String)"ReplicationConfiguration").add("ReplicationStatusSummaryList", this.hasReplicationStatusSummaryList() ? this.replicationStatusSummaryList() : null).add("SourceRegion", (Object)this.sourceRegion()).add("GlobalSignInEndpoint", (Object)this.globalSignInEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationStatusSummaryList": {
                return Optional.ofNullable(clazz.cast(this.replicationStatusSummaryList()));
            }
            case "SourceRegion": {
                return Optional.ofNullable(clazz.cast(this.sourceRegion()));
            }
            case "GlobalSignInEndpoint": {
                return Optional.ofNullable(clazz.cast(this.globalSignInEndpoint()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ReplicationStatusSummaryList", REPLICATION_STATUS_SUMMARY_LIST_FIELD);
        map.put("SourceRegion", SOURCE_REGION_FIELD);
        map.put("GlobalSignInEndpoint", GLOBAL_SIGN_IN_ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReplicationConfiguration, T> g) {
        return obj -> g.apply((ReplicationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ReplicationStatusSummary> replicationStatusSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String sourceRegion;
        private String globalSignInEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationConfiguration model) {
            this.replicationStatusSummaryList(model.replicationStatusSummaryList);
            this.sourceRegion(model.sourceRegion);
            this.globalSignInEndpoint(model.globalSignInEndpoint);
        }

        public final List<ReplicationStatusSummary.Builder> getReplicationStatusSummaryList() {
            List<ReplicationStatusSummary.Builder> result = ReplicationStatusSummaryListCopier.copyToBuilder(this.replicationStatusSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicationStatusSummaryList(Collection<ReplicationStatusSummary.BuilderImpl> replicationStatusSummaryList) {
            this.replicationStatusSummaryList = ReplicationStatusSummaryListCopier.copyFromBuilder(replicationStatusSummaryList);
        }

        @Override
        public final Builder replicationStatusSummaryList(Collection<ReplicationStatusSummary> replicationStatusSummaryList) {
            this.replicationStatusSummaryList = ReplicationStatusSummaryListCopier.copy(replicationStatusSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationStatusSummaryList(ReplicationStatusSummary ... replicationStatusSummaryList) {
            this.replicationStatusSummaryList(Arrays.asList(replicationStatusSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationStatusSummaryList(Consumer<ReplicationStatusSummary.Builder> ... replicationStatusSummaryList) {
            this.replicationStatusSummaryList(Stream.of(replicationStatusSummaryList).map(c -> (ReplicationStatusSummary)((ReplicationStatusSummary.Builder)ReplicationStatusSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSourceRegion() {
            return this.sourceRegion;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        public final String getGlobalSignInEndpoint() {
            return this.globalSignInEndpoint;
        }

        public final void setGlobalSignInEndpoint(String globalSignInEndpoint) {
            this.globalSignInEndpoint = globalSignInEndpoint;
        }

        @Override
        public final Builder globalSignInEndpoint(String globalSignInEndpoint) {
            this.globalSignInEndpoint = globalSignInEndpoint;
            return this;
        }

        public ReplicationConfiguration build() {
            return new ReplicationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReplicationConfiguration> {
        public Builder replicationStatusSummaryList(Collection<ReplicationStatusSummary> var1);

        public Builder replicationStatusSummaryList(ReplicationStatusSummary ... var1);

        public Builder replicationStatusSummaryList(Consumer<ReplicationStatusSummary.Builder> ... var1);

        public Builder sourceRegion(String var1);

        public Builder globalSignInEndpoint(String var1);
    }
}

