/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.RealTimeContactAnalysisStatus;
import software.amazon.awssdk.services.connect.model.RealTimeContactAnalysisSupportedChannel;
import software.amazon.awssdk.services.connect.model.RealtimeContactAnalysisSegment;
import software.amazon.awssdk.services.connect.model.RealtimeContactAnalysisSegmentsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRealtimeContactAnalysisSegmentsV2Response
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListRealtimeContactAnalysisSegmentsV2Response> {
    private static final SdkField<String> CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Channel").getter(ListRealtimeContactAnalysisSegmentsV2Response.getter(ListRealtimeContactAnalysisSegmentsV2Response::channelAsString)).setter(ListRealtimeContactAnalysisSegmentsV2Response.setter(Builder::channel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channel").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ListRealtimeContactAnalysisSegmentsV2Response.getter(ListRealtimeContactAnalysisSegmentsV2Response::statusAsString)).setter(ListRealtimeContactAnalysisSegmentsV2Response.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<RealtimeContactAnalysisSegment>> SEGMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Segments").getter(ListRealtimeContactAnalysisSegmentsV2Response.getter(ListRealtimeContactAnalysisSegmentsV2Response::segments)).setter(ListRealtimeContactAnalysisSegmentsV2Response.setter(Builder::segments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Segments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RealtimeContactAnalysisSegment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRealtimeContactAnalysisSegmentsV2Response.getter(ListRealtimeContactAnalysisSegmentsV2Response::nextToken)).setter(ListRealtimeContactAnalysisSegmentsV2Response.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_FIELD, STATUS_FIELD, SEGMENTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListRealtimeContactAnalysisSegmentsV2Response.memberNameToFieldInitializer();
    private final String channel;
    private final String status;
    private final List<RealtimeContactAnalysisSegment> segments;
    private final String nextToken;

    private ListRealtimeContactAnalysisSegmentsV2Response(BuilderImpl builder) {
        super(builder);
        this.channel = builder.channel;
        this.status = builder.status;
        this.segments = builder.segments;
        this.nextToken = builder.nextToken;
    }

    public final RealTimeContactAnalysisSupportedChannel channel() {
        return RealTimeContactAnalysisSupportedChannel.fromValue(this.channel);
    }

    public final String channelAsString() {
        return this.channel;
    }

    public final RealTimeContactAnalysisStatus status() {
        return RealTimeContactAnalysisStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasSegments() {
        return this.segments != null && !(this.segments instanceof SdkAutoConstructList);
    }

    public final List<RealtimeContactAnalysisSegment> segments() {
        return this.segments;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSegments() ? this.segments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRealtimeContactAnalysisSegmentsV2Response)) {
            return false;
        }
        ListRealtimeContactAnalysisSegmentsV2Response other = (ListRealtimeContactAnalysisSegmentsV2Response)((Object)obj);
        return Objects.equals(this.channelAsString(), other.channelAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasSegments() == other.hasSegments() && Objects.equals(this.segments(), other.segments()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRealtimeContactAnalysisSegmentsV2Response").add("Channel", (Object)this.channelAsString()).add("Status", (Object)this.statusAsString()).add("Segments", this.hasSegments() ? this.segments() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Channel": {
                return Optional.ofNullable(clazz.cast(this.channelAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Segments": {
                return Optional.ofNullable(clazz.cast(this.segments()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Channel", CHANNEL_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Segments", SEGMENTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRealtimeContactAnalysisSegmentsV2Response, T> g) {
        return obj -> g.apply((ListRealtimeContactAnalysisSegmentsV2Response)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private String channel;
        private String status;
        private List<RealtimeContactAnalysisSegment> segments = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRealtimeContactAnalysisSegmentsV2Response model) {
            super(model);
            this.channel(model.channel);
            this.status(model.status);
            this.segments(model.segments);
            this.nextToken(model.nextToken);
        }

        public final String getChannel() {
            return this.channel;
        }

        public final void setChannel(String channel) {
            this.channel = channel;
        }

        @Override
        public final Builder channel(String channel) {
            this.channel = channel;
            return this;
        }

        @Override
        public final Builder channel(RealTimeContactAnalysisSupportedChannel channel) {
            this.channel(channel == null ? null : channel.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RealTimeContactAnalysisStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<RealtimeContactAnalysisSegment.Builder> getSegments() {
            List<RealtimeContactAnalysisSegment.Builder> result = RealtimeContactAnalysisSegmentsCopier.copyToBuilder(this.segments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSegments(Collection<RealtimeContactAnalysisSegment.BuilderImpl> segments) {
            this.segments = RealtimeContactAnalysisSegmentsCopier.copyFromBuilder(segments);
        }

        @Override
        public final Builder segments(Collection<RealtimeContactAnalysisSegment> segments) {
            this.segments = RealtimeContactAnalysisSegmentsCopier.copy(segments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segments(RealtimeContactAnalysisSegment ... segments) {
            this.segments(Arrays.asList(segments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segments(Consumer<RealtimeContactAnalysisSegment.Builder> ... segments) {
            this.segments(Stream.of(segments).map(c -> (RealtimeContactAnalysisSegment)((RealtimeContactAnalysisSegment.Builder)RealtimeContactAnalysisSegment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRealtimeContactAnalysisSegmentsV2Response build() {
            return new ListRealtimeContactAnalysisSegmentsV2Response(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRealtimeContactAnalysisSegmentsV2Response> {
        public Builder channel(String var1);

        public Builder channel(RealTimeContactAnalysisSupportedChannel var1);

        public Builder status(String var1);

        public Builder status(RealTimeContactAnalysisStatus var1);

        public Builder segments(Collection<RealtimeContactAnalysisSegment> var1);

        public Builder segments(RealtimeContactAnalysisSegment ... var1);

        public Builder segments(Consumer<RealtimeContactAnalysisSegment.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

