/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.model.GetCurrentMetricDataRequest;
import software.amazon.awssdk.services.connect.model.GetCurrentMetricDataResponse;

public class GetCurrentMetricDataPublisher
implements SdkPublisher<GetCurrentMetricDataResponse> {
    private final ConnectAsyncClient client;
    private final GetCurrentMetricDataRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetCurrentMetricDataPublisher(ConnectAsyncClient client, GetCurrentMetricDataRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetCurrentMetricDataPublisher(ConnectAsyncClient client, GetCurrentMetricDataRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetCurrentMetricDataResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetCurrentMetricDataResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final GetCurrentMetricDataPublisher resume(GetCurrentMetricDataResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetCurrentMetricDataPublisher(this.client, (GetCurrentMetricDataRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetCurrentMetricDataPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super GetCurrentMetricDataResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class GetCurrentMetricDataResponseFetcher
    implements AsyncPageFetcher<GetCurrentMetricDataResponse> {
        private GetCurrentMetricDataResponseFetcher() {
        }

        public boolean hasNextPage(GetCurrentMetricDataResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetCurrentMetricDataResponse> nextPage(GetCurrentMetricDataResponse previousPage) {
            if (previousPage == null) {
                return GetCurrentMetricDataPublisher.this.client.getCurrentMetricData(GetCurrentMetricDataPublisher.this.firstRequest);
            }
            return GetCurrentMetricDataPublisher.this.client.getCurrentMetricData((GetCurrentMetricDataRequest)((Object)GetCurrentMetricDataPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

