/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ListSecurityProfilePermissionsRequest;
import software.amazon.awssdk.services.connect.model.ListSecurityProfilePermissionsResponse;

public class ListSecurityProfilePermissionsPublisher
implements SdkPublisher<ListSecurityProfilePermissionsResponse> {
    private final ConnectAsyncClient client;
    private final ListSecurityProfilePermissionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSecurityProfilePermissionsPublisher(ConnectAsyncClient client, ListSecurityProfilePermissionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSecurityProfilePermissionsPublisher(ConnectAsyncClient client, ListSecurityProfilePermissionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSecurityProfilePermissionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSecurityProfilePermissionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> permissions() {
        Function<ListSecurityProfilePermissionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.permissions() != null) {
                return response.permissions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSecurityProfilePermissionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSecurityProfilePermissionsResponseFetcher
    implements AsyncPageFetcher<ListSecurityProfilePermissionsResponse> {
        private ListSecurityProfilePermissionsResponseFetcher() {
        }

        public boolean hasNextPage(ListSecurityProfilePermissionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSecurityProfilePermissionsResponse> nextPage(ListSecurityProfilePermissionsResponse previousPage) {
            if (previousPage == null) {
                return ListSecurityProfilePermissionsPublisher.this.client.listSecurityProfilePermissions(ListSecurityProfilePermissionsPublisher.this.firstRequest);
            }
            return ListSecurityProfilePermissionsPublisher.this.client.listSecurityProfilePermissions((ListSecurityProfilePermissionsRequest)((Object)ListSecurityProfilePermissionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

