/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ViewType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ViewVersionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ViewVersionSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ViewVersionSummary.getter(ViewVersionSummary::id)).setter(ViewVersionSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ViewVersionSummary.getter(ViewVersionSummary::arn)).setter(ViewVersionSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ViewVersionSummary.getter(ViewVersionSummary::description)).setter(ViewVersionSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ViewVersionSummary.getter(ViewVersionSummary::name)).setter(ViewVersionSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ViewVersionSummary.getter(ViewVersionSummary::typeAsString)).setter(ViewVersionSummary.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Integer> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Version").getter(ViewVersionSummary.getter(ViewVersionSummary::version)).setter(ViewVersionSummary.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<String> VERSION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionDescription").getter(ViewVersionSummary.getter(ViewVersionSummary::versionDescription)).setter(ViewVersionSummary.setter(Builder::versionDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, DESCRIPTION_FIELD, NAME_FIELD, TYPE_FIELD, VERSION_FIELD, VERSION_DESCRIPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final String description;
    private final String name;
    private final String type;
    private final Integer version;
    private final String versionDescription;

    private ViewVersionSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.description = builder.description;
        this.name = builder.name;
        this.type = builder.type;
        this.version = builder.version;
        this.versionDescription = builder.versionDescription;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String description() {
        return this.description;
    }

    public final String name() {
        return this.name;
    }

    public final ViewType type() {
        return ViewType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Integer version() {
        return this.version;
    }

    public final String versionDescription() {
        return this.versionDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionDescription());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ViewVersionSummary)) {
            return false;
        }
        ViewVersionSummary other = (ViewVersionSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.versionDescription(), other.versionDescription());
    }

    public final String toString() {
        return ToString.builder((String)"ViewVersionSummary").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("Description", (Object)this.description()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Type", (Object)this.typeAsString()).add("Version", (Object)this.version()).add("VersionDescription", (Object)this.versionDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "VersionDescription": {
                return Optional.ofNullable(clazz.cast(this.versionDescription()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ViewVersionSummary, T> g) {
        return obj -> g.apply((ViewVersionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String description;
        private String name;
        private String type;
        private Integer version;
        private String versionDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(ViewVersionSummary model) {
            this.id(model.id);
            this.arn(model.arn);
            this.description(model.description);
            this.name(model.name);
            this.type(model.type);
            this.version(model.version);
            this.versionDescription(model.versionDescription);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ViewType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Integer getVersion() {
            return this.version;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final String getVersionDescription() {
            return this.versionDescription;
        }

        public final void setVersionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
        }

        @Override
        public final Builder versionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
            return this;
        }

        public ViewVersionSummary build() {
            return new ViewVersionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ViewVersionSummary> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder description(String var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(ViewType var1);

        public Builder version(Integer var1);

        public Builder versionDescription(String var1);
    }
}

