/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BehaviorType {
    ROUTE_CURRENT_CHANNEL_ONLY("ROUTE_CURRENT_CHANNEL_ONLY"),
    ROUTE_ANY_CHANNEL("ROUTE_ANY_CHANNEL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BehaviorType> VALUE_MAP;
    private final String value;

    private BehaviorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BehaviorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BehaviorType> knownValues() {
        EnumSet<BehaviorType> knownValues = EnumSet.allOf(BehaviorType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BehaviorType.class, BehaviorType::toString);
    }
}

