/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.HoursOfOperationSummary;
import software.amazon.awssdk.services.connect.model.ListHoursOfOperationsRequest;
import software.amazon.awssdk.services.connect.model.ListHoursOfOperationsResponse;

public class ListHoursOfOperationsPublisher
implements SdkPublisher<ListHoursOfOperationsResponse> {
    private final ConnectAsyncClient client;
    private final ListHoursOfOperationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListHoursOfOperationsPublisher(ConnectAsyncClient client, ListHoursOfOperationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListHoursOfOperationsPublisher(ConnectAsyncClient client, ListHoursOfOperationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListHoursOfOperationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListHoursOfOperationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<HoursOfOperationSummary> hoursOfOperationSummaryList() {
        Function<ListHoursOfOperationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.hoursOfOperationSummaryList() != null) {
                return response.hoursOfOperationSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListHoursOfOperationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListHoursOfOperationsResponseFetcher
    implements AsyncPageFetcher<ListHoursOfOperationsResponse> {
        private ListHoursOfOperationsResponseFetcher() {
        }

        public boolean hasNextPage(ListHoursOfOperationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListHoursOfOperationsResponse> nextPage(ListHoursOfOperationsResponse previousPage) {
            if (previousPage == null) {
                return ListHoursOfOperationsPublisher.this.client.listHoursOfOperations(ListHoursOfOperationsPublisher.this.firstRequest);
            }
            return ListHoursOfOperationsPublisher.this.client.listHoursOfOperations((ListHoursOfOperationsRequest)((Object)ListHoursOfOperationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

