/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.model.SearchVocabulariesRequest;
import software.amazon.awssdk.services.connect.model.SearchVocabulariesResponse;
import software.amazon.awssdk.services.connect.model.VocabularySummary;

public class SearchVocabulariesIterable
implements SdkIterable<SearchVocabulariesResponse> {
    private final ConnectClient client;
    private final SearchVocabulariesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchVocabulariesIterable(ConnectClient client, SearchVocabulariesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new SearchVocabulariesResponseFetcher();
    }

    public Iterator<SearchVocabulariesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<VocabularySummary> vocabularySummaryList() {
        Function<SearchVocabulariesResponse, Iterator> getIterator = response -> {
            if (response != null && response.vocabularySummaryList() != null) {
                return response.vocabularySummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchVocabulariesResponseFetcher
    implements SyncPageFetcher<SearchVocabulariesResponse> {
        private SearchVocabulariesResponseFetcher() {
        }

        public boolean hasNextPage(SearchVocabulariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchVocabulariesResponse nextPage(SearchVocabulariesResponse previousPage) {
            if (previousPage == null) {
                return SearchVocabulariesIterable.this.client.searchVocabularies(SearchVocabulariesIterable.this.firstRequest);
            }
            return SearchVocabulariesIterable.this.client.searchVocabularies((SearchVocabulariesRequest)((Object)SearchVocabulariesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

