/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.UserIdentityInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateUserIdentityInfoRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, UpdateUserIdentityInfoRequest> {
    private static final SdkField<UserIdentityInfo> IDENTITY_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IdentityInfo").getter(UpdateUserIdentityInfoRequest.getter(UpdateUserIdentityInfoRequest::identityInfo)).setter(UpdateUserIdentityInfoRequest.setter(Builder::identityInfo)).constructor(UserIdentityInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityInfo").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserId").getter(UpdateUserIdentityInfoRequest.getter(UpdateUserIdentityInfoRequest::userId)).setter(UpdateUserIdentityInfoRequest.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("UserId").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(UpdateUserIdentityInfoRequest.getter(UpdateUserIdentityInfoRequest::instanceId)).setter(UpdateUserIdentityInfoRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_INFO_FIELD, USER_ID_FIELD, INSTANCE_ID_FIELD));
    private final UserIdentityInfo identityInfo;
    private final String userId;
    private final String instanceId;

    private UpdateUserIdentityInfoRequest(BuilderImpl builder) {
        super(builder);
        this.identityInfo = builder.identityInfo;
        this.userId = builder.userId;
        this.instanceId = builder.instanceId;
    }

    public final UserIdentityInfo identityInfo() {
        return this.identityInfo;
    }

    public final String userId() {
        return this.userId;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identityInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserIdentityInfoRequest)) {
            return false;
        }
        UpdateUserIdentityInfoRequest other = (UpdateUserIdentityInfoRequest)((Object)obj);
        return Objects.equals(this.identityInfo(), other.identityInfo()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.instanceId(), other.instanceId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateUserIdentityInfoRequest").add("IdentityInfo", (Object)this.identityInfo()).add("UserId", (Object)this.userId()).add("InstanceId", (Object)this.instanceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityInfo": {
                return Optional.ofNullable(clazz.cast(this.identityInfo()));
            }
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserIdentityInfoRequest, T> g) {
        return obj -> g.apply((UpdateUserIdentityInfoRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private UserIdentityInfo identityInfo;
        private String userId;
        private String instanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserIdentityInfoRequest model) {
            super(model);
            this.identityInfo(model.identityInfo);
            this.userId(model.userId);
            this.instanceId(model.instanceId);
        }

        public final UserIdentityInfo.Builder getIdentityInfo() {
            return this.identityInfo != null ? this.identityInfo.toBuilder() : null;
        }

        public final void setIdentityInfo(UserIdentityInfo.BuilderImpl identityInfo) {
            this.identityInfo = identityInfo != null ? identityInfo.build() : null;
        }

        @Override
        public final Builder identityInfo(UserIdentityInfo identityInfo) {
            this.identityInfo = identityInfo;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserIdentityInfoRequest build() {
            return new UpdateUserIdentityInfoRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateUserIdentityInfoRequest> {
        public Builder identityInfo(UserIdentityInfo var1);

        default public Builder identityInfo(Consumer<UserIdentityInfo.Builder> identityInfo) {
            return this.identityInfo((UserIdentityInfo)((UserIdentityInfo.Builder)UserIdentityInfo.builder().applyMutation(identityInfo)).build());
        }

        public Builder userId(String var1);

        public Builder instanceId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

