/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.AvailableNumberSummary;
import software.amazon.awssdk.services.connect.model.AvailableNumbersListCopier;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchAvailablePhoneNumbersResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, SearchAvailablePhoneNumbersResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchAvailablePhoneNumbersResponse.getter(SearchAvailablePhoneNumbersResponse::nextToken)).setter(SearchAvailablePhoneNumbersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<AvailableNumberSummary>> AVAILABLE_NUMBERS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailableNumbersList").getter(SearchAvailablePhoneNumbersResponse.getter(SearchAvailablePhoneNumbersResponse::availableNumbersList)).setter(SearchAvailablePhoneNumbersResponse.setter(Builder::availableNumbersList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableNumbersList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AvailableNumberSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, AVAILABLE_NUMBERS_LIST_FIELD));
    private final String nextToken;
    private final List<AvailableNumberSummary> availableNumbersList;

    private SearchAvailablePhoneNumbersResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.availableNumbersList = builder.availableNumbersList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasAvailableNumbersList() {
        return this.availableNumbersList != null && !(this.availableNumbersList instanceof SdkAutoConstructList);
    }

    public final List<AvailableNumberSummary> availableNumbersList() {
        return this.availableNumbersList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailableNumbersList() ? this.availableNumbersList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchAvailablePhoneNumbersResponse)) {
            return false;
        }
        SearchAvailablePhoneNumbersResponse other = (SearchAvailablePhoneNumbersResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasAvailableNumbersList() == other.hasAvailableNumbersList() && Objects.equals(this.availableNumbersList(), other.availableNumbersList());
    }

    public final String toString() {
        return ToString.builder((String)"SearchAvailablePhoneNumbersResponse").add("NextToken", (Object)this.nextToken()).add("AvailableNumbersList", this.hasAvailableNumbersList() ? this.availableNumbersList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "AvailableNumbersList": {
                return Optional.ofNullable(clazz.cast(this.availableNumbersList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchAvailablePhoneNumbersResponse, T> g) {
        return obj -> g.apply((SearchAvailablePhoneNumbersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<AvailableNumberSummary> availableNumbersList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchAvailablePhoneNumbersResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.availableNumbersList(model.availableNumbersList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<AvailableNumberSummary.Builder> getAvailableNumbersList() {
            List<AvailableNumberSummary.Builder> result = AvailableNumbersListCopier.copyToBuilder(this.availableNumbersList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAvailableNumbersList(Collection<AvailableNumberSummary.BuilderImpl> availableNumbersList) {
            this.availableNumbersList = AvailableNumbersListCopier.copyFromBuilder(availableNumbersList);
        }

        @Override
        public final Builder availableNumbersList(Collection<AvailableNumberSummary> availableNumbersList) {
            this.availableNumbersList = AvailableNumbersListCopier.copy(availableNumbersList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availableNumbersList(AvailableNumberSummary ... availableNumbersList) {
            this.availableNumbersList(Arrays.asList(availableNumbersList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availableNumbersList(Consumer<AvailableNumberSummary.Builder> ... availableNumbersList) {
            this.availableNumbersList(Stream.of(availableNumbersList).map(c -> (AvailableNumberSummary)((AvailableNumberSummary.Builder)AvailableNumberSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SearchAvailablePhoneNumbersResponse build() {
            return new SearchAvailablePhoneNumbersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchAvailablePhoneNumbersResponse> {
        public Builder nextToken(String var1);

        public Builder availableNumbersList(Collection<AvailableNumberSummary> var1);

        public Builder availableNumbersList(AvailableNumberSummary ... var1);

        public Builder availableNumbersList(Consumer<AvailableNumberSummary.Builder> ... var1);
    }
}

