/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.model.ListRoutingProfilesRequest;
import software.amazon.awssdk.services.connect.model.ListRoutingProfilesResponse;
import software.amazon.awssdk.services.connect.model.RoutingProfileSummary;

public class ListRoutingProfilesIterable
implements SdkIterable<ListRoutingProfilesResponse> {
    private final ConnectClient client;
    private final ListRoutingProfilesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRoutingProfilesIterable(ConnectClient client, ListRoutingProfilesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListRoutingProfilesResponseFetcher();
    }

    public Iterator<ListRoutingProfilesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RoutingProfileSummary> routingProfileSummaryList() {
        Function<ListRoutingProfilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.routingProfileSummaryList() != null) {
                return response.routingProfileSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRoutingProfilesResponseFetcher
    implements SyncPageFetcher<ListRoutingProfilesResponse> {
        private ListRoutingProfilesResponseFetcher() {
        }

        public boolean hasNextPage(ListRoutingProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRoutingProfilesResponse nextPage(ListRoutingProfilesResponse previousPage) {
            if (previousPage == null) {
                return ListRoutingProfilesIterable.this.client.listRoutingProfiles(ListRoutingProfilesIterable.this.firstRequest);
            }
            return ListRoutingProfilesIterable.this.client.listRoutingProfiles((ListRoutingProfilesRequest)((Object)ListRoutingProfilesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

