/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.HoursOfOperationSummary;
import software.amazon.awssdk.services.connect.model.HoursOfOperationSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListHoursOfOperationsResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListHoursOfOperationsResponse> {
    private static final SdkField<List<HoursOfOperationSummary>> HOURS_OF_OPERATION_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HoursOfOperationSummaryList").getter(ListHoursOfOperationsResponse.getter(ListHoursOfOperationsResponse::hoursOfOperationSummaryList)).setter(ListHoursOfOperationsResponse.setter(Builder::hoursOfOperationSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HoursOfOperationSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HoursOfOperationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListHoursOfOperationsResponse.getter(ListHoursOfOperationsResponse::nextToken)).setter(ListHoursOfOperationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOURS_OF_OPERATION_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<HoursOfOperationSummary> hoursOfOperationSummaryList;
    private final String nextToken;

    private ListHoursOfOperationsResponse(BuilderImpl builder) {
        super(builder);
        this.hoursOfOperationSummaryList = builder.hoursOfOperationSummaryList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasHoursOfOperationSummaryList() {
        return this.hoursOfOperationSummaryList != null && !(this.hoursOfOperationSummaryList instanceof SdkAutoConstructList);
    }

    public final List<HoursOfOperationSummary> hoursOfOperationSummaryList() {
        return this.hoursOfOperationSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHoursOfOperationSummaryList() ? this.hoursOfOperationSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHoursOfOperationsResponse)) {
            return false;
        }
        ListHoursOfOperationsResponse other = (ListHoursOfOperationsResponse)((Object)obj);
        return this.hasHoursOfOperationSummaryList() == other.hasHoursOfOperationSummaryList() && Objects.equals(this.hoursOfOperationSummaryList(), other.hoursOfOperationSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListHoursOfOperationsResponse").add("HoursOfOperationSummaryList", this.hasHoursOfOperationSummaryList() ? this.hoursOfOperationSummaryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HoursOfOperationSummaryList": {
                return Optional.ofNullable(clazz.cast(this.hoursOfOperationSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListHoursOfOperationsResponse, T> g) {
        return obj -> g.apply((ListHoursOfOperationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<HoursOfOperationSummary> hoursOfOperationSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHoursOfOperationsResponse model) {
            super(model);
            this.hoursOfOperationSummaryList(model.hoursOfOperationSummaryList);
            this.nextToken(model.nextToken);
        }

        public final Collection<HoursOfOperationSummary.Builder> getHoursOfOperationSummaryList() {
            if (this.hoursOfOperationSummaryList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.hoursOfOperationSummaryList != null ? (Collection)this.hoursOfOperationSummaryList.stream().map(HoursOfOperationSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder hoursOfOperationSummaryList(Collection<HoursOfOperationSummary> hoursOfOperationSummaryList) {
            this.hoursOfOperationSummaryList = HoursOfOperationSummaryListCopier.copy(hoursOfOperationSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hoursOfOperationSummaryList(HoursOfOperationSummary ... hoursOfOperationSummaryList) {
            this.hoursOfOperationSummaryList(Arrays.asList(hoursOfOperationSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hoursOfOperationSummaryList(Consumer<HoursOfOperationSummary.Builder> ... hoursOfOperationSummaryList) {
            this.hoursOfOperationSummaryList(Stream.of(hoursOfOperationSummaryList).map(c -> (HoursOfOperationSummary)((HoursOfOperationSummary.Builder)HoursOfOperationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHoursOfOperationSummaryList(Collection<HoursOfOperationSummary.BuilderImpl> hoursOfOperationSummaryList) {
            this.hoursOfOperationSummaryList = HoursOfOperationSummaryListCopier.copyFromBuilder(hoursOfOperationSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListHoursOfOperationsResponse build() {
            return new ListHoursOfOperationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListHoursOfOperationsResponse> {
        public Builder hoursOfOperationSummaryList(Collection<HoursOfOperationSummary> var1);

        public Builder hoursOfOperationSummaryList(HoursOfOperationSummary ... var1);

        public Builder hoursOfOperationSummaryList(Consumer<HoursOfOperationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

