/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.model.GetCurrentMetricDataRequest;
import software.amazon.awssdk.services.connect.model.GetCurrentMetricDataResponse;

public class GetCurrentMetricDataIterable
implements SdkIterable<GetCurrentMetricDataResponse> {
    private final ConnectClient client;
    private final GetCurrentMetricDataRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetCurrentMetricDataIterable(ConnectClient client, GetCurrentMetricDataRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetCurrentMetricDataResponseFetcher();
    }

    public Iterator<GetCurrentMetricDataResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final GetCurrentMetricDataIterable resume(GetCurrentMetricDataResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetCurrentMetricDataIterable(this.client, (GetCurrentMetricDataRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetCurrentMetricDataIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetCurrentMetricDataResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetCurrentMetricDataResponseFetcher
    implements SyncPageFetcher<GetCurrentMetricDataResponse> {
        private GetCurrentMetricDataResponseFetcher() {
        }

        public boolean hasNextPage(GetCurrentMetricDataResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetCurrentMetricDataResponse nextPage(GetCurrentMetricDataResponse previousPage) {
            if (previousPage == null) {
                return GetCurrentMetricDataIterable.this.client.getCurrentMetricData(GetCurrentMetricDataIterable.this.firstRequest);
            }
            return GetCurrentMetricDataIterable.this.client.getCurrentMetricData((GetCurrentMetricDataRequest)((Object)GetCurrentMetricDataIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

