/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigClient;
import software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsRequest;
import software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsResponse;

public class GetDiscoveredResourceCountsIterable
implements SdkIterable<GetDiscoveredResourceCountsResponse> {
    private final ConfigClient client;
    private final GetDiscoveredResourceCountsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetDiscoveredResourceCountsIterable(ConfigClient client, GetDiscoveredResourceCountsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetDiscoveredResourceCountsResponseFetcher();
    }

    public Iterator<GetDiscoveredResourceCountsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetDiscoveredResourceCountsResponseFetcher
    implements SyncPageFetcher<GetDiscoveredResourceCountsResponse> {
        private GetDiscoveredResourceCountsResponseFetcher() {
        }

        public boolean hasNextPage(GetDiscoveredResourceCountsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetDiscoveredResourceCountsResponse nextPage(GetDiscoveredResourceCountsResponse previousPage) {
            if (previousPage == null) {
                return GetDiscoveredResourceCountsIterable.this.client.getDiscoveredResourceCounts(GetDiscoveredResourceCountsIterable.this.firstRequest);
            }
            return GetDiscoveredResourceCountsIterable.this.client.getDiscoveredResourceCounts((GetDiscoveredResourceCountsRequest)((Object)GetDiscoveredResourceCountsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

