/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigAsyncClient;
import software.amazon.awssdk.services.config.model.ListStoredQueriesRequest;
import software.amazon.awssdk.services.config.model.ListStoredQueriesResponse;

public class ListStoredQueriesPublisher
implements SdkPublisher<ListStoredQueriesResponse> {
    private final ConfigAsyncClient client;
    private final ListStoredQueriesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStoredQueriesPublisher(ConfigAsyncClient client, ListStoredQueriesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStoredQueriesPublisher(ConfigAsyncClient client, ListStoredQueriesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStoredQueriesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStoredQueriesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListStoredQueriesResponseFetcher
    implements AsyncPageFetcher<ListStoredQueriesResponse> {
        private ListStoredQueriesResponseFetcher() {
        }

        public boolean hasNextPage(ListStoredQueriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListStoredQueriesResponse> nextPage(ListStoredQueriesResponse previousPage) {
            if (previousPage == null) {
                return ListStoredQueriesPublisher.this.client.listStoredQueries(ListStoredQueriesPublisher.this.firstRequest);
            }
            return ListStoredQueriesPublisher.this.client.listStoredQueries((ListStoredQueriesRequest)((Object)ListStoredQueriesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

