/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.ConfigSnapshotDeliveryProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeliveryChannel
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeliveryChannel> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(DeliveryChannel.getter(DeliveryChannel::name)).setter(DeliveryChannel.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3BucketName").getter(DeliveryChannel.getter(DeliveryChannel::s3BucketName)).setter(DeliveryChannel.setter(Builder::s3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3BucketName").build()}).build();
    private static final SdkField<String> S3_KEY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3KeyPrefix").getter(DeliveryChannel.getter(DeliveryChannel::s3KeyPrefix)).setter(DeliveryChannel.setter(Builder::s3KeyPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3KeyPrefix").build()}).build();
    private static final SdkField<String> S3_KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3KmsKeyArn").getter(DeliveryChannel.getter(DeliveryChannel::s3KmsKeyArn)).setter(DeliveryChannel.setter(Builder::s3KmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3KmsKeyArn").build()}).build();
    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("snsTopicARN").getter(DeliveryChannel.getter(DeliveryChannel::snsTopicARN)).setter(DeliveryChannel.setter(Builder::snsTopicARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snsTopicARN").build()}).build();
    private static final SdkField<ConfigSnapshotDeliveryProperties> CONFIG_SNAPSHOT_DELIVERY_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configSnapshotDeliveryProperties").getter(DeliveryChannel.getter(DeliveryChannel::configSnapshotDeliveryProperties)).setter(DeliveryChannel.setter(Builder::configSnapshotDeliveryProperties)).constructor(ConfigSnapshotDeliveryProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configSnapshotDeliveryProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, S3_BUCKET_NAME_FIELD, S3_KEY_PREFIX_FIELD, S3_KMS_KEY_ARN_FIELD, SNS_TOPIC_ARN_FIELD, CONFIG_SNAPSHOT_DELIVERY_PROPERTIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String s3BucketName;
    private final String s3KeyPrefix;
    private final String s3KmsKeyArn;
    private final String snsTopicARN;
    private final ConfigSnapshotDeliveryProperties configSnapshotDeliveryProperties;

    private DeliveryChannel(BuilderImpl builder) {
        this.name = builder.name;
        this.s3BucketName = builder.s3BucketName;
        this.s3KeyPrefix = builder.s3KeyPrefix;
        this.s3KmsKeyArn = builder.s3KmsKeyArn;
        this.snsTopicARN = builder.snsTopicARN;
        this.configSnapshotDeliveryProperties = builder.configSnapshotDeliveryProperties;
    }

    public final String name() {
        return this.name;
    }

    public final String s3BucketName() {
        return this.s3BucketName;
    }

    public final String s3KeyPrefix() {
        return this.s3KeyPrefix;
    }

    public final String s3KmsKeyArn() {
        return this.s3KmsKeyArn;
    }

    public final String snsTopicARN() {
        return this.snsTopicARN;
    }

    public final ConfigSnapshotDeliveryProperties configSnapshotDeliveryProperties() {
        return this.configSnapshotDeliveryProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3KeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3KmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopicARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.configSnapshotDeliveryProperties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeliveryChannel)) {
            return false;
        }
        DeliveryChannel other = (DeliveryChannel)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.s3BucketName(), other.s3BucketName()) && Objects.equals(this.s3KeyPrefix(), other.s3KeyPrefix()) && Objects.equals(this.s3KmsKeyArn(), other.s3KmsKeyArn()) && Objects.equals(this.snsTopicARN(), other.snsTopicARN()) && Objects.equals(this.configSnapshotDeliveryProperties(), other.configSnapshotDeliveryProperties());
    }

    public final String toString() {
        return ToString.builder((String)"DeliveryChannel").add("Name", (Object)this.name()).add("S3BucketName", (Object)this.s3BucketName()).add("S3KeyPrefix", (Object)this.s3KeyPrefix()).add("S3KmsKeyArn", (Object)this.s3KmsKeyArn()).add("SnsTopicARN", (Object)this.snsTopicARN()).add("ConfigSnapshotDeliveryProperties", (Object)this.configSnapshotDeliveryProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "s3BucketName": {
                return Optional.ofNullable(clazz.cast(this.s3BucketName()));
            }
            case "s3KeyPrefix": {
                return Optional.ofNullable(clazz.cast(this.s3KeyPrefix()));
            }
            case "s3KmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.s3KmsKeyArn()));
            }
            case "snsTopicARN": {
                return Optional.ofNullable(clazz.cast(this.snsTopicARN()));
            }
            case "configSnapshotDeliveryProperties": {
                return Optional.ofNullable(clazz.cast(this.configSnapshotDeliveryProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeliveryChannel, T> g) {
        return obj -> g.apply((DeliveryChannel)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String s3BucketName;
        private String s3KeyPrefix;
        private String s3KmsKeyArn;
        private String snsTopicARN;
        private ConfigSnapshotDeliveryProperties configSnapshotDeliveryProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(DeliveryChannel model) {
            this.name(model.name);
            this.s3BucketName(model.s3BucketName);
            this.s3KeyPrefix(model.s3KeyPrefix);
            this.s3KmsKeyArn(model.s3KmsKeyArn);
            this.snsTopicARN(model.snsTopicARN);
            this.configSnapshotDeliveryProperties(model.configSnapshotDeliveryProperties);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getS3BucketName() {
            return this.s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        public final String getS3KeyPrefix() {
            return this.s3KeyPrefix;
        }

        @Override
        public final Builder s3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        public final void setS3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
        }

        public final String getS3KmsKeyArn() {
            return this.s3KmsKeyArn;
        }

        @Override
        public final Builder s3KmsKeyArn(String s3KmsKeyArn) {
            this.s3KmsKeyArn = s3KmsKeyArn;
            return this;
        }

        public final void setS3KmsKeyArn(String s3KmsKeyArn) {
            this.s3KmsKeyArn = s3KmsKeyArn;
        }

        public final String getSnsTopicARN() {
            return this.snsTopicARN;
        }

        @Override
        public final Builder snsTopicARN(String snsTopicARN) {
            this.snsTopicARN = snsTopicARN;
            return this;
        }

        public final void setSnsTopicARN(String snsTopicARN) {
            this.snsTopicARN = snsTopicARN;
        }

        public final ConfigSnapshotDeliveryProperties.Builder getConfigSnapshotDeliveryProperties() {
            return this.configSnapshotDeliveryProperties != null ? this.configSnapshotDeliveryProperties.toBuilder() : null;
        }

        @Override
        public final Builder configSnapshotDeliveryProperties(ConfigSnapshotDeliveryProperties configSnapshotDeliveryProperties) {
            this.configSnapshotDeliveryProperties = configSnapshotDeliveryProperties;
            return this;
        }

        public final void setConfigSnapshotDeliveryProperties(ConfigSnapshotDeliveryProperties.BuilderImpl configSnapshotDeliveryProperties) {
            this.configSnapshotDeliveryProperties = configSnapshotDeliveryProperties != null ? configSnapshotDeliveryProperties.build() : null;
        }

        public DeliveryChannel build() {
            return new DeliveryChannel(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeliveryChannel> {
        public Builder name(String var1);

        public Builder s3BucketName(String var1);

        public Builder s3KeyPrefix(String var1);

        public Builder s3KmsKeyArn(String var1);

        public Builder snsTopicARN(String var1);

        public Builder configSnapshotDeliveryProperties(ConfigSnapshotDeliveryProperties var1);

        default public Builder configSnapshotDeliveryProperties(Consumer<ConfigSnapshotDeliveryProperties.Builder> configSnapshotDeliveryProperties) {
            return this.configSnapshotDeliveryProperties((ConfigSnapshotDeliveryProperties)((ConfigSnapshotDeliveryProperties.Builder)ConfigSnapshotDeliveryProperties.builder().applyMutation(configSnapshotDeliveryProperties)).build());
        }
    }
}

