/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizerautomation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.computeoptimizerautomation.ComputeOptimizerAutomationClient;
import software.amazon.awssdk.services.computeoptimizerautomation.internal.UserAgentUtils;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ListAutomationRulePreviewRequest;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ListAutomationRulePreviewResponse;
import software.amazon.awssdk.services.computeoptimizerautomation.model.PreviewResult;

public class ListAutomationRulePreviewIterable
implements SdkIterable<ListAutomationRulePreviewResponse> {
    private final ComputeOptimizerAutomationClient client;
    private final ListAutomationRulePreviewRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAutomationRulePreviewIterable(ComputeOptimizerAutomationClient client, ListAutomationRulePreviewRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAutomationRulePreviewResponseFetcher();
    }

    public Iterator<ListAutomationRulePreviewResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PreviewResult> previewResults() {
        Function<ListAutomationRulePreviewResponse, Iterator> getIterator = response -> {
            if (response != null && response.previewResults() != null) {
                return response.previewResults().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAutomationRulePreviewResponseFetcher
    implements SyncPageFetcher<ListAutomationRulePreviewResponse> {
        private ListAutomationRulePreviewResponseFetcher() {
        }

        public boolean hasNextPage(ListAutomationRulePreviewResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAutomationRulePreviewResponse nextPage(ListAutomationRulePreviewResponse previousPage) {
            if (previousPage == null) {
                return ListAutomationRulePreviewIterable.this.client.listAutomationRulePreview(ListAutomationRulePreviewIterable.this.firstRequest);
            }
            return ListAutomationRulePreviewIterable.this.client.listAutomationRulePreview((ListAutomationRulePreviewRequest)((Object)ListAutomationRulePreviewIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

