/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizerautomation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ComputeOptimizerAutomationResponse;
import software.amazon.awssdk.services.computeoptimizerautomation.model.PreviewResult;
import software.amazon.awssdk.services.computeoptimizerautomation.model.PreviewResultsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAutomationRulePreviewResponse
extends ComputeOptimizerAutomationResponse
implements ToCopyableBuilder<Builder, ListAutomationRulePreviewResponse> {
    private static final SdkField<List<PreviewResult>> PREVIEW_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("previewResults").getter(ListAutomationRulePreviewResponse.getter(ListAutomationRulePreviewResponse::previewResults)).setter(ListAutomationRulePreviewResponse.setter(Builder::previewResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("previewResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PreviewResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAutomationRulePreviewResponse.getter(ListAutomationRulePreviewResponse::nextToken)).setter(ListAutomationRulePreviewResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREVIEW_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAutomationRulePreviewResponse.memberNameToFieldInitializer();
    private final List<PreviewResult> previewResults;
    private final String nextToken;

    private ListAutomationRulePreviewResponse(BuilderImpl builder) {
        super(builder);
        this.previewResults = builder.previewResults;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPreviewResults() {
        return this.previewResults != null && !(this.previewResults instanceof SdkAutoConstructList);
    }

    public final List<PreviewResult> previewResults() {
        return this.previewResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPreviewResults() ? this.previewResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAutomationRulePreviewResponse)) {
            return false;
        }
        ListAutomationRulePreviewResponse other = (ListAutomationRulePreviewResponse)((Object)obj);
        return this.hasPreviewResults() == other.hasPreviewResults() && Objects.equals(this.previewResults(), other.previewResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAutomationRulePreviewResponse").add("PreviewResults", this.hasPreviewResults() ? this.previewResults() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "previewResults": {
                return Optional.ofNullable(clazz.cast(this.previewResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("previewResults", PREVIEW_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAutomationRulePreviewResponse, T> g) {
        return obj -> g.apply((ListAutomationRulePreviewResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComputeOptimizerAutomationResponse.BuilderImpl
    implements Builder {
        private List<PreviewResult> previewResults = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAutomationRulePreviewResponse model) {
            super(model);
            this.previewResults(model.previewResults);
            this.nextToken(model.nextToken);
        }

        public final List<PreviewResult.Builder> getPreviewResults() {
            List<PreviewResult.Builder> result = PreviewResultsCopier.copyToBuilder(this.previewResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPreviewResults(Collection<PreviewResult.BuilderImpl> previewResults) {
            this.previewResults = PreviewResultsCopier.copyFromBuilder(previewResults);
        }

        @Override
        public final Builder previewResults(Collection<PreviewResult> previewResults) {
            this.previewResults = PreviewResultsCopier.copy(previewResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder previewResults(PreviewResult ... previewResults) {
            this.previewResults(Arrays.asList(previewResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder previewResults(Consumer<PreviewResult.Builder> ... previewResults) {
            this.previewResults(Stream.of(previewResults).map(c -> (PreviewResult)((PreviewResult.Builder)PreviewResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAutomationRulePreviewResponse build() {
            return new ListAutomationRulePreviewResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ComputeOptimizerAutomationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAutomationRulePreviewResponse> {
        public Builder previewResults(Collection<PreviewResult> var1);

        public Builder previewResults(PreviewResult ... var1);

        public Builder previewResults(Consumer<PreviewResult.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

