/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizerautomation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.computeoptimizerautomation.ComputeOptimizerAutomationAsyncClient;
import software.amazon.awssdk.services.computeoptimizerautomation.internal.UserAgentUtils;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ListRecommendedActionSummariesRequest;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ListRecommendedActionSummariesResponse;
import software.amazon.awssdk.services.computeoptimizerautomation.model.RecommendedActionSummary;

public class ListRecommendedActionSummariesPublisher
implements SdkPublisher<ListRecommendedActionSummariesResponse> {
    private final ComputeOptimizerAutomationAsyncClient client;
    private final ListRecommendedActionSummariesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRecommendedActionSummariesPublisher(ComputeOptimizerAutomationAsyncClient client, ListRecommendedActionSummariesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRecommendedActionSummariesPublisher(ComputeOptimizerAutomationAsyncClient client, ListRecommendedActionSummariesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRecommendedActionSummariesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRecommendedActionSummariesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RecommendedActionSummary> recommendedActionSummaries() {
        Function<ListRecommendedActionSummariesResponse, Iterator> getIterator = response -> {
            if (response != null && response.recommendedActionSummaries() != null) {
                return response.recommendedActionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRecommendedActionSummariesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRecommendedActionSummariesResponseFetcher
    implements AsyncPageFetcher<ListRecommendedActionSummariesResponse> {
        private ListRecommendedActionSummariesResponseFetcher() {
        }

        public boolean hasNextPage(ListRecommendedActionSummariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRecommendedActionSummariesResponse> nextPage(ListRecommendedActionSummariesResponse previousPage) {
            if (previousPage == null) {
                return ListRecommendedActionSummariesPublisher.this.client.listRecommendedActionSummaries(ListRecommendedActionSummariesPublisher.this.firstRequest);
            }
            return ListRecommendedActionSummariesPublisher.this.client.listRecommendedActionSummaries((ListRecommendedActionSummariesRequest)((Object)ListRecommendedActionSummariesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

