/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizerautomation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.computeoptimizerautomation.ComputeOptimizerAutomationAsyncClient;
import software.amazon.awssdk.services.computeoptimizerautomation.internal.UserAgentUtils;
import software.amazon.awssdk.services.computeoptimizerautomation.model.AutomationEvent;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ListAutomationEventsRequest;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ListAutomationEventsResponse;

public class ListAutomationEventsPublisher
implements SdkPublisher<ListAutomationEventsResponse> {
    private final ComputeOptimizerAutomationAsyncClient client;
    private final ListAutomationEventsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAutomationEventsPublisher(ComputeOptimizerAutomationAsyncClient client, ListAutomationEventsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAutomationEventsPublisher(ComputeOptimizerAutomationAsyncClient client, ListAutomationEventsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAutomationEventsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAutomationEventsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AutomationEvent> automationEvents() {
        Function<ListAutomationEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.automationEvents() != null) {
                return response.automationEvents().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAutomationEventsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAutomationEventsResponseFetcher
    implements AsyncPageFetcher<ListAutomationEventsResponse> {
        private ListAutomationEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListAutomationEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAutomationEventsResponse> nextPage(ListAutomationEventsResponse previousPage) {
            if (previousPage == null) {
                return ListAutomationEventsPublisher.this.client.listAutomationEvents(ListAutomationEventsPublisher.this.firstRequest);
            }
            return ListAutomationEventsPublisher.this.client.listAutomationEvents((ListAutomationEventsRequest)((Object)ListAutomationEventsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

