/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizerautomation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.computeoptimizerautomation.ComputeOptimizerAutomationClient;
import software.amazon.awssdk.services.computeoptimizerautomation.internal.UserAgentUtils;
import software.amazon.awssdk.services.computeoptimizerautomation.model.AccountInfo;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ListAccountsRequest;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ListAccountsResponse;

public class ListAccountsIterable
implements SdkIterable<ListAccountsResponse> {
    private final ComputeOptimizerAutomationClient client;
    private final ListAccountsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAccountsIterable(ComputeOptimizerAutomationClient client, ListAccountsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAccountsResponseFetcher();
    }

    public Iterator<ListAccountsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AccountInfo> accounts() {
        Function<ListAccountsResponse, Iterator> getIterator = response -> {
            if (response != null && response.accounts() != null) {
                return response.accounts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAccountsResponseFetcher
    implements SyncPageFetcher<ListAccountsResponse> {
        private ListAccountsResponseFetcher() {
        }

        public boolean hasNextPage(ListAccountsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAccountsResponse nextPage(ListAccountsResponse previousPage) {
            if (previousPage == null) {
                return ListAccountsIterable.this.client.listAccounts(ListAccountsIterable.this.firstRequest);
            }
            return ListAccountsIterable.this.client.listAccounts((ListAccountsRequest)((Object)ListAccountsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

