/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizerautomation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ComputeOptimizerAutomationRequest;
import software.amazon.awssdk.services.computeoptimizerautomation.model.Criteria;
import software.amazon.awssdk.services.computeoptimizerautomation.model.OrganizationConfiguration;
import software.amazon.awssdk.services.computeoptimizerautomation.model.RecommendedActionType;
import software.amazon.awssdk.services.computeoptimizerautomation.model.RecommendedActionTypeListCopier;
import software.amazon.awssdk.services.computeoptimizerautomation.model.RuleStatus;
import software.amazon.awssdk.services.computeoptimizerautomation.model.RuleType;
import software.amazon.awssdk.services.computeoptimizerautomation.model.Schedule;
import software.amazon.awssdk.services.computeoptimizerautomation.model.Tag;
import software.amazon.awssdk.services.computeoptimizerautomation.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAutomationRuleRequest
extends ComputeOptimizerAutomationRequest
implements ToCopyableBuilder<Builder, CreateAutomationRuleRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateAutomationRuleRequest.getter(CreateAutomationRuleRequest::name)).setter(CreateAutomationRuleRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateAutomationRuleRequest.getter(CreateAutomationRuleRequest::description)).setter(CreateAutomationRuleRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> RULE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ruleType").getter(CreateAutomationRuleRequest.getter(CreateAutomationRuleRequest::ruleTypeAsString)).setter(CreateAutomationRuleRequest.setter(Builder::ruleType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleType").build()}).build();
    private static final SdkField<OrganizationConfiguration> ORGANIZATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("organizationConfiguration").getter(CreateAutomationRuleRequest.getter(CreateAutomationRuleRequest::organizationConfiguration)).setter(CreateAutomationRuleRequest.setter(Builder::organizationConfiguration)).constructor(OrganizationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationConfiguration").build()}).build();
    private static final SdkField<String> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("priority").getter(CreateAutomationRuleRequest.getter(CreateAutomationRuleRequest::priority)).setter(CreateAutomationRuleRequest.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()}).build();
    private static final SdkField<List<String>> RECOMMENDED_ACTION_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("recommendedActionTypes").getter(CreateAutomationRuleRequest.getter(CreateAutomationRuleRequest::recommendedActionTypesAsStrings)).setter(CreateAutomationRuleRequest.setter(Builder::recommendedActionTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendedActionTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Criteria> CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("criteria").getter(CreateAutomationRuleRequest.getter(CreateAutomationRuleRequest::criteria)).setter(CreateAutomationRuleRequest.setter(Builder::criteria)).constructor(Criteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("criteria").build()}).build();
    private static final SdkField<Schedule> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("schedule").getter(CreateAutomationRuleRequest.getter(CreateAutomationRuleRequest::schedule)).setter(CreateAutomationRuleRequest.setter(Builder::schedule)).constructor(Schedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedule").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CreateAutomationRuleRequest.getter(CreateAutomationRuleRequest::statusAsString)).setter(CreateAutomationRuleRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateAutomationRuleRequest.getter(CreateAutomationRuleRequest::tags)).setter(CreateAutomationRuleRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateAutomationRuleRequest.getter(CreateAutomationRuleRequest::clientToken)).setter(CreateAutomationRuleRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, RULE_TYPE_FIELD, ORGANIZATION_CONFIGURATION_FIELD, PRIORITY_FIELD, RECOMMENDED_ACTION_TYPES_FIELD, CRITERIA_FIELD, SCHEDULE_FIELD, STATUS_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAutomationRuleRequest.memberNameToFieldInitializer();
    private final String name;
    private final String description;
    private final String ruleType;
    private final OrganizationConfiguration organizationConfiguration;
    private final String priority;
    private final List<String> recommendedActionTypes;
    private final Criteria criteria;
    private final Schedule schedule;
    private final String status;
    private final List<Tag> tags;
    private final String clientToken;

    private CreateAutomationRuleRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.ruleType = builder.ruleType;
        this.organizationConfiguration = builder.organizationConfiguration;
        this.priority = builder.priority;
        this.recommendedActionTypes = builder.recommendedActionTypes;
        this.criteria = builder.criteria;
        this.schedule = builder.schedule;
        this.status = builder.status;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final RuleType ruleType() {
        return RuleType.fromValue(this.ruleType);
    }

    public final String ruleTypeAsString() {
        return this.ruleType;
    }

    public final OrganizationConfiguration organizationConfiguration() {
        return this.organizationConfiguration;
    }

    public final String priority() {
        return this.priority;
    }

    public final List<RecommendedActionType> recommendedActionTypes() {
        return RecommendedActionTypeListCopier.copyStringToEnum(this.recommendedActionTypes);
    }

    public final boolean hasRecommendedActionTypes() {
        return this.recommendedActionTypes != null && !(this.recommendedActionTypes instanceof SdkAutoConstructList);
    }

    public final List<String> recommendedActionTypesAsStrings() {
        return this.recommendedActionTypes;
    }

    public final Criteria criteria() {
        return this.criteria;
    }

    public final Schedule schedule() {
        return this.schedule;
    }

    public final RuleStatus status() {
        return RuleStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecommendedActionTypes() ? this.recommendedActionTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.criteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAutomationRuleRequest)) {
            return false;
        }
        CreateAutomationRuleRequest other = (CreateAutomationRuleRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.ruleTypeAsString(), other.ruleTypeAsString()) && Objects.equals(this.organizationConfiguration(), other.organizationConfiguration()) && Objects.equals(this.priority(), other.priority()) && this.hasRecommendedActionTypes() == other.hasRecommendedActionTypes() && Objects.equals(this.recommendedActionTypesAsStrings(), other.recommendedActionTypesAsStrings()) && Objects.equals(this.criteria(), other.criteria()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAutomationRuleRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("RuleType", (Object)this.ruleTypeAsString()).add("OrganizationConfiguration", (Object)this.organizationConfiguration()).add("Priority", (Object)this.priority()).add("RecommendedActionTypes", this.hasRecommendedActionTypes() ? this.recommendedActionTypesAsStrings() : null).add("Criteria", (Object)this.criteria()).add("Schedule", (Object)this.schedule()).add("Status", (Object)this.statusAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ruleType": {
                return Optional.ofNullable(clazz.cast(this.ruleTypeAsString()));
            }
            case "organizationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.organizationConfiguration()));
            }
            case "priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "recommendedActionTypes": {
                return Optional.ofNullable(clazz.cast(this.recommendedActionTypesAsStrings()));
            }
            case "criteria": {
                return Optional.ofNullable(clazz.cast(this.criteria()));
            }
            case "schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("ruleType", RULE_TYPE_FIELD);
        map.put("organizationConfiguration", ORGANIZATION_CONFIGURATION_FIELD);
        map.put("priority", PRIORITY_FIELD);
        map.put("recommendedActionTypes", RECOMMENDED_ACTION_TYPES_FIELD);
        map.put("criteria", CRITERIA_FIELD);
        map.put("schedule", SCHEDULE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAutomationRuleRequest, T> g) {
        return obj -> g.apply((CreateAutomationRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComputeOptimizerAutomationRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String ruleType;
        private OrganizationConfiguration organizationConfiguration;
        private String priority;
        private List<String> recommendedActionTypes = DefaultSdkAutoConstructList.getInstance();
        private Criteria criteria;
        private Schedule schedule;
        private String status;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAutomationRuleRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.ruleType(model.ruleType);
            this.organizationConfiguration(model.organizationConfiguration);
            this.priority(model.priority);
            this.recommendedActionTypesWithStrings(model.recommendedActionTypes);
            this.criteria(model.criteria);
            this.schedule(model.schedule);
            this.status(model.status);
            this.tags(model.tags);
            this.clientToken(model.clientToken);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRuleType() {
            return this.ruleType;
        }

        public final void setRuleType(String ruleType) {
            this.ruleType = ruleType;
        }

        @Override
        public final Builder ruleType(String ruleType) {
            this.ruleType = ruleType;
            return this;
        }

        @Override
        public final Builder ruleType(RuleType ruleType) {
            this.ruleType(ruleType == null ? null : ruleType.toString());
            return this;
        }

        public final OrganizationConfiguration.Builder getOrganizationConfiguration() {
            return this.organizationConfiguration != null ? this.organizationConfiguration.toBuilder() : null;
        }

        public final void setOrganizationConfiguration(OrganizationConfiguration.BuilderImpl organizationConfiguration) {
            this.organizationConfiguration = organizationConfiguration != null ? organizationConfiguration.build() : null;
        }

        @Override
        public final Builder organizationConfiguration(OrganizationConfiguration organizationConfiguration) {
            this.organizationConfiguration = organizationConfiguration;
            return this;
        }

        public final String getPriority() {
            return this.priority;
        }

        public final void setPriority(String priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(String priority) {
            this.priority = priority;
            return this;
        }

        public final Collection<String> getRecommendedActionTypes() {
            if (this.recommendedActionTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.recommendedActionTypes;
        }

        public final void setRecommendedActionTypes(Collection<String> recommendedActionTypes) {
            this.recommendedActionTypes = RecommendedActionTypeListCopier.copy(recommendedActionTypes);
        }

        @Override
        public final Builder recommendedActionTypesWithStrings(Collection<String> recommendedActionTypes) {
            this.recommendedActionTypes = RecommendedActionTypeListCopier.copy(recommendedActionTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendedActionTypesWithStrings(String ... recommendedActionTypes) {
            this.recommendedActionTypesWithStrings(Arrays.asList(recommendedActionTypes));
            return this;
        }

        @Override
        public final Builder recommendedActionTypes(Collection<RecommendedActionType> recommendedActionTypes) {
            this.recommendedActionTypes = RecommendedActionTypeListCopier.copyEnumToString(recommendedActionTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendedActionTypes(RecommendedActionType ... recommendedActionTypes) {
            this.recommendedActionTypes(Arrays.asList(recommendedActionTypes));
            return this;
        }

        public final Criteria.Builder getCriteria() {
            return this.criteria != null ? this.criteria.toBuilder() : null;
        }

        public final void setCriteria(Criteria.BuilderImpl criteria) {
            this.criteria = criteria != null ? criteria.build() : null;
        }

        @Override
        public final Builder criteria(Criteria criteria) {
            this.criteria = criteria;
            return this;
        }

        public final Schedule.Builder getSchedule() {
            return this.schedule != null ? this.schedule.toBuilder() : null;
        }

        public final void setSchedule(Schedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RuleStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAutomationRuleRequest build() {
            return new CreateAutomationRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ComputeOptimizerAutomationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAutomationRuleRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder ruleType(String var1);

        public Builder ruleType(RuleType var1);

        public Builder organizationConfiguration(OrganizationConfiguration var1);

        default public Builder organizationConfiguration(Consumer<OrganizationConfiguration.Builder> organizationConfiguration) {
            return this.organizationConfiguration((OrganizationConfiguration)((OrganizationConfiguration.Builder)OrganizationConfiguration.builder().applyMutation(organizationConfiguration)).build());
        }

        public Builder priority(String var1);

        public Builder recommendedActionTypesWithStrings(Collection<String> var1);

        public Builder recommendedActionTypesWithStrings(String ... var1);

        public Builder recommendedActionTypes(Collection<RecommendedActionType> var1);

        public Builder recommendedActionTypes(RecommendedActionType ... var1);

        public Builder criteria(Criteria var1);

        default public Builder criteria(Consumer<Criteria.Builder> criteria) {
            return this.criteria((Criteria)((Criteria.Builder)Criteria.builder().applyMutation(criteria)).build());
        }

        public Builder schedule(Schedule var1);

        default public Builder schedule(Consumer<Schedule.Builder> schedule) {
            return this.schedule((Schedule)((Schedule.Builder)Schedule.builder().applyMutation(schedule)).build());
        }

        public Builder status(String var1);

        public Builder status(RuleStatus var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

