/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizerautomation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.computeoptimizerautomation.ComputeOptimizerAutomationClient;
import software.amazon.awssdk.services.computeoptimizerautomation.internal.UserAgentUtils;
import software.amazon.awssdk.services.computeoptimizerautomation.model.AutomationRule;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ListAutomationRulesRequest;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ListAutomationRulesResponse;

public class ListAutomationRulesIterable
implements SdkIterable<ListAutomationRulesResponse> {
    private final ComputeOptimizerAutomationClient client;
    private final ListAutomationRulesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAutomationRulesIterable(ComputeOptimizerAutomationClient client, ListAutomationRulesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAutomationRulesResponseFetcher();
    }

    public Iterator<ListAutomationRulesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AutomationRule> automationRules() {
        Function<ListAutomationRulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.automationRules() != null) {
                return response.automationRules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAutomationRulesResponseFetcher
    implements SyncPageFetcher<ListAutomationRulesResponse> {
        private ListAutomationRulesResponseFetcher() {
        }

        public boolean hasNextPage(ListAutomationRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAutomationRulesResponse nextPage(ListAutomationRulesResponse previousPage) {
            if (previousPage == null) {
                return ListAutomationRulesIterable.this.client.listAutomationRules(ListAutomationRulesIterable.this.firstRequest);
            }
            return ListAutomationRulesIterable.this.client.listAutomationRules((ListAutomationRulesRequest)((Object)ListAutomationRulesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

