/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizerautomation.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizerautomation.model.AutomationEventFilter;
import software.amazon.awssdk.services.computeoptimizerautomation.model.AutomationEventFilterListCopier;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ComputeOptimizerAutomationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAutomationEventsRequest
extends ComputeOptimizerAutomationRequest
implements ToCopyableBuilder<Builder, ListAutomationEventsRequest> {
    private static final SdkField<List<AutomationEventFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("filters").getter(ListAutomationEventsRequest.getter(ListAutomationEventsRequest::filters)).setter(ListAutomationEventsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutomationEventFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> START_TIME_INCLUSIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTimeInclusive").getter(ListAutomationEventsRequest.getter(ListAutomationEventsRequest::startTimeInclusive)).setter(ListAutomationEventsRequest.setter(Builder::startTimeInclusive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimeInclusive").build()}).build();
    private static final SdkField<Instant> END_TIME_EXCLUSIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTimeExclusive").getter(ListAutomationEventsRequest.getter(ListAutomationEventsRequest::endTimeExclusive)).setter(ListAutomationEventsRequest.setter(Builder::endTimeExclusive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTimeExclusive").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListAutomationEventsRequest.getter(ListAutomationEventsRequest::maxResults)).setter(ListAutomationEventsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAutomationEventsRequest.getter(ListAutomationEventsRequest::nextToken)).setter(ListAutomationEventsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD, START_TIME_INCLUSIVE_FIELD, END_TIME_EXCLUSIVE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAutomationEventsRequest.memberNameToFieldInitializer();
    private final List<AutomationEventFilter> filters;
    private final Instant startTimeInclusive;
    private final Instant endTimeExclusive;
    private final Integer maxResults;
    private final String nextToken;

    private ListAutomationEventsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.startTimeInclusive = builder.startTimeInclusive;
        this.endTimeExclusive = builder.endTimeExclusive;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<AutomationEventFilter> filters() {
        return this.filters;
    }

    public final Instant startTimeInclusive() {
        return this.startTimeInclusive;
    }

    public final Instant endTimeExclusive() {
        return this.endTimeExclusive;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimeInclusive());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTimeExclusive());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAutomationEventsRequest)) {
            return false;
        }
        ListAutomationEventsRequest other = (ListAutomationEventsRequest)((Object)obj);
        return this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.startTimeInclusive(), other.startTimeInclusive()) && Objects.equals(this.endTimeExclusive(), other.endTimeExclusive()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAutomationEventsRequest").add("Filters", this.hasFilters() ? this.filters() : null).add("StartTimeInclusive", (Object)this.startTimeInclusive()).add("EndTimeExclusive", (Object)this.endTimeExclusive()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "startTimeInclusive": {
                return Optional.ofNullable(clazz.cast(this.startTimeInclusive()));
            }
            case "endTimeExclusive": {
                return Optional.ofNullable(clazz.cast(this.endTimeExclusive()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("filters", FILTERS_FIELD);
        map.put("startTimeInclusive", START_TIME_INCLUSIVE_FIELD);
        map.put("endTimeExclusive", END_TIME_EXCLUSIVE_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAutomationEventsRequest, T> g) {
        return obj -> g.apply((ListAutomationEventsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComputeOptimizerAutomationRequest.BuilderImpl
    implements Builder {
        private List<AutomationEventFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private Instant startTimeInclusive;
        private Instant endTimeExclusive;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAutomationEventsRequest model) {
            super(model);
            this.filters(model.filters);
            this.startTimeInclusive(model.startTimeInclusive);
            this.endTimeExclusive(model.endTimeExclusive);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final List<AutomationEventFilter.Builder> getFilters() {
            List<AutomationEventFilter.Builder> result = AutomationEventFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<AutomationEventFilter.BuilderImpl> filters) {
            this.filters = AutomationEventFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<AutomationEventFilter> filters) {
            this.filters = AutomationEventFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(AutomationEventFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<AutomationEventFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (AutomationEventFilter)((AutomationEventFilter.Builder)AutomationEventFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getStartTimeInclusive() {
            return this.startTimeInclusive;
        }

        public final void setStartTimeInclusive(Instant startTimeInclusive) {
            this.startTimeInclusive = startTimeInclusive;
        }

        @Override
        public final Builder startTimeInclusive(Instant startTimeInclusive) {
            this.startTimeInclusive = startTimeInclusive;
            return this;
        }

        public final Instant getEndTimeExclusive() {
            return this.endTimeExclusive;
        }

        public final void setEndTimeExclusive(Instant endTimeExclusive) {
            this.endTimeExclusive = endTimeExclusive;
        }

        @Override
        public final Builder endTimeExclusive(Instant endTimeExclusive) {
            this.endTimeExclusive = endTimeExclusive;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAutomationEventsRequest build() {
            return new ListAutomationEventsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ComputeOptimizerAutomationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAutomationEventsRequest> {
        public Builder filters(Collection<AutomationEventFilter> var1);

        public Builder filters(AutomationEventFilter ... var1);

        public Builder filters(Consumer<AutomationEventFilter.Builder> ... var1);

        public Builder startTimeInclusive(Instant var1);

        public Builder endTimeExclusive(Instant var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

