/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizerautomation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizerautomation.model.AutomationEventFilter;
import software.amazon.awssdk.services.computeoptimizerautomation.model.AutomationEventFilterListCopier;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ComputeOptimizerAutomationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAutomationEventSummariesRequest
extends ComputeOptimizerAutomationRequest
implements ToCopyableBuilder<Builder, ListAutomationEventSummariesRequest> {
    private static final SdkField<List<AutomationEventFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("filters").getter(ListAutomationEventSummariesRequest.getter(ListAutomationEventSummariesRequest::filters)).setter(ListAutomationEventSummariesRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutomationEventFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> START_DATE_INCLUSIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("startDateInclusive").getter(ListAutomationEventSummariesRequest.getter(ListAutomationEventSummariesRequest::startDateInclusive)).setter(ListAutomationEventSummariesRequest.setter(Builder::startDateInclusive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startDateInclusive").build()}).build();
    private static final SdkField<String> END_DATE_EXCLUSIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endDateExclusive").getter(ListAutomationEventSummariesRequest.getter(ListAutomationEventSummariesRequest::endDateExclusive)).setter(ListAutomationEventSummariesRequest.setter(Builder::endDateExclusive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endDateExclusive").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListAutomationEventSummariesRequest.getter(ListAutomationEventSummariesRequest::maxResults)).setter(ListAutomationEventSummariesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAutomationEventSummariesRequest.getter(ListAutomationEventSummariesRequest::nextToken)).setter(ListAutomationEventSummariesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD, START_DATE_INCLUSIVE_FIELD, END_DATE_EXCLUSIVE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAutomationEventSummariesRequest.memberNameToFieldInitializer();
    private final List<AutomationEventFilter> filters;
    private final String startDateInclusive;
    private final String endDateExclusive;
    private final Integer maxResults;
    private final String nextToken;

    private ListAutomationEventSummariesRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.startDateInclusive = builder.startDateInclusive;
        this.endDateExclusive = builder.endDateExclusive;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<AutomationEventFilter> filters() {
        return this.filters;
    }

    public final String startDateInclusive() {
        return this.startDateInclusive;
    }

    public final String endDateExclusive() {
        return this.endDateExclusive;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startDateInclusive());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDateExclusive());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAutomationEventSummariesRequest)) {
            return false;
        }
        ListAutomationEventSummariesRequest other = (ListAutomationEventSummariesRequest)((Object)obj);
        return this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.startDateInclusive(), other.startDateInclusive()) && Objects.equals(this.endDateExclusive(), other.endDateExclusive()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAutomationEventSummariesRequest").add("Filters", this.hasFilters() ? this.filters() : null).add("StartDateInclusive", (Object)this.startDateInclusive()).add("EndDateExclusive", (Object)this.endDateExclusive()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "startDateInclusive": {
                return Optional.ofNullable(clazz.cast(this.startDateInclusive()));
            }
            case "endDateExclusive": {
                return Optional.ofNullable(clazz.cast(this.endDateExclusive()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("filters", FILTERS_FIELD);
        map.put("startDateInclusive", START_DATE_INCLUSIVE_FIELD);
        map.put("endDateExclusive", END_DATE_EXCLUSIVE_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAutomationEventSummariesRequest, T> g) {
        return obj -> g.apply((ListAutomationEventSummariesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComputeOptimizerAutomationRequest.BuilderImpl
    implements Builder {
        private List<AutomationEventFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private String startDateInclusive;
        private String endDateExclusive;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAutomationEventSummariesRequest model) {
            super(model);
            this.filters(model.filters);
            this.startDateInclusive(model.startDateInclusive);
            this.endDateExclusive(model.endDateExclusive);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final List<AutomationEventFilter.Builder> getFilters() {
            List<AutomationEventFilter.Builder> result = AutomationEventFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<AutomationEventFilter.BuilderImpl> filters) {
            this.filters = AutomationEventFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<AutomationEventFilter> filters) {
            this.filters = AutomationEventFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(AutomationEventFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<AutomationEventFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (AutomationEventFilter)((AutomationEventFilter.Builder)AutomationEventFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStartDateInclusive() {
            return this.startDateInclusive;
        }

        public final void setStartDateInclusive(String startDateInclusive) {
            this.startDateInclusive = startDateInclusive;
        }

        @Override
        public final Builder startDateInclusive(String startDateInclusive) {
            this.startDateInclusive = startDateInclusive;
            return this;
        }

        public final String getEndDateExclusive() {
            return this.endDateExclusive;
        }

        public final void setEndDateExclusive(String endDateExclusive) {
            this.endDateExclusive = endDateExclusive;
        }

        @Override
        public final Builder endDateExclusive(String endDateExclusive) {
            this.endDateExclusive = endDateExclusive;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAutomationEventSummariesRequest build() {
            return new ListAutomationEventSummariesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ComputeOptimizerAutomationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAutomationEventSummariesRequest> {
        public Builder filters(Collection<AutomationEventFilter> var1);

        public Builder filters(AutomationEventFilter ... var1);

        public Builder filters(Consumer<AutomationEventFilter.Builder> ... var1);

        public Builder startDateInclusive(String var1);

        public Builder endDateExclusive(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

