/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizerautomation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.computeoptimizerautomation.model.SavingsEstimationMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EstimatedMonthlySavings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EstimatedMonthlySavings> {
    private static final SdkField<String> CURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currency").getter(EstimatedMonthlySavings.getter(EstimatedMonthlySavings::currency)).setter(EstimatedMonthlySavings.setter(Builder::currency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currency").build()}).build();
    private static final SdkField<Double> BEFORE_DISCOUNT_SAVINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("beforeDiscountSavings").getter(EstimatedMonthlySavings.getter(EstimatedMonthlySavings::beforeDiscountSavings)).setter(EstimatedMonthlySavings.setter(Builder::beforeDiscountSavings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("beforeDiscountSavings").build()}).build();
    private static final SdkField<Double> AFTER_DISCOUNT_SAVINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("afterDiscountSavings").getter(EstimatedMonthlySavings.getter(EstimatedMonthlySavings::afterDiscountSavings)).setter(EstimatedMonthlySavings.setter(Builder::afterDiscountSavings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterDiscountSavings").build()}).build();
    private static final SdkField<String> SAVINGS_ESTIMATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("savingsEstimationMode").getter(EstimatedMonthlySavings.getter(EstimatedMonthlySavings::savingsEstimationModeAsString)).setter(EstimatedMonthlySavings.setter(Builder::savingsEstimationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsEstimationMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENCY_FIELD, BEFORE_DISCOUNT_SAVINGS_FIELD, AFTER_DISCOUNT_SAVINGS_FIELD, SAVINGS_ESTIMATION_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EstimatedMonthlySavings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String currency;
    private final Double beforeDiscountSavings;
    private final Double afterDiscountSavings;
    private final String savingsEstimationMode;

    private EstimatedMonthlySavings(BuilderImpl builder) {
        this.currency = builder.currency;
        this.beforeDiscountSavings = builder.beforeDiscountSavings;
        this.afterDiscountSavings = builder.afterDiscountSavings;
        this.savingsEstimationMode = builder.savingsEstimationMode;
    }

    public final String currency() {
        return this.currency;
    }

    public final Double beforeDiscountSavings() {
        return this.beforeDiscountSavings;
    }

    public final Double afterDiscountSavings() {
        return this.afterDiscountSavings;
    }

    public final SavingsEstimationMode savingsEstimationMode() {
        return SavingsEstimationMode.fromValue(this.savingsEstimationMode);
    }

    public final String savingsEstimationModeAsString() {
        return this.savingsEstimationMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.currency());
        hashCode = 31 * hashCode + Objects.hashCode(this.beforeDiscountSavings());
        hashCode = 31 * hashCode + Objects.hashCode(this.afterDiscountSavings());
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsEstimationModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EstimatedMonthlySavings)) {
            return false;
        }
        EstimatedMonthlySavings other = (EstimatedMonthlySavings)obj;
        return Objects.equals(this.currency(), other.currency()) && Objects.equals(this.beforeDiscountSavings(), other.beforeDiscountSavings()) && Objects.equals(this.afterDiscountSavings(), other.afterDiscountSavings()) && Objects.equals(this.savingsEstimationModeAsString(), other.savingsEstimationModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"EstimatedMonthlySavings").add("Currency", (Object)this.currency()).add("BeforeDiscountSavings", (Object)this.beforeDiscountSavings()).add("AfterDiscountSavings", (Object)this.afterDiscountSavings()).add("SavingsEstimationMode", (Object)this.savingsEstimationModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "currency": {
                return Optional.ofNullable(clazz.cast(this.currency()));
            }
            case "beforeDiscountSavings": {
                return Optional.ofNullable(clazz.cast(this.beforeDiscountSavings()));
            }
            case "afterDiscountSavings": {
                return Optional.ofNullable(clazz.cast(this.afterDiscountSavings()));
            }
            case "savingsEstimationMode": {
                return Optional.ofNullable(clazz.cast(this.savingsEstimationModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("currency", CURRENCY_FIELD);
        map.put("beforeDiscountSavings", BEFORE_DISCOUNT_SAVINGS_FIELD);
        map.put("afterDiscountSavings", AFTER_DISCOUNT_SAVINGS_FIELD);
        map.put("savingsEstimationMode", SAVINGS_ESTIMATION_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EstimatedMonthlySavings, T> g) {
        return obj -> g.apply((EstimatedMonthlySavings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String currency;
        private Double beforeDiscountSavings;
        private Double afterDiscountSavings;
        private String savingsEstimationMode;

        private BuilderImpl() {
        }

        private BuilderImpl(EstimatedMonthlySavings model) {
            this.currency(model.currency);
            this.beforeDiscountSavings(model.beforeDiscountSavings);
            this.afterDiscountSavings(model.afterDiscountSavings);
            this.savingsEstimationMode(model.savingsEstimationMode);
        }

        public final String getCurrency() {
            return this.currency;
        }

        public final void setCurrency(String currency) {
            this.currency = currency;
        }

        @Override
        public final Builder currency(String currency) {
            this.currency = currency;
            return this;
        }

        public final Double getBeforeDiscountSavings() {
            return this.beforeDiscountSavings;
        }

        public final void setBeforeDiscountSavings(Double beforeDiscountSavings) {
            this.beforeDiscountSavings = beforeDiscountSavings;
        }

        @Override
        public final Builder beforeDiscountSavings(Double beforeDiscountSavings) {
            this.beforeDiscountSavings = beforeDiscountSavings;
            return this;
        }

        public final Double getAfterDiscountSavings() {
            return this.afterDiscountSavings;
        }

        public final void setAfterDiscountSavings(Double afterDiscountSavings) {
            this.afterDiscountSavings = afterDiscountSavings;
        }

        @Override
        public final Builder afterDiscountSavings(Double afterDiscountSavings) {
            this.afterDiscountSavings = afterDiscountSavings;
            return this;
        }

        public final String getSavingsEstimationMode() {
            return this.savingsEstimationMode;
        }

        public final void setSavingsEstimationMode(String savingsEstimationMode) {
            this.savingsEstimationMode = savingsEstimationMode;
        }

        @Override
        public final Builder savingsEstimationMode(String savingsEstimationMode) {
            this.savingsEstimationMode = savingsEstimationMode;
            return this;
        }

        @Override
        public final Builder savingsEstimationMode(SavingsEstimationMode savingsEstimationMode) {
            this.savingsEstimationMode(savingsEstimationMode == null ? null : savingsEstimationMode.toString());
            return this;
        }

        public EstimatedMonthlySavings build() {
            return new EstimatedMonthlySavings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EstimatedMonthlySavings> {
        public Builder currency(String var1);

        public Builder beforeDiscountSavings(Double var1);

        public Builder afterDiscountSavings(Double var1);

        public Builder savingsEstimationMode(String var1);

        public Builder savingsEstimationMode(SavingsEstimationMode var1);
    }
}

