/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class LambdaFunctionRecommendationsCopier {
    static List<LambdaFunctionRecommendation> copy(
            Collection<? extends LambdaFunctionRecommendation> lambdaFunctionRecommendationsParam) {
        List<LambdaFunctionRecommendation> list;
        if (lambdaFunctionRecommendationsParam == null || lambdaFunctionRecommendationsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<LambdaFunctionRecommendation> modifiableList = new ArrayList<>(lambdaFunctionRecommendationsParam.size());
            lambdaFunctionRecommendationsParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<LambdaFunctionRecommendation> copyFromBuilder(
            Collection<? extends LambdaFunctionRecommendation.Builder> lambdaFunctionRecommendationsParam) {
        List<LambdaFunctionRecommendation> list;
        if (lambdaFunctionRecommendationsParam == null || lambdaFunctionRecommendationsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<LambdaFunctionRecommendation> modifiableList = new ArrayList<>(lambdaFunctionRecommendationsParam.size());
            lambdaFunctionRecommendationsParam.forEach(entry -> {
                LambdaFunctionRecommendation member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<LambdaFunctionRecommendation.Builder> copyToBuilder(
            Collection<? extends LambdaFunctionRecommendation> lambdaFunctionRecommendationsParam) {
        List<LambdaFunctionRecommendation.Builder> list;
        if (lambdaFunctionRecommendationsParam == null || lambdaFunctionRecommendationsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<LambdaFunctionRecommendation.Builder> modifiableList = new ArrayList<>(lambdaFunctionRecommendationsParam.size());
            lambdaFunctionRecommendationsParam.forEach(entry -> {
                LambdaFunctionRecommendation.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
