/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEffectiveRecommendationPreferencesResponse extends ComputeOptimizerResponse implements
        ToCopyableBuilder<GetEffectiveRecommendationPreferencesResponse.Builder, GetEffectiveRecommendationPreferencesResponse> {
    private static final SdkField<String> ENHANCED_INFRASTRUCTURE_METRICS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("enhancedInfrastructureMetrics")
            .getter(getter(GetEffectiveRecommendationPreferencesResponse::enhancedInfrastructureMetricsAsString))
            .setter(setter(Builder::enhancedInfrastructureMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enhancedInfrastructureMetrics")
                    .build()).build();

    private static final SdkField<ExternalMetricsPreference> EXTERNAL_METRICS_PREFERENCE_FIELD = SdkField
            .<ExternalMetricsPreference> builder(MarshallingType.SDK_POJO).memberName("externalMetricsPreference")
            .getter(getter(GetEffectiveRecommendationPreferencesResponse::externalMetricsPreference))
            .setter(setter(Builder::externalMetricsPreference)).constructor(ExternalMetricsPreference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalMetricsPreference").build())
            .build();

    private static final SdkField<String> LOOK_BACK_PERIOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lookBackPeriod").getter(getter(GetEffectiveRecommendationPreferencesResponse::lookBackPeriodAsString))
            .setter(setter(Builder::lookBackPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lookBackPeriod").build()).build();

    private static final SdkField<List<UtilizationPreference>> UTILIZATION_PREFERENCES_FIELD = SdkField
            .<List<UtilizationPreference>> builder(MarshallingType.LIST)
            .memberName("utilizationPreferences")
            .getter(getter(GetEffectiveRecommendationPreferencesResponse::utilizationPreferences))
            .setter(setter(Builder::utilizationPreferences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("utilizationPreferences").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UtilizationPreference> builder(MarshallingType.SDK_POJO)
                                            .constructor(UtilizationPreference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<EffectivePreferredResource>> PREFERRED_RESOURCES_FIELD = SdkField
            .<List<EffectivePreferredResource>> builder(MarshallingType.LIST)
            .memberName("preferredResources")
            .getter(getter(GetEffectiveRecommendationPreferencesResponse::preferredResources))
            .setter(setter(Builder::preferredResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preferredResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EffectivePreferredResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(EffectivePreferredResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ENHANCED_INFRASTRUCTURE_METRICS_FIELD, EXTERNAL_METRICS_PREFERENCE_FIELD, LOOK_BACK_PERIOD_FIELD,
            UTILIZATION_PREFERENCES_FIELD, PREFERRED_RESOURCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String enhancedInfrastructureMetrics;

    private final ExternalMetricsPreference externalMetricsPreference;

    private final String lookBackPeriod;

    private final List<UtilizationPreference> utilizationPreferences;

    private final List<EffectivePreferredResource> preferredResources;

    private GetEffectiveRecommendationPreferencesResponse(BuilderImpl builder) {
        super(builder);
        this.enhancedInfrastructureMetrics = builder.enhancedInfrastructureMetrics;
        this.externalMetricsPreference = builder.externalMetricsPreference;
        this.lookBackPeriod = builder.lookBackPeriod;
        this.utilizationPreferences = builder.utilizationPreferences;
        this.preferredResources = builder.preferredResources;
    }

    /**
     * <p>
     * The status of the enhanced infrastructure metrics recommendation preference. Considers all applicable preferences
     * that you might have set at the resource, account, and organization level.
     * </p>
     * <p>
     * A status of <code>Active</code> confirms that the preference is applied in the latest recommendation refresh, and
     * a status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
     * </p>
     * <p>
     * To validate whether the preference is applied to your last generated set of recommendations, review the
     * <code>effectiveRecommendationPreferences</code> value in the response of the
     * <a>GetAutoScalingGroupRecommendations</a> and <a>GetEC2InstanceRecommendations</a> actions.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Enhanced
     * infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #enhancedInfrastructureMetrics} will return {@link EnhancedInfrastructureMetrics#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #enhancedInfrastructureMetricsAsString}.
     * </p>
     * 
     * @return The status of the enhanced infrastructure metrics recommendation preference. Considers all applicable
     *         preferences that you might have set at the resource, account, and organization level.</p>
     *         <p>
     *         A status of <code>Active</code> confirms that the preference is applied in the latest recommendation
     *         refresh, and a status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
     *         </p>
     *         <p>
     *         To validate whether the preference is applied to your last generated set of recommendations, review the
     *         <code>effectiveRecommendationPreferences</code> value in the response of the
     *         <a>GetAutoScalingGroupRecommendations</a> and <a>GetEC2InstanceRecommendations</a> actions.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html"
     *         >Enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
     * @see EnhancedInfrastructureMetrics
     */
    public final EnhancedInfrastructureMetrics enhancedInfrastructureMetrics() {
        return EnhancedInfrastructureMetrics.fromValue(enhancedInfrastructureMetrics);
    }

    /**
     * <p>
     * The status of the enhanced infrastructure metrics recommendation preference. Considers all applicable preferences
     * that you might have set at the resource, account, and organization level.
     * </p>
     * <p>
     * A status of <code>Active</code> confirms that the preference is applied in the latest recommendation refresh, and
     * a status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
     * </p>
     * <p>
     * To validate whether the preference is applied to your last generated set of recommendations, review the
     * <code>effectiveRecommendationPreferences</code> value in the response of the
     * <a>GetAutoScalingGroupRecommendations</a> and <a>GetEC2InstanceRecommendations</a> actions.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Enhanced
     * infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #enhancedInfrastructureMetrics} will return {@link EnhancedInfrastructureMetrics#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #enhancedInfrastructureMetricsAsString}.
     * </p>
     * 
     * @return The status of the enhanced infrastructure metrics recommendation preference. Considers all applicable
     *         preferences that you might have set at the resource, account, and organization level.</p>
     *         <p>
     *         A status of <code>Active</code> confirms that the preference is applied in the latest recommendation
     *         refresh, and a status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
     *         </p>
     *         <p>
     *         To validate whether the preference is applied to your last generated set of recommendations, review the
     *         <code>effectiveRecommendationPreferences</code> value in the response of the
     *         <a>GetAutoScalingGroupRecommendations</a> and <a>GetEC2InstanceRecommendations</a> actions.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html"
     *         >Enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
     * @see EnhancedInfrastructureMetrics
     */
    public final String enhancedInfrastructureMetricsAsString() {
        return enhancedInfrastructureMetrics;
    }

    /**
     * <p>
     * The provider of the external metrics recommendation preference. Considers all applicable preferences that you
     * might have set at the account and organization level.
     * </p>
     * <p>
     * If the preference is applied in the latest recommendation refresh, an object with a valid <code>source</code>
     * value appears in the response. If the preference isn't applied to the recommendations already, then this object
     * doesn't appear in the response.
     * </p>
     * <p>
     * To validate whether the preference is applied to your last generated set of recommendations, review the
     * <code>effectiveRecommendationPreferences</code> value in the response of the <a>GetEC2InstanceRecommendations</a>
     * actions.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/external-metrics-ingestion.html">Enhanced
     * infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * 
     * @return The provider of the external metrics recommendation preference. Considers all applicable preferences that
     *         you might have set at the account and organization level.</p>
     *         <p>
     *         If the preference is applied in the latest recommendation refresh, an object with a valid
     *         <code>source</code> value appears in the response. If the preference isn't applied to the recommendations
     *         already, then this object doesn't appear in the response.
     *         </p>
     *         <p>
     *         To validate whether the preference is applied to your last generated set of recommendations, review the
     *         <code>effectiveRecommendationPreferences</code> value in the response of the
     *         <a>GetEC2InstanceRecommendations</a> actions.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/external-metrics-ingestion.html">Enhanced
     *         infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
     */
    public final ExternalMetricsPreference externalMetricsPreference() {
        return externalMetricsPreference;
    }

    /**
     * <p>
     * The number of days the utilization metrics of the Amazon Web Services resource are analyzed.
     * </p>
     * <p>
     * To validate that the preference is applied to your last generated set of recommendations, review the
     * <code>effectiveRecommendationPreferences</code> value in the response of the GetAutoScalingGroupRecommendations
     * or GetEC2InstanceRecommendations actions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lookBackPeriod}
     * will return {@link LookBackPeriodPreference#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #lookBackPeriodAsString}.
     * </p>
     * 
     * @return The number of days the utilization metrics of the Amazon Web Services resource are analyzed. </p>
     *         <p>
     *         To validate that the preference is applied to your last generated set of recommendations, review the
     *         <code>effectiveRecommendationPreferences</code> value in the response of the
     *         GetAutoScalingGroupRecommendations or GetEC2InstanceRecommendations actions.
     * @see LookBackPeriodPreference
     */
    public final LookBackPeriodPreference lookBackPeriod() {
        return LookBackPeriodPreference.fromValue(lookBackPeriod);
    }

    /**
     * <p>
     * The number of days the utilization metrics of the Amazon Web Services resource are analyzed.
     * </p>
     * <p>
     * To validate that the preference is applied to your last generated set of recommendations, review the
     * <code>effectiveRecommendationPreferences</code> value in the response of the GetAutoScalingGroupRecommendations
     * or GetEC2InstanceRecommendations actions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lookBackPeriod}
     * will return {@link LookBackPeriodPreference#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #lookBackPeriodAsString}.
     * </p>
     * 
     * @return The number of days the utilization metrics of the Amazon Web Services resource are analyzed. </p>
     *         <p>
     *         To validate that the preference is applied to your last generated set of recommendations, review the
     *         <code>effectiveRecommendationPreferences</code> value in the response of the
     *         GetAutoScalingGroupRecommendations or GetEC2InstanceRecommendations actions.
     * @see LookBackPeriodPreference
     */
    public final String lookBackPeriodAsString() {
        return lookBackPeriod;
    }

    /**
     * For responses, this returns true if the service returned a value for the UtilizationPreferences property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasUtilizationPreferences() {
        return utilizationPreferences != null && !(utilizationPreferences instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The resource’s CPU and memory utilization preferences, such as threshold and headroom, that were used to generate
     * rightsizing recommendations. It considers all applicable preferences that you set at the resource, account, and
     * organization level.
     * </p>
     * <p>
     * To validate that the preference is applied to your last generated set of recommendations, review the
     * <code>effectiveRecommendationPreferences</code> value in the response of the GetAutoScalingGroupRecommendations
     * or GetEC2InstanceRecommendations actions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUtilizationPreferences} method.
     * </p>
     * 
     * @return The resource’s CPU and memory utilization preferences, such as threshold and headroom, that were used to
     *         generate rightsizing recommendations. It considers all applicable preferences that you set at the
     *         resource, account, and organization level. </p>
     *         <p>
     *         To validate that the preference is applied to your last generated set of recommendations, review the
     *         <code>effectiveRecommendationPreferences</code> value in the response of the
     *         GetAutoScalingGroupRecommendations or GetEC2InstanceRecommendations actions.
     */
    public final List<UtilizationPreference> utilizationPreferences() {
        return utilizationPreferences;
    }

    /**
     * For responses, this returns true if the service returned a value for the PreferredResources property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPreferredResources() {
        return preferredResources != null && !(preferredResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The resource type values that are considered as candidates when generating rightsizing recommendations. This
     * object resolves any wildcard expressions and returns the effective list of candidate resource type values. It
     * also considers all applicable preferences that you set at the resource, account, and organization level.
     * </p>
     * <p>
     * To validate that the preference is applied to your last generated set of recommendations, review the
     * <code>effectiveRecommendationPreferences</code> value in the response of the GetAutoScalingGroupRecommendations
     * or GetEC2InstanceRecommendations actions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPreferredResources} method.
     * </p>
     * 
     * @return The resource type values that are considered as candidates when generating rightsizing recommendations.
     *         This object resolves any wildcard expressions and returns the effective list of candidate resource type
     *         values. It also considers all applicable preferences that you set at the resource, account, and
     *         organization level. </p>
     *         <p>
     *         To validate that the preference is applied to your last generated set of recommendations, review the
     *         <code>effectiveRecommendationPreferences</code> value in the response of the
     *         GetAutoScalingGroupRecommendations or GetEC2InstanceRecommendations actions.
     */
    public final List<EffectivePreferredResource> preferredResources() {
        return preferredResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(enhancedInfrastructureMetricsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(externalMetricsPreference());
        hashCode = 31 * hashCode + Objects.hashCode(lookBackPeriodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasUtilizationPreferences() ? utilizationPreferences() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPreferredResources() ? preferredResources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEffectiveRecommendationPreferencesResponse)) {
            return false;
        }
        GetEffectiveRecommendationPreferencesResponse other = (GetEffectiveRecommendationPreferencesResponse) obj;
        return Objects.equals(enhancedInfrastructureMetricsAsString(), other.enhancedInfrastructureMetricsAsString())
                && Objects.equals(externalMetricsPreference(), other.externalMetricsPreference())
                && Objects.equals(lookBackPeriodAsString(), other.lookBackPeriodAsString())
                && hasUtilizationPreferences() == other.hasUtilizationPreferences()
                && Objects.equals(utilizationPreferences(), other.utilizationPreferences())
                && hasPreferredResources() == other.hasPreferredResources()
                && Objects.equals(preferredResources(), other.preferredResources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEffectiveRecommendationPreferencesResponse")
                .add("EnhancedInfrastructureMetrics", enhancedInfrastructureMetricsAsString())
                .add("ExternalMetricsPreference", externalMetricsPreference()).add("LookBackPeriod", lookBackPeriodAsString())
                .add("UtilizationPreferences", hasUtilizationPreferences() ? utilizationPreferences() : null)
                .add("PreferredResources", hasPreferredResources() ? preferredResources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enhancedInfrastructureMetrics":
            return Optional.ofNullable(clazz.cast(enhancedInfrastructureMetricsAsString()));
        case "externalMetricsPreference":
            return Optional.ofNullable(clazz.cast(externalMetricsPreference()));
        case "lookBackPeriod":
            return Optional.ofNullable(clazz.cast(lookBackPeriodAsString()));
        case "utilizationPreferences":
            return Optional.ofNullable(clazz.cast(utilizationPreferences()));
        case "preferredResources":
            return Optional.ofNullable(clazz.cast(preferredResources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("enhancedInfrastructureMetrics", ENHANCED_INFRASTRUCTURE_METRICS_FIELD);
        map.put("externalMetricsPreference", EXTERNAL_METRICS_PREFERENCE_FIELD);
        map.put("lookBackPeriod", LOOK_BACK_PERIOD_FIELD);
        map.put("utilizationPreferences", UTILIZATION_PREFERENCES_FIELD);
        map.put("preferredResources", PREFERRED_RESOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetEffectiveRecommendationPreferencesResponse, T> g) {
        return obj -> g.apply((GetEffectiveRecommendationPreferencesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ComputeOptimizerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetEffectiveRecommendationPreferencesResponse> {
        /**
         * <p>
         * The status of the enhanced infrastructure metrics recommendation preference. Considers all applicable
         * preferences that you might have set at the resource, account, and organization level.
         * </p>
         * <p>
         * A status of <code>Active</code> confirms that the preference is applied in the latest recommendation refresh,
         * and a status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
         * </p>
         * <p>
         * To validate whether the preference is applied to your last generated set of recommendations, review the
         * <code>effectiveRecommendationPreferences</code> value in the response of the
         * <a>GetAutoScalingGroupRecommendations</a> and <a>GetEC2InstanceRecommendations</a> actions.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Enhanced
         * infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
         * </p>
         * 
         * @param enhancedInfrastructureMetrics
         *        The status of the enhanced infrastructure metrics recommendation preference. Considers all applicable
         *        preferences that you might have set at the resource, account, and organization level.</p>
         *        <p>
         *        A status of <code>Active</code> confirms that the preference is applied in the latest recommendation
         *        refresh, and a status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
         *        </p>
         *        <p>
         *        To validate whether the preference is applied to your last generated set of recommendations, review
         *        the <code>effectiveRecommendationPreferences</code> value in the response of the
         *        <a>GetAutoScalingGroupRecommendations</a> and <a>GetEC2InstanceRecommendations</a> actions.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html"
         *        >Enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
         * @see EnhancedInfrastructureMetrics
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnhancedInfrastructureMetrics
         */
        Builder enhancedInfrastructureMetrics(String enhancedInfrastructureMetrics);

        /**
         * <p>
         * The status of the enhanced infrastructure metrics recommendation preference. Considers all applicable
         * preferences that you might have set at the resource, account, and organization level.
         * </p>
         * <p>
         * A status of <code>Active</code> confirms that the preference is applied in the latest recommendation refresh,
         * and a status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
         * </p>
         * <p>
         * To validate whether the preference is applied to your last generated set of recommendations, review the
         * <code>effectiveRecommendationPreferences</code> value in the response of the
         * <a>GetAutoScalingGroupRecommendations</a> and <a>GetEC2InstanceRecommendations</a> actions.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Enhanced
         * infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
         * </p>
         * 
         * @param enhancedInfrastructureMetrics
         *        The status of the enhanced infrastructure metrics recommendation preference. Considers all applicable
         *        preferences that you might have set at the resource, account, and organization level.</p>
         *        <p>
         *        A status of <code>Active</code> confirms that the preference is applied in the latest recommendation
         *        refresh, and a status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
         *        </p>
         *        <p>
         *        To validate whether the preference is applied to your last generated set of recommendations, review
         *        the <code>effectiveRecommendationPreferences</code> value in the response of the
         *        <a>GetAutoScalingGroupRecommendations</a> and <a>GetEC2InstanceRecommendations</a> actions.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html"
         *        >Enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
         * @see EnhancedInfrastructureMetrics
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnhancedInfrastructureMetrics
         */
        Builder enhancedInfrastructureMetrics(EnhancedInfrastructureMetrics enhancedInfrastructureMetrics);

        /**
         * <p>
         * The provider of the external metrics recommendation preference. Considers all applicable preferences that you
         * might have set at the account and organization level.
         * </p>
         * <p>
         * If the preference is applied in the latest recommendation refresh, an object with a valid <code>source</code>
         * value appears in the response. If the preference isn't applied to the recommendations already, then this
         * object doesn't appear in the response.
         * </p>
         * <p>
         * To validate whether the preference is applied to your last generated set of recommendations, review the
         * <code>effectiveRecommendationPreferences</code> value in the response of the
         * <a>GetEC2InstanceRecommendations</a> actions.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/external-metrics-ingestion.html">Enhanced
         * infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
         * </p>
         * 
         * @param externalMetricsPreference
         *        The provider of the external metrics recommendation preference. Considers all applicable preferences
         *        that you might have set at the account and organization level.</p>
         *        <p>
         *        If the preference is applied in the latest recommendation refresh, an object with a valid
         *        <code>source</code> value appears in the response. If the preference isn't applied to the
         *        recommendations already, then this object doesn't appear in the response.
         *        </p>
         *        <p>
         *        To validate whether the preference is applied to your last generated set of recommendations, review
         *        the <code>effectiveRecommendationPreferences</code> value in the response of the
         *        <a>GetEC2InstanceRecommendations</a> actions.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/external-metrics-ingestion.html"
         *        >Enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalMetricsPreference(ExternalMetricsPreference externalMetricsPreference);

        /**
         * <p>
         * The provider of the external metrics recommendation preference. Considers all applicable preferences that you
         * might have set at the account and organization level.
         * </p>
         * <p>
         * If the preference is applied in the latest recommendation refresh, an object with a valid <code>source</code>
         * value appears in the response. If the preference isn't applied to the recommendations already, then this
         * object doesn't appear in the response.
         * </p>
         * <p>
         * To validate whether the preference is applied to your last generated set of recommendations, review the
         * <code>effectiveRecommendationPreferences</code> value in the response of the
         * <a>GetEC2InstanceRecommendations</a> actions.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/external-metrics-ingestion.html">Enhanced
         * infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExternalMetricsPreference.Builder}
         * avoiding the need to create one manually via {@link ExternalMetricsPreference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExternalMetricsPreference.Builder#build()} is called immediately
         * and its result is passed to {@link #externalMetricsPreference(ExternalMetricsPreference)}.
         * 
         * @param externalMetricsPreference
         *        a consumer that will call methods on {@link ExternalMetricsPreference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #externalMetricsPreference(ExternalMetricsPreference)
         */
        default Builder externalMetricsPreference(Consumer<ExternalMetricsPreference.Builder> externalMetricsPreference) {
            return externalMetricsPreference(ExternalMetricsPreference.builder().applyMutation(externalMetricsPreference).build());
        }

        /**
         * <p>
         * The number of days the utilization metrics of the Amazon Web Services resource are analyzed.
         * </p>
         * <p>
         * To validate that the preference is applied to your last generated set of recommendations, review the
         * <code>effectiveRecommendationPreferences</code> value in the response of the
         * GetAutoScalingGroupRecommendations or GetEC2InstanceRecommendations actions.
         * </p>
         * 
         * @param lookBackPeriod
         *        The number of days the utilization metrics of the Amazon Web Services resource are analyzed. </p>
         *        <p>
         *        To validate that the preference is applied to your last generated set of recommendations, review the
         *        <code>effectiveRecommendationPreferences</code> value in the response of the
         *        GetAutoScalingGroupRecommendations or GetEC2InstanceRecommendations actions.
         * @see LookBackPeriodPreference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LookBackPeriodPreference
         */
        Builder lookBackPeriod(String lookBackPeriod);

        /**
         * <p>
         * The number of days the utilization metrics of the Amazon Web Services resource are analyzed.
         * </p>
         * <p>
         * To validate that the preference is applied to your last generated set of recommendations, review the
         * <code>effectiveRecommendationPreferences</code> value in the response of the
         * GetAutoScalingGroupRecommendations or GetEC2InstanceRecommendations actions.
         * </p>
         * 
         * @param lookBackPeriod
         *        The number of days the utilization metrics of the Amazon Web Services resource are analyzed. </p>
         *        <p>
         *        To validate that the preference is applied to your last generated set of recommendations, review the
         *        <code>effectiveRecommendationPreferences</code> value in the response of the
         *        GetAutoScalingGroupRecommendations or GetEC2InstanceRecommendations actions.
         * @see LookBackPeriodPreference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LookBackPeriodPreference
         */
        Builder lookBackPeriod(LookBackPeriodPreference lookBackPeriod);

        /**
         * <p>
         * The resource’s CPU and memory utilization preferences, such as threshold and headroom, that were used to
         * generate rightsizing recommendations. It considers all applicable preferences that you set at the resource,
         * account, and organization level.
         * </p>
         * <p>
         * To validate that the preference is applied to your last generated set of recommendations, review the
         * <code>effectiveRecommendationPreferences</code> value in the response of the
         * GetAutoScalingGroupRecommendations or GetEC2InstanceRecommendations actions.
         * </p>
         * 
         * @param utilizationPreferences
         *        The resource’s CPU and memory utilization preferences, such as threshold and headroom, that were used
         *        to generate rightsizing recommendations. It considers all applicable preferences that you set at the
         *        resource, account, and organization level. </p>
         *        <p>
         *        To validate that the preference is applied to your last generated set of recommendations, review the
         *        <code>effectiveRecommendationPreferences</code> value in the response of the
         *        GetAutoScalingGroupRecommendations or GetEC2InstanceRecommendations actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder utilizationPreferences(Collection<UtilizationPreference> utilizationPreferences);

        /**
         * <p>
         * The resource’s CPU and memory utilization preferences, such as threshold and headroom, that were used to
         * generate rightsizing recommendations. It considers all applicable preferences that you set at the resource,
         * account, and organization level.
         * </p>
         * <p>
         * To validate that the preference is applied to your last generated set of recommendations, review the
         * <code>effectiveRecommendationPreferences</code> value in the response of the
         * GetAutoScalingGroupRecommendations or GetEC2InstanceRecommendations actions.
         * </p>
         * 
         * @param utilizationPreferences
         *        The resource’s CPU and memory utilization preferences, such as threshold and headroom, that were used
         *        to generate rightsizing recommendations. It considers all applicable preferences that you set at the
         *        resource, account, and organization level. </p>
         *        <p>
         *        To validate that the preference is applied to your last generated set of recommendations, review the
         *        <code>effectiveRecommendationPreferences</code> value in the response of the
         *        GetAutoScalingGroupRecommendations or GetEC2InstanceRecommendations actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder utilizationPreferences(UtilizationPreference... utilizationPreferences);

        /**
         * <p>
         * The resource’s CPU and memory utilization preferences, such as threshold and headroom, that were used to
         * generate rightsizing recommendations. It considers all applicable preferences that you set at the resource,
         * account, and organization level.
         * </p>
         * <p>
         * To validate that the preference is applied to your last generated set of recommendations, review the
         * <code>effectiveRecommendationPreferences</code> value in the response of the
         * GetAutoScalingGroupRecommendations or GetEC2InstanceRecommendations actions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.computeoptimizer.model.UtilizationPreference.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.computeoptimizer.model.UtilizationPreference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.computeoptimizer.model.UtilizationPreference.Builder#build()} is
         * called immediately and its result is passed to {@link #utilizationPreferences(List<UtilizationPreference>)}.
         * 
         * @param utilizationPreferences
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.computeoptimizer.model.UtilizationPreference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #utilizationPreferences(java.util.Collection<UtilizationPreference>)
         */
        Builder utilizationPreferences(Consumer<UtilizationPreference.Builder>... utilizationPreferences);

        /**
         * <p>
         * The resource type values that are considered as candidates when generating rightsizing recommendations. This
         * object resolves any wildcard expressions and returns the effective list of candidate resource type values. It
         * also considers all applicable preferences that you set at the resource, account, and organization level.
         * </p>
         * <p>
         * To validate that the preference is applied to your last generated set of recommendations, review the
         * <code>effectiveRecommendationPreferences</code> value in the response of the
         * GetAutoScalingGroupRecommendations or GetEC2InstanceRecommendations actions.
         * </p>
         * 
         * @param preferredResources
         *        The resource type values that are considered as candidates when generating rightsizing
         *        recommendations. This object resolves any wildcard expressions and returns the effective list of
         *        candidate resource type values. It also considers all applicable preferences that you set at the
         *        resource, account, and organization level. </p>
         *        <p>
         *        To validate that the preference is applied to your last generated set of recommendations, review the
         *        <code>effectiveRecommendationPreferences</code> value in the response of the
         *        GetAutoScalingGroupRecommendations or GetEC2InstanceRecommendations actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredResources(Collection<EffectivePreferredResource> preferredResources);

        /**
         * <p>
         * The resource type values that are considered as candidates when generating rightsizing recommendations. This
         * object resolves any wildcard expressions and returns the effective list of candidate resource type values. It
         * also considers all applicable preferences that you set at the resource, account, and organization level.
         * </p>
         * <p>
         * To validate that the preference is applied to your last generated set of recommendations, review the
         * <code>effectiveRecommendationPreferences</code> value in the response of the
         * GetAutoScalingGroupRecommendations or GetEC2InstanceRecommendations actions.
         * </p>
         * 
         * @param preferredResources
         *        The resource type values that are considered as candidates when generating rightsizing
         *        recommendations. This object resolves any wildcard expressions and returns the effective list of
         *        candidate resource type values. It also considers all applicable preferences that you set at the
         *        resource, account, and organization level. </p>
         *        <p>
         *        To validate that the preference is applied to your last generated set of recommendations, review the
         *        <code>effectiveRecommendationPreferences</code> value in the response of the
         *        GetAutoScalingGroupRecommendations or GetEC2InstanceRecommendations actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredResources(EffectivePreferredResource... preferredResources);

        /**
         * <p>
         * The resource type values that are considered as candidates when generating rightsizing recommendations. This
         * object resolves any wildcard expressions and returns the effective list of candidate resource type values. It
         * also considers all applicable preferences that you set at the resource, account, and organization level.
         * </p>
         * <p>
         * To validate that the preference is applied to your last generated set of recommendations, review the
         * <code>effectiveRecommendationPreferences</code> value in the response of the
         * GetAutoScalingGroupRecommendations or GetEC2InstanceRecommendations actions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.computeoptimizer.model.EffectivePreferredResource.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.computeoptimizer.model.EffectivePreferredResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.computeoptimizer.model.EffectivePreferredResource.Builder#build()} is
         * called immediately and its result is passed to {@link #preferredResources(List<EffectivePreferredResource>)}.
         * 
         * @param preferredResources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.computeoptimizer.model.EffectivePreferredResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #preferredResources(java.util.Collection<EffectivePreferredResource>)
         */
        Builder preferredResources(Consumer<EffectivePreferredResource.Builder>... preferredResources);
    }

    static final class BuilderImpl extends ComputeOptimizerResponse.BuilderImpl implements Builder {
        private String enhancedInfrastructureMetrics;

        private ExternalMetricsPreference externalMetricsPreference;

        private String lookBackPeriod;

        private List<UtilizationPreference> utilizationPreferences = DefaultSdkAutoConstructList.getInstance();

        private List<EffectivePreferredResource> preferredResources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetEffectiveRecommendationPreferencesResponse model) {
            super(model);
            enhancedInfrastructureMetrics(model.enhancedInfrastructureMetrics);
            externalMetricsPreference(model.externalMetricsPreference);
            lookBackPeriod(model.lookBackPeriod);
            utilizationPreferences(model.utilizationPreferences);
            preferredResources(model.preferredResources);
        }

        public final String getEnhancedInfrastructureMetrics() {
            return enhancedInfrastructureMetrics;
        }

        public final void setEnhancedInfrastructureMetrics(String enhancedInfrastructureMetrics) {
            this.enhancedInfrastructureMetrics = enhancedInfrastructureMetrics;
        }

        @Override
        public final Builder enhancedInfrastructureMetrics(String enhancedInfrastructureMetrics) {
            this.enhancedInfrastructureMetrics = enhancedInfrastructureMetrics;
            return this;
        }

        @Override
        public final Builder enhancedInfrastructureMetrics(EnhancedInfrastructureMetrics enhancedInfrastructureMetrics) {
            this.enhancedInfrastructureMetrics(enhancedInfrastructureMetrics == null ? null : enhancedInfrastructureMetrics
                    .toString());
            return this;
        }

        public final ExternalMetricsPreference.Builder getExternalMetricsPreference() {
            return externalMetricsPreference != null ? externalMetricsPreference.toBuilder() : null;
        }

        public final void setExternalMetricsPreference(ExternalMetricsPreference.BuilderImpl externalMetricsPreference) {
            this.externalMetricsPreference = externalMetricsPreference != null ? externalMetricsPreference.build() : null;
        }

        @Override
        public final Builder externalMetricsPreference(ExternalMetricsPreference externalMetricsPreference) {
            this.externalMetricsPreference = externalMetricsPreference;
            return this;
        }

        public final String getLookBackPeriod() {
            return lookBackPeriod;
        }

        public final void setLookBackPeriod(String lookBackPeriod) {
            this.lookBackPeriod = lookBackPeriod;
        }

        @Override
        public final Builder lookBackPeriod(String lookBackPeriod) {
            this.lookBackPeriod = lookBackPeriod;
            return this;
        }

        @Override
        public final Builder lookBackPeriod(LookBackPeriodPreference lookBackPeriod) {
            this.lookBackPeriod(lookBackPeriod == null ? null : lookBackPeriod.toString());
            return this;
        }

        public final List<UtilizationPreference.Builder> getUtilizationPreferences() {
            List<UtilizationPreference.Builder> result = UtilizationPreferencesCopier.copyToBuilder(this.utilizationPreferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUtilizationPreferences(Collection<UtilizationPreference.BuilderImpl> utilizationPreferences) {
            this.utilizationPreferences = UtilizationPreferencesCopier.copyFromBuilder(utilizationPreferences);
        }

        @Override
        public final Builder utilizationPreferences(Collection<UtilizationPreference> utilizationPreferences) {
            this.utilizationPreferences = UtilizationPreferencesCopier.copy(utilizationPreferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utilizationPreferences(UtilizationPreference... utilizationPreferences) {
            utilizationPreferences(Arrays.asList(utilizationPreferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utilizationPreferences(Consumer<UtilizationPreference.Builder>... utilizationPreferences) {
            utilizationPreferences(Stream.of(utilizationPreferences)
                    .map(c -> UtilizationPreference.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<EffectivePreferredResource.Builder> getPreferredResources() {
            List<EffectivePreferredResource.Builder> result = EffectivePreferredResourcesCopier
                    .copyToBuilder(this.preferredResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPreferredResources(Collection<EffectivePreferredResource.BuilderImpl> preferredResources) {
            this.preferredResources = EffectivePreferredResourcesCopier.copyFromBuilder(preferredResources);
        }

        @Override
        public final Builder preferredResources(Collection<EffectivePreferredResource> preferredResources) {
            this.preferredResources = EffectivePreferredResourcesCopier.copy(preferredResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder preferredResources(EffectivePreferredResource... preferredResources) {
            preferredResources(Arrays.asList(preferredResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder preferredResources(Consumer<EffectivePreferredResource.Builder>... preferredResources) {
            preferredResources(Stream.of(preferredResources)
                    .map(c -> EffectivePreferredResource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetEffectiveRecommendationPreferencesResponse build() {
            return new GetEffectiveRecommendationPreferencesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
