/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.AutoScalingConfiguration;
import software.amazon.awssdk.services.computeoptimizer.model.ContainerConfiguration;
import software.amazon.awssdk.services.computeoptimizer.model.ContainerConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceConfiguration> {
    private static final SdkField<Integer> MEMORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("memory").getter(ServiceConfiguration.getter(ServiceConfiguration::memory)).setter(ServiceConfiguration.setter(Builder::memory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memory").build()}).build();
    private static final SdkField<Integer> CPU_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("cpu").getter(ServiceConfiguration.getter(ServiceConfiguration::cpu)).setter(ServiceConfiguration.setter(Builder::cpu)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpu").build()}).build();
    private static final SdkField<List<ContainerConfiguration>> CONTAINER_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("containerConfigurations").getter(ServiceConfiguration.getter(ServiceConfiguration::containerConfigurations)).setter(ServiceConfiguration.setter(Builder::containerConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContainerConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AUTO_SCALING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("autoScalingConfiguration").getter(ServiceConfiguration.getter(ServiceConfiguration::autoScalingConfigurationAsString)).setter(ServiceConfiguration.setter(Builder::autoScalingConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingConfiguration").build()}).build();
    private static final SdkField<String> TASK_DEFINITION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskDefinitionArn").getter(ServiceConfiguration.getter(ServiceConfiguration::taskDefinitionArn)).setter(ServiceConfiguration.setter(Builder::taskDefinitionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskDefinitionArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMORY_FIELD, CPU_FIELD, CONTAINER_CONFIGURATIONS_FIELD, AUTO_SCALING_CONFIGURATION_FIELD, TASK_DEFINITION_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServiceConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer memory;
    private final Integer cpu;
    private final List<ContainerConfiguration> containerConfigurations;
    private final String autoScalingConfiguration;
    private final String taskDefinitionArn;

    private ServiceConfiguration(BuilderImpl builder) {
        this.memory = builder.memory;
        this.cpu = builder.cpu;
        this.containerConfigurations = builder.containerConfigurations;
        this.autoScalingConfiguration = builder.autoScalingConfiguration;
        this.taskDefinitionArn = builder.taskDefinitionArn;
    }

    public final Integer memory() {
        return this.memory;
    }

    public final Integer cpu() {
        return this.cpu;
    }

    public final boolean hasContainerConfigurations() {
        return this.containerConfigurations != null && !(this.containerConfigurations instanceof SdkAutoConstructList);
    }

    public final List<ContainerConfiguration> containerConfigurations() {
        return this.containerConfigurations;
    }

    public final AutoScalingConfiguration autoScalingConfiguration() {
        return AutoScalingConfiguration.fromValue(this.autoScalingConfiguration);
    }

    public final String autoScalingConfigurationAsString() {
        return this.autoScalingConfiguration;
    }

    public final String taskDefinitionArn() {
        return this.taskDefinitionArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.memory());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpu());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainerConfigurations() ? this.containerConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingConfigurationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskDefinitionArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceConfiguration)) {
            return false;
        }
        ServiceConfiguration other = (ServiceConfiguration)obj;
        return Objects.equals(this.memory(), other.memory()) && Objects.equals(this.cpu(), other.cpu()) && this.hasContainerConfigurations() == other.hasContainerConfigurations() && Objects.equals(this.containerConfigurations(), other.containerConfigurations()) && Objects.equals(this.autoScalingConfigurationAsString(), other.autoScalingConfigurationAsString()) && Objects.equals(this.taskDefinitionArn(), other.taskDefinitionArn());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceConfiguration").add("Memory", (Object)this.memory()).add("Cpu", (Object)this.cpu()).add("ContainerConfigurations", this.hasContainerConfigurations() ? this.containerConfigurations() : null).add("AutoScalingConfiguration", (Object)this.autoScalingConfigurationAsString()).add("TaskDefinitionArn", (Object)this.taskDefinitionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "memory": {
                return Optional.ofNullable(clazz.cast(this.memory()));
            }
            case "cpu": {
                return Optional.ofNullable(clazz.cast(this.cpu()));
            }
            case "containerConfigurations": {
                return Optional.ofNullable(clazz.cast(this.containerConfigurations()));
            }
            case "autoScalingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.autoScalingConfigurationAsString()));
            }
            case "taskDefinitionArn": {
                return Optional.ofNullable(clazz.cast(this.taskDefinitionArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memory", MEMORY_FIELD);
        map.put("cpu", CPU_FIELD);
        map.put("containerConfigurations", CONTAINER_CONFIGURATIONS_FIELD);
        map.put("autoScalingConfiguration", AUTO_SCALING_CONFIGURATION_FIELD);
        map.put("taskDefinitionArn", TASK_DEFINITION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceConfiguration, T> g) {
        return obj -> g.apply((ServiceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer memory;
        private Integer cpu;
        private List<ContainerConfiguration> containerConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String autoScalingConfiguration;
        private String taskDefinitionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceConfiguration model) {
            this.memory(model.memory);
            this.cpu(model.cpu);
            this.containerConfigurations(model.containerConfigurations);
            this.autoScalingConfiguration(model.autoScalingConfiguration);
            this.taskDefinitionArn(model.taskDefinitionArn);
        }

        public final Integer getMemory() {
            return this.memory;
        }

        public final void setMemory(Integer memory) {
            this.memory = memory;
        }

        @Override
        public final Builder memory(Integer memory) {
            this.memory = memory;
            return this;
        }

        public final Integer getCpu() {
            return this.cpu;
        }

        public final void setCpu(Integer cpu) {
            this.cpu = cpu;
        }

        @Override
        public final Builder cpu(Integer cpu) {
            this.cpu = cpu;
            return this;
        }

        public final List<ContainerConfiguration.Builder> getContainerConfigurations() {
            List<ContainerConfiguration.Builder> result = ContainerConfigurationsCopier.copyToBuilder(this.containerConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainerConfigurations(Collection<ContainerConfiguration.BuilderImpl> containerConfigurations) {
            this.containerConfigurations = ContainerConfigurationsCopier.copyFromBuilder(containerConfigurations);
        }

        @Override
        public final Builder containerConfigurations(Collection<ContainerConfiguration> containerConfigurations) {
            this.containerConfigurations = ContainerConfigurationsCopier.copy(containerConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerConfigurations(ContainerConfiguration ... containerConfigurations) {
            this.containerConfigurations(Arrays.asList(containerConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerConfigurations(Consumer<ContainerConfiguration.Builder> ... containerConfigurations) {
            this.containerConfigurations(Stream.of(containerConfigurations).map(c -> (ContainerConfiguration)((ContainerConfiguration.Builder)ContainerConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAutoScalingConfiguration() {
            return this.autoScalingConfiguration;
        }

        public final void setAutoScalingConfiguration(String autoScalingConfiguration) {
            this.autoScalingConfiguration = autoScalingConfiguration;
        }

        @Override
        public final Builder autoScalingConfiguration(String autoScalingConfiguration) {
            this.autoScalingConfiguration = autoScalingConfiguration;
            return this;
        }

        @Override
        public final Builder autoScalingConfiguration(AutoScalingConfiguration autoScalingConfiguration) {
            this.autoScalingConfiguration(autoScalingConfiguration == null ? null : autoScalingConfiguration.toString());
            return this;
        }

        public final String getTaskDefinitionArn() {
            return this.taskDefinitionArn;
        }

        public final void setTaskDefinitionArn(String taskDefinitionArn) {
            this.taskDefinitionArn = taskDefinitionArn;
        }

        @Override
        public final Builder taskDefinitionArn(String taskDefinitionArn) {
            this.taskDefinitionArn = taskDefinitionArn;
            return this;
        }

        public ServiceConfiguration build() {
            return new ServiceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceConfiguration> {
        public Builder memory(Integer var1);

        public Builder cpu(Integer var1);

        public Builder containerConfigurations(Collection<ContainerConfiguration> var1);

        public Builder containerConfigurations(ContainerConfiguration ... var1);

        public Builder containerConfigurations(Consumer<ContainerConfiguration.Builder> ... var1);

        public Builder autoScalingConfiguration(String var1);

        public Builder autoScalingConfiguration(AutoScalingConfiguration var1);

        public Builder taskDefinitionArn(String var1);
    }
}

