/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.computeoptimizer.model.LicenseEdition;
import software.amazon.awssdk.services.computeoptimizer.model.LicenseModel;
import software.amazon.awssdk.services.computeoptimizer.model.SavingsOpportunity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LicenseRecommendationOption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LicenseRecommendationOption> {
    private static final SdkField<Integer> RANK_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("rank").getter(LicenseRecommendationOption.getter(LicenseRecommendationOption::rank)).setter(LicenseRecommendationOption.setter(Builder::rank)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rank").build()}).build();
    private static final SdkField<String> OPERATING_SYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operatingSystem").getter(LicenseRecommendationOption.getter(LicenseRecommendationOption::operatingSystem)).setter(LicenseRecommendationOption.setter(Builder::operatingSystem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operatingSystem").build()}).build();
    private static final SdkField<String> LICENSE_EDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("licenseEdition").getter(LicenseRecommendationOption.getter(LicenseRecommendationOption::licenseEditionAsString)).setter(LicenseRecommendationOption.setter(Builder::licenseEdition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseEdition").build()}).build();
    private static final SdkField<String> LICENSE_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("licenseModel").getter(LicenseRecommendationOption.getter(LicenseRecommendationOption::licenseModelAsString)).setter(LicenseRecommendationOption.setter(Builder::licenseModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseModel").build()}).build();
    private static final SdkField<SavingsOpportunity> SAVINGS_OPPORTUNITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("savingsOpportunity").getter(LicenseRecommendationOption.getter(LicenseRecommendationOption::savingsOpportunity)).setter(LicenseRecommendationOption.setter(Builder::savingsOpportunity)).constructor(SavingsOpportunity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsOpportunity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RANK_FIELD, OPERATING_SYSTEM_FIELD, LICENSE_EDITION_FIELD, LICENSE_MODEL_FIELD, SAVINGS_OPPORTUNITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LicenseRecommendationOption.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer rank;
    private final String operatingSystem;
    private final String licenseEdition;
    private final String licenseModel;
    private final SavingsOpportunity savingsOpportunity;

    private LicenseRecommendationOption(BuilderImpl builder) {
        this.rank = builder.rank;
        this.operatingSystem = builder.operatingSystem;
        this.licenseEdition = builder.licenseEdition;
        this.licenseModel = builder.licenseModel;
        this.savingsOpportunity = builder.savingsOpportunity;
    }

    public final Integer rank() {
        return this.rank;
    }

    public final String operatingSystem() {
        return this.operatingSystem;
    }

    public final LicenseEdition licenseEdition() {
        return LicenseEdition.fromValue(this.licenseEdition);
    }

    public final String licenseEditionAsString() {
        return this.licenseEdition;
    }

    public final LicenseModel licenseModel() {
        return LicenseModel.fromValue(this.licenseModel);
    }

    public final String licenseModelAsString() {
        return this.licenseModel;
    }

    public final SavingsOpportunity savingsOpportunity() {
        return this.savingsOpportunity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rank());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystem());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseEditionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsOpportunity());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LicenseRecommendationOption)) {
            return false;
        }
        LicenseRecommendationOption other = (LicenseRecommendationOption)obj;
        return Objects.equals(this.rank(), other.rank()) && Objects.equals(this.operatingSystem(), other.operatingSystem()) && Objects.equals(this.licenseEditionAsString(), other.licenseEditionAsString()) && Objects.equals(this.licenseModelAsString(), other.licenseModelAsString()) && Objects.equals(this.savingsOpportunity(), other.savingsOpportunity());
    }

    public final String toString() {
        return ToString.builder((String)"LicenseRecommendationOption").add("Rank", (Object)this.rank()).add("OperatingSystem", (Object)this.operatingSystem()).add("LicenseEdition", (Object)this.licenseEditionAsString()).add("LicenseModel", (Object)this.licenseModelAsString()).add("SavingsOpportunity", (Object)this.savingsOpportunity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "rank": {
                return Optional.ofNullable(clazz.cast(this.rank()));
            }
            case "operatingSystem": {
                return Optional.ofNullable(clazz.cast(this.operatingSystem()));
            }
            case "licenseEdition": {
                return Optional.ofNullable(clazz.cast(this.licenseEditionAsString()));
            }
            case "licenseModel": {
                return Optional.ofNullable(clazz.cast(this.licenseModelAsString()));
            }
            case "savingsOpportunity": {
                return Optional.ofNullable(clazz.cast(this.savingsOpportunity()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rank", RANK_FIELD);
        map.put("operatingSystem", OPERATING_SYSTEM_FIELD);
        map.put("licenseEdition", LICENSE_EDITION_FIELD);
        map.put("licenseModel", LICENSE_MODEL_FIELD);
        map.put("savingsOpportunity", SAVINGS_OPPORTUNITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LicenseRecommendationOption, T> g) {
        return obj -> g.apply((LicenseRecommendationOption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer rank;
        private String operatingSystem;
        private String licenseEdition;
        private String licenseModel;
        private SavingsOpportunity savingsOpportunity;

        private BuilderImpl() {
        }

        private BuilderImpl(LicenseRecommendationOption model) {
            this.rank(model.rank);
            this.operatingSystem(model.operatingSystem);
            this.licenseEdition(model.licenseEdition);
            this.licenseModel(model.licenseModel);
            this.savingsOpportunity(model.savingsOpportunity);
        }

        public final Integer getRank() {
            return this.rank;
        }

        public final void setRank(Integer rank) {
            this.rank = rank;
        }

        @Override
        public final Builder rank(Integer rank) {
            this.rank = rank;
            return this;
        }

        public final String getOperatingSystem() {
            return this.operatingSystem;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        public final String getLicenseEdition() {
            return this.licenseEdition;
        }

        public final void setLicenseEdition(String licenseEdition) {
            this.licenseEdition = licenseEdition;
        }

        @Override
        public final Builder licenseEdition(String licenseEdition) {
            this.licenseEdition = licenseEdition;
            return this;
        }

        @Override
        public final Builder licenseEdition(LicenseEdition licenseEdition) {
            this.licenseEdition(licenseEdition == null ? null : licenseEdition.toString());
            return this;
        }

        public final String getLicenseModel() {
            return this.licenseModel;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        @Override
        public final Builder licenseModel(LicenseModel licenseModel) {
            this.licenseModel(licenseModel == null ? null : licenseModel.toString());
            return this;
        }

        public final SavingsOpportunity.Builder getSavingsOpportunity() {
            return this.savingsOpportunity != null ? this.savingsOpportunity.toBuilder() : null;
        }

        public final void setSavingsOpportunity(SavingsOpportunity.BuilderImpl savingsOpportunity) {
            this.savingsOpportunity = savingsOpportunity != null ? savingsOpportunity.build() : null;
        }

        @Override
        public final Builder savingsOpportunity(SavingsOpportunity savingsOpportunity) {
            this.savingsOpportunity = savingsOpportunity;
            return this;
        }

        public LicenseRecommendationOption build() {
            return new LicenseRecommendationOption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LicenseRecommendationOption> {
        public Builder rank(Integer var1);

        public Builder operatingSystem(String var1);

        public Builder licenseEdition(String var1);

        public Builder licenseEdition(LicenseEdition var1);

        public Builder licenseModel(String var1);

        public Builder licenseModel(LicenseModel var1);

        public Builder savingsOpportunity(SavingsOpportunity var1);

        default public Builder savingsOpportunity(Consumer<SavingsOpportunity.Builder> savingsOpportunity) {
            return this.savingsOpportunity((SavingsOpportunity)((SavingsOpportunity.Builder)SavingsOpportunity.builder().applyMutation(savingsOpportunity)).build());
        }
    }
}

