/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.computeoptimizer.model.ComputeOptimizerRequest;
import software.amazon.awssdk.services.computeoptimizer.model.MetricStatistic;
import software.amazon.awssdk.services.computeoptimizer.model.RecommendationPreferences;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEc2RecommendationProjectedMetricsRequest
extends ComputeOptimizerRequest
implements ToCopyableBuilder<Builder, GetEc2RecommendationProjectedMetricsRequest> {
    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceArn").getter(GetEc2RecommendationProjectedMetricsRequest.getter(GetEc2RecommendationProjectedMetricsRequest::instanceArn)).setter(GetEc2RecommendationProjectedMetricsRequest.setter(Builder::instanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceArn").build()}).build();
    private static final SdkField<String> STAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stat").getter(GetEc2RecommendationProjectedMetricsRequest.getter(GetEc2RecommendationProjectedMetricsRequest::statAsString)).setter(GetEc2RecommendationProjectedMetricsRequest.setter(Builder::stat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stat").build()}).build();
    private static final SdkField<Integer> PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("period").getter(GetEc2RecommendationProjectedMetricsRequest.getter(GetEc2RecommendationProjectedMetricsRequest::period)).setter(GetEc2RecommendationProjectedMetricsRequest.setter(Builder::period)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("period").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(GetEc2RecommendationProjectedMetricsRequest.getter(GetEc2RecommendationProjectedMetricsRequest::startTime)).setter(GetEc2RecommendationProjectedMetricsRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(GetEc2RecommendationProjectedMetricsRequest.getter(GetEc2RecommendationProjectedMetricsRequest::endTime)).setter(GetEc2RecommendationProjectedMetricsRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<RecommendationPreferences> RECOMMENDATION_PREFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("recommendationPreferences").getter(GetEc2RecommendationProjectedMetricsRequest.getter(GetEc2RecommendationProjectedMetricsRequest::recommendationPreferences)).setter(GetEc2RecommendationProjectedMetricsRequest.setter(Builder::recommendationPreferences)).constructor(RecommendationPreferences::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationPreferences").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ARN_FIELD, STAT_FIELD, PERIOD_FIELD, START_TIME_FIELD, END_TIME_FIELD, RECOMMENDATION_PREFERENCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetEc2RecommendationProjectedMetricsRequest.memberNameToFieldInitializer();
    private final String instanceArn;
    private final String stat;
    private final Integer period;
    private final Instant startTime;
    private final Instant endTime;
    private final RecommendationPreferences recommendationPreferences;

    private GetEc2RecommendationProjectedMetricsRequest(BuilderImpl builder) {
        super(builder);
        this.instanceArn = builder.instanceArn;
        this.stat = builder.stat;
        this.period = builder.period;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.recommendationPreferences = builder.recommendationPreferences;
    }

    public final String instanceArn() {
        return this.instanceArn;
    }

    public final MetricStatistic stat() {
        return MetricStatistic.fromValue(this.stat);
    }

    public final String statAsString() {
        return this.stat;
    }

    public final Integer period() {
        return this.period;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final RecommendationPreferences recommendationPreferences() {
        return this.recommendationPreferences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.period());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationPreferences());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEc2RecommendationProjectedMetricsRequest)) {
            return false;
        }
        GetEc2RecommendationProjectedMetricsRequest other = (GetEc2RecommendationProjectedMetricsRequest)((Object)obj);
        return Objects.equals(this.instanceArn(), other.instanceArn()) && Objects.equals(this.statAsString(), other.statAsString()) && Objects.equals(this.period(), other.period()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.recommendationPreferences(), other.recommendationPreferences());
    }

    public final String toString() {
        return ToString.builder((String)"GetEc2RecommendationProjectedMetricsRequest").add("InstanceArn", (Object)this.instanceArn()).add("Stat", (Object)this.statAsString()).add("Period", (Object)this.period()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("RecommendationPreferences", (Object)this.recommendationPreferences()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceArn": {
                return Optional.ofNullable(clazz.cast(this.instanceArn()));
            }
            case "stat": {
                return Optional.ofNullable(clazz.cast(this.statAsString()));
            }
            case "period": {
                return Optional.ofNullable(clazz.cast(this.period()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "recommendationPreferences": {
                return Optional.ofNullable(clazz.cast(this.recommendationPreferences()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("instanceArn", INSTANCE_ARN_FIELD);
        map.put("stat", STAT_FIELD);
        map.put("period", PERIOD_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("recommendationPreferences", RECOMMENDATION_PREFERENCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetEc2RecommendationProjectedMetricsRequest, T> g) {
        return obj -> g.apply((GetEc2RecommendationProjectedMetricsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComputeOptimizerRequest.BuilderImpl
    implements Builder {
        private String instanceArn;
        private String stat;
        private Integer period;
        private Instant startTime;
        private Instant endTime;
        private RecommendationPreferences recommendationPreferences;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEc2RecommendationProjectedMetricsRequest model) {
            super(model);
            this.instanceArn(model.instanceArn);
            this.stat(model.stat);
            this.period(model.period);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.recommendationPreferences(model.recommendationPreferences);
        }

        public final String getInstanceArn() {
            return this.instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final String getStat() {
            return this.stat;
        }

        public final void setStat(String stat) {
            this.stat = stat;
        }

        @Override
        public final Builder stat(String stat) {
            this.stat = stat;
            return this;
        }

        @Override
        public final Builder stat(MetricStatistic stat) {
            this.stat(stat == null ? null : stat.toString());
            return this;
        }

        public final Integer getPeriod() {
            return this.period;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final RecommendationPreferences.Builder getRecommendationPreferences() {
            return this.recommendationPreferences != null ? this.recommendationPreferences.toBuilder() : null;
        }

        public final void setRecommendationPreferences(RecommendationPreferences.BuilderImpl recommendationPreferences) {
            this.recommendationPreferences = recommendationPreferences != null ? recommendationPreferences.build() : null;
        }

        @Override
        public final Builder recommendationPreferences(RecommendationPreferences recommendationPreferences) {
            this.recommendationPreferences = recommendationPreferences;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetEc2RecommendationProjectedMetricsRequest build() {
            return new GetEc2RecommendationProjectedMetricsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ComputeOptimizerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEc2RecommendationProjectedMetricsRequest> {
        public Builder instanceArn(String var1);

        public Builder stat(String var1);

        public Builder stat(MetricStatistic var1);

        public Builder period(Integer var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder recommendationPreferences(RecommendationPreferences var1);

        default public Builder recommendationPreferences(Consumer<RecommendationPreferences.Builder> recommendationPreferences) {
            return this.recommendationPreferences((RecommendationPreferences)((RecommendationPreferences.Builder)RecommendationPreferences.builder().applyMutation(recommendationPreferences)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

