/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IdleMetricName {
    CPU("CPU"),
    MEMORY("Memory"),
    NETWORK_OUT_BYTES_PER_SECOND("NetworkOutBytesPerSecond"),
    NETWORK_IN_BYTES_PER_SECOND("NetworkInBytesPerSecond"),
    DATABASE_CONNECTIONS("DatabaseConnections"),
    EBS_VOLUME_READ_IOPS("EBSVolumeReadIOPS"),
    EBS_VOLUME_WRITE_IOPS("EBSVolumeWriteIOPS"),
    VOLUME_READ_OPS_PER_SECOND("VolumeReadOpsPerSecond"),
    VOLUME_WRITE_OPS_PER_SECOND("VolumeWriteOpsPerSecond"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IdleMetricName> VALUE_MAP;
    private final String value;

    private IdleMetricName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IdleMetricName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IdleMetricName> knownValues() {
        EnumSet<IdleMetricName> knownValues = EnumSet.allOf(IdleMetricName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IdleMetricName.class, IdleMetricName::toString);
    }
}

