/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MemorySizeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MemorySizeConfiguration> {
    private static final SdkField<Integer> MEMORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("memory").getter(MemorySizeConfiguration.getter(MemorySizeConfiguration::memory)).setter(MemorySizeConfiguration.setter(Builder::memory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memory").build()}).build();
    private static final SdkField<Integer> MEMORY_RESERVATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("memoryReservation").getter(MemorySizeConfiguration.getter(MemorySizeConfiguration::memoryReservation)).setter(MemorySizeConfiguration.setter(Builder::memoryReservation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryReservation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMORY_FIELD, MEMORY_RESERVATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MemorySizeConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer memory;
    private final Integer memoryReservation;

    private MemorySizeConfiguration(BuilderImpl builder) {
        this.memory = builder.memory;
        this.memoryReservation = builder.memoryReservation;
    }

    public final Integer memory() {
        return this.memory;
    }

    public final Integer memoryReservation() {
        return this.memoryReservation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.memory());
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryReservation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemorySizeConfiguration)) {
            return false;
        }
        MemorySizeConfiguration other = (MemorySizeConfiguration)obj;
        return Objects.equals(this.memory(), other.memory()) && Objects.equals(this.memoryReservation(), other.memoryReservation());
    }

    public final String toString() {
        return ToString.builder((String)"MemorySizeConfiguration").add("Memory", (Object)this.memory()).add("MemoryReservation", (Object)this.memoryReservation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "memory": {
                return Optional.ofNullable(clazz.cast(this.memory()));
            }
            case "memoryReservation": {
                return Optional.ofNullable(clazz.cast(this.memoryReservation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Integer>> map = new HashMap<String, SdkField<Integer>>();
        map.put("memory", MEMORY_FIELD);
        map.put("memoryReservation", MEMORY_RESERVATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MemorySizeConfiguration, T> g) {
        return obj -> g.apply((MemorySizeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer memory;
        private Integer memoryReservation;

        private BuilderImpl() {
        }

        private BuilderImpl(MemorySizeConfiguration model) {
            this.memory(model.memory);
            this.memoryReservation(model.memoryReservation);
        }

        public final Integer getMemory() {
            return this.memory;
        }

        public final void setMemory(Integer memory) {
            this.memory = memory;
        }

        @Override
        public final Builder memory(Integer memory) {
            this.memory = memory;
            return this;
        }

        public final Integer getMemoryReservation() {
            return this.memoryReservation;
        }

        public final void setMemoryReservation(Integer memoryReservation) {
            this.memoryReservation = memoryReservation;
        }

        @Override
        public final Builder memoryReservation(Integer memoryReservation) {
            this.memoryReservation = memoryReservation;
            return this;
        }

        public MemorySizeConfiguration build() {
            return new MemorySizeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MemorySizeConfiguration> {
        public Builder memory(Integer var1);

        public Builder memoryReservation(Integer var1);
    }
}

