/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.CurrentPerformanceRisk;
import software.amazon.awssdk.services.computeoptimizer.model.ECSEffectiveRecommendationPreferences;
import software.amazon.awssdk.services.computeoptimizer.model.ECSServiceLaunchType;
import software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFinding;
import software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFindingReasonCode;
import software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFindingReasonCodesCopier;
import software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationOption;
import software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationOptionsCopier;
import software.amazon.awssdk.services.computeoptimizer.model.ECSServiceUtilizationMetric;
import software.amazon.awssdk.services.computeoptimizer.model.ECSServiceUtilizationMetricsCopier;
import software.amazon.awssdk.services.computeoptimizer.model.ServiceConfiguration;
import software.amazon.awssdk.services.computeoptimizer.model.Tag;
import software.amazon.awssdk.services.computeoptimizer.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ECSServiceRecommendation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ECSServiceRecommendation> {
    private static final SdkField<String> SERVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceArn").getter(ECSServiceRecommendation.getter(ECSServiceRecommendation::serviceArn)).setter(ECSServiceRecommendation.setter(Builder::serviceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceArn").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(ECSServiceRecommendation.getter(ECSServiceRecommendation::accountId)).setter(ECSServiceRecommendation.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<ServiceConfiguration> CURRENT_SERVICE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("currentServiceConfiguration").getter(ECSServiceRecommendation.getter(ECSServiceRecommendation::currentServiceConfiguration)).setter(ECSServiceRecommendation.setter(Builder::currentServiceConfiguration)).constructor(ServiceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentServiceConfiguration").build()}).build();
    private static final SdkField<List<ECSServiceUtilizationMetric>> UTILIZATION_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("utilizationMetrics").getter(ECSServiceRecommendation.getter(ECSServiceRecommendation::utilizationMetrics)).setter(ECSServiceRecommendation.setter(Builder::utilizationMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("utilizationMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ECSServiceUtilizationMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> LOOKBACK_PERIOD_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("lookbackPeriodInDays").getter(ECSServiceRecommendation.getter(ECSServiceRecommendation::lookbackPeriodInDays)).setter(ECSServiceRecommendation.setter(Builder::lookbackPeriodInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lookbackPeriodInDays").build()}).build();
    private static final SdkField<String> LAUNCH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("launchType").getter(ECSServiceRecommendation.getter(ECSServiceRecommendation::launchTypeAsString)).setter(ECSServiceRecommendation.setter(Builder::launchType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchType").build()}).build();
    private static final SdkField<Instant> LAST_REFRESH_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastRefreshTimestamp").getter(ECSServiceRecommendation.getter(ECSServiceRecommendation::lastRefreshTimestamp)).setter(ECSServiceRecommendation.setter(Builder::lastRefreshTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRefreshTimestamp").build()}).build();
    private static final SdkField<String> FINDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("finding").getter(ECSServiceRecommendation.getter(ECSServiceRecommendation::findingAsString)).setter(ECSServiceRecommendation.setter(Builder::finding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("finding").build()}).build();
    private static final SdkField<List<String>> FINDING_REASON_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("findingReasonCodes").getter(ECSServiceRecommendation.getter(ECSServiceRecommendation::findingReasonCodesAsStrings)).setter(ECSServiceRecommendation.setter(Builder::findingReasonCodesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingReasonCodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ECSServiceRecommendationOption>> SERVICE_RECOMMENDATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("serviceRecommendationOptions").getter(ECSServiceRecommendation.getter(ECSServiceRecommendation::serviceRecommendationOptions)).setter(ECSServiceRecommendation.setter(Builder::serviceRecommendationOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRecommendationOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ECSServiceRecommendationOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CURRENT_PERFORMANCE_RISK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currentPerformanceRisk").getter(ECSServiceRecommendation.getter(ECSServiceRecommendation::currentPerformanceRiskAsString)).setter(ECSServiceRecommendation.setter(Builder::currentPerformanceRisk)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentPerformanceRisk").build()}).build();
    private static final SdkField<ECSEffectiveRecommendationPreferences> EFFECTIVE_RECOMMENDATION_PREFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("effectiveRecommendationPreferences").getter(ECSServiceRecommendation.getter(ECSServiceRecommendation::effectiveRecommendationPreferences)).setter(ECSServiceRecommendation.setter(Builder::effectiveRecommendationPreferences)).constructor(ECSEffectiveRecommendationPreferences::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effectiveRecommendationPreferences").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(ECSServiceRecommendation.getter(ECSServiceRecommendation::tags)).setter(ECSServiceRecommendation.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ARN_FIELD, ACCOUNT_ID_FIELD, CURRENT_SERVICE_CONFIGURATION_FIELD, UTILIZATION_METRICS_FIELD, LOOKBACK_PERIOD_IN_DAYS_FIELD, LAUNCH_TYPE_FIELD, LAST_REFRESH_TIMESTAMP_FIELD, FINDING_FIELD, FINDING_REASON_CODES_FIELD, SERVICE_RECOMMENDATION_OPTIONS_FIELD, CURRENT_PERFORMANCE_RISK_FIELD, EFFECTIVE_RECOMMENDATION_PREFERENCES_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ECSServiceRecommendation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String serviceArn;
    private final String accountId;
    private final ServiceConfiguration currentServiceConfiguration;
    private final List<ECSServiceUtilizationMetric> utilizationMetrics;
    private final Double lookbackPeriodInDays;
    private final String launchType;
    private final Instant lastRefreshTimestamp;
    private final String finding;
    private final List<String> findingReasonCodes;
    private final List<ECSServiceRecommendationOption> serviceRecommendationOptions;
    private final String currentPerformanceRisk;
    private final ECSEffectiveRecommendationPreferences effectiveRecommendationPreferences;
    private final List<Tag> tags;

    private ECSServiceRecommendation(BuilderImpl builder) {
        this.serviceArn = builder.serviceArn;
        this.accountId = builder.accountId;
        this.currentServiceConfiguration = builder.currentServiceConfiguration;
        this.utilizationMetrics = builder.utilizationMetrics;
        this.lookbackPeriodInDays = builder.lookbackPeriodInDays;
        this.launchType = builder.launchType;
        this.lastRefreshTimestamp = builder.lastRefreshTimestamp;
        this.finding = builder.finding;
        this.findingReasonCodes = builder.findingReasonCodes;
        this.serviceRecommendationOptions = builder.serviceRecommendationOptions;
        this.currentPerformanceRisk = builder.currentPerformanceRisk;
        this.effectiveRecommendationPreferences = builder.effectiveRecommendationPreferences;
        this.tags = builder.tags;
    }

    public final String serviceArn() {
        return this.serviceArn;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final ServiceConfiguration currentServiceConfiguration() {
        return this.currentServiceConfiguration;
    }

    public final boolean hasUtilizationMetrics() {
        return this.utilizationMetrics != null && !(this.utilizationMetrics instanceof SdkAutoConstructList);
    }

    public final List<ECSServiceUtilizationMetric> utilizationMetrics() {
        return this.utilizationMetrics;
    }

    public final Double lookbackPeriodInDays() {
        return this.lookbackPeriodInDays;
    }

    public final ECSServiceLaunchType launchType() {
        return ECSServiceLaunchType.fromValue(this.launchType);
    }

    public final String launchTypeAsString() {
        return this.launchType;
    }

    public final Instant lastRefreshTimestamp() {
        return this.lastRefreshTimestamp;
    }

    public final ECSServiceRecommendationFinding finding() {
        return ECSServiceRecommendationFinding.fromValue(this.finding);
    }

    public final String findingAsString() {
        return this.finding;
    }

    public final List<ECSServiceRecommendationFindingReasonCode> findingReasonCodes() {
        return ECSServiceRecommendationFindingReasonCodesCopier.copyStringToEnum(this.findingReasonCodes);
    }

    public final boolean hasFindingReasonCodes() {
        return this.findingReasonCodes != null && !(this.findingReasonCodes instanceof SdkAutoConstructList);
    }

    public final List<String> findingReasonCodesAsStrings() {
        return this.findingReasonCodes;
    }

    public final boolean hasServiceRecommendationOptions() {
        return this.serviceRecommendationOptions != null && !(this.serviceRecommendationOptions instanceof SdkAutoConstructList);
    }

    public final List<ECSServiceRecommendationOption> serviceRecommendationOptions() {
        return this.serviceRecommendationOptions;
    }

    public final CurrentPerformanceRisk currentPerformanceRisk() {
        return CurrentPerformanceRisk.fromValue(this.currentPerformanceRisk);
    }

    public final String currentPerformanceRiskAsString() {
        return this.currentPerformanceRisk;
    }

    public final ECSEffectiveRecommendationPreferences effectiveRecommendationPreferences() {
        return this.effectiveRecommendationPreferences;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentServiceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUtilizationMetrics() ? this.utilizationMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lookbackPeriodInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRefreshTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFindingReasonCodes() ? this.findingReasonCodesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceRecommendationOptions() ? this.serviceRecommendationOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.currentPerformanceRiskAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.effectiveRecommendationPreferences());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ECSServiceRecommendation)) {
            return false;
        }
        ECSServiceRecommendation other = (ECSServiceRecommendation)obj;
        return Objects.equals(this.serviceArn(), other.serviceArn()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.currentServiceConfiguration(), other.currentServiceConfiguration()) && this.hasUtilizationMetrics() == other.hasUtilizationMetrics() && Objects.equals(this.utilizationMetrics(), other.utilizationMetrics()) && Objects.equals(this.lookbackPeriodInDays(), other.lookbackPeriodInDays()) && Objects.equals(this.launchTypeAsString(), other.launchTypeAsString()) && Objects.equals(this.lastRefreshTimestamp(), other.lastRefreshTimestamp()) && Objects.equals(this.findingAsString(), other.findingAsString()) && this.hasFindingReasonCodes() == other.hasFindingReasonCodes() && Objects.equals(this.findingReasonCodesAsStrings(), other.findingReasonCodesAsStrings()) && this.hasServiceRecommendationOptions() == other.hasServiceRecommendationOptions() && Objects.equals(this.serviceRecommendationOptions(), other.serviceRecommendationOptions()) && Objects.equals(this.currentPerformanceRiskAsString(), other.currentPerformanceRiskAsString()) && Objects.equals(this.effectiveRecommendationPreferences(), other.effectiveRecommendationPreferences()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"ECSServiceRecommendation").add("ServiceArn", (Object)this.serviceArn()).add("AccountId", (Object)this.accountId()).add("CurrentServiceConfiguration", (Object)this.currentServiceConfiguration()).add("UtilizationMetrics", this.hasUtilizationMetrics() ? this.utilizationMetrics() : null).add("LookbackPeriodInDays", (Object)this.lookbackPeriodInDays()).add("LaunchType", (Object)this.launchTypeAsString()).add("LastRefreshTimestamp", (Object)this.lastRefreshTimestamp()).add("Finding", (Object)this.findingAsString()).add("FindingReasonCodes", this.hasFindingReasonCodes() ? this.findingReasonCodesAsStrings() : null).add("ServiceRecommendationOptions", this.hasServiceRecommendationOptions() ? this.serviceRecommendationOptions() : null).add("CurrentPerformanceRisk", (Object)this.currentPerformanceRiskAsString()).add("EffectiveRecommendationPreferences", (Object)this.effectiveRecommendationPreferences()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceArn": {
                return Optional.ofNullable(clazz.cast(this.serviceArn()));
            }
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "currentServiceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.currentServiceConfiguration()));
            }
            case "utilizationMetrics": {
                return Optional.ofNullable(clazz.cast(this.utilizationMetrics()));
            }
            case "lookbackPeriodInDays": {
                return Optional.ofNullable(clazz.cast(this.lookbackPeriodInDays()));
            }
            case "launchType": {
                return Optional.ofNullable(clazz.cast(this.launchTypeAsString()));
            }
            case "lastRefreshTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastRefreshTimestamp()));
            }
            case "finding": {
                return Optional.ofNullable(clazz.cast(this.findingAsString()));
            }
            case "findingReasonCodes": {
                return Optional.ofNullable(clazz.cast(this.findingReasonCodesAsStrings()));
            }
            case "serviceRecommendationOptions": {
                return Optional.ofNullable(clazz.cast(this.serviceRecommendationOptions()));
            }
            case "currentPerformanceRisk": {
                return Optional.ofNullable(clazz.cast(this.currentPerformanceRiskAsString()));
            }
            case "effectiveRecommendationPreferences": {
                return Optional.ofNullable(clazz.cast(this.effectiveRecommendationPreferences()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("serviceArn", SERVICE_ARN_FIELD);
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("currentServiceConfiguration", CURRENT_SERVICE_CONFIGURATION_FIELD);
        map.put("utilizationMetrics", UTILIZATION_METRICS_FIELD);
        map.put("lookbackPeriodInDays", LOOKBACK_PERIOD_IN_DAYS_FIELD);
        map.put("launchType", LAUNCH_TYPE_FIELD);
        map.put("lastRefreshTimestamp", LAST_REFRESH_TIMESTAMP_FIELD);
        map.put("finding", FINDING_FIELD);
        map.put("findingReasonCodes", FINDING_REASON_CODES_FIELD);
        map.put("serviceRecommendationOptions", SERVICE_RECOMMENDATION_OPTIONS_FIELD);
        map.put("currentPerformanceRisk", CURRENT_PERFORMANCE_RISK_FIELD);
        map.put("effectiveRecommendationPreferences", EFFECTIVE_RECOMMENDATION_PREFERENCES_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ECSServiceRecommendation, T> g) {
        return obj -> g.apply((ECSServiceRecommendation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceArn;
        private String accountId;
        private ServiceConfiguration currentServiceConfiguration;
        private List<ECSServiceUtilizationMetric> utilizationMetrics = DefaultSdkAutoConstructList.getInstance();
        private Double lookbackPeriodInDays;
        private String launchType;
        private Instant lastRefreshTimestamp;
        private String finding;
        private List<String> findingReasonCodes = DefaultSdkAutoConstructList.getInstance();
        private List<ECSServiceRecommendationOption> serviceRecommendationOptions = DefaultSdkAutoConstructList.getInstance();
        private String currentPerformanceRisk;
        private ECSEffectiveRecommendationPreferences effectiveRecommendationPreferences;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ECSServiceRecommendation model) {
            this.serviceArn(model.serviceArn);
            this.accountId(model.accountId);
            this.currentServiceConfiguration(model.currentServiceConfiguration);
            this.utilizationMetrics(model.utilizationMetrics);
            this.lookbackPeriodInDays(model.lookbackPeriodInDays);
            this.launchType(model.launchType);
            this.lastRefreshTimestamp(model.lastRefreshTimestamp);
            this.finding(model.finding);
            this.findingReasonCodesWithStrings(model.findingReasonCodes);
            this.serviceRecommendationOptions(model.serviceRecommendationOptions);
            this.currentPerformanceRisk(model.currentPerformanceRisk);
            this.effectiveRecommendationPreferences(model.effectiveRecommendationPreferences);
            this.tags(model.tags);
        }

        public final String getServiceArn() {
            return this.serviceArn;
        }

        public final void setServiceArn(String serviceArn) {
            this.serviceArn = serviceArn;
        }

        @Override
        public final Builder serviceArn(String serviceArn) {
            this.serviceArn = serviceArn;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final ServiceConfiguration.Builder getCurrentServiceConfiguration() {
            return this.currentServiceConfiguration != null ? this.currentServiceConfiguration.toBuilder() : null;
        }

        public final void setCurrentServiceConfiguration(ServiceConfiguration.BuilderImpl currentServiceConfiguration) {
            this.currentServiceConfiguration = currentServiceConfiguration != null ? currentServiceConfiguration.build() : null;
        }

        @Override
        public final Builder currentServiceConfiguration(ServiceConfiguration currentServiceConfiguration) {
            this.currentServiceConfiguration = currentServiceConfiguration;
            return this;
        }

        public final List<ECSServiceUtilizationMetric.Builder> getUtilizationMetrics() {
            List<ECSServiceUtilizationMetric.Builder> result = ECSServiceUtilizationMetricsCopier.copyToBuilder(this.utilizationMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUtilizationMetrics(Collection<ECSServiceUtilizationMetric.BuilderImpl> utilizationMetrics) {
            this.utilizationMetrics = ECSServiceUtilizationMetricsCopier.copyFromBuilder(utilizationMetrics);
        }

        @Override
        public final Builder utilizationMetrics(Collection<ECSServiceUtilizationMetric> utilizationMetrics) {
            this.utilizationMetrics = ECSServiceUtilizationMetricsCopier.copy(utilizationMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utilizationMetrics(ECSServiceUtilizationMetric ... utilizationMetrics) {
            this.utilizationMetrics(Arrays.asList(utilizationMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utilizationMetrics(Consumer<ECSServiceUtilizationMetric.Builder> ... utilizationMetrics) {
            this.utilizationMetrics(Stream.of(utilizationMetrics).map(c -> (ECSServiceUtilizationMetric)((ECSServiceUtilizationMetric.Builder)ECSServiceUtilizationMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Double getLookbackPeriodInDays() {
            return this.lookbackPeriodInDays;
        }

        public final void setLookbackPeriodInDays(Double lookbackPeriodInDays) {
            this.lookbackPeriodInDays = lookbackPeriodInDays;
        }

        @Override
        public final Builder lookbackPeriodInDays(Double lookbackPeriodInDays) {
            this.lookbackPeriodInDays = lookbackPeriodInDays;
            return this;
        }

        public final String getLaunchType() {
            return this.launchType;
        }

        public final void setLaunchType(String launchType) {
            this.launchType = launchType;
        }

        @Override
        public final Builder launchType(String launchType) {
            this.launchType = launchType;
            return this;
        }

        @Override
        public final Builder launchType(ECSServiceLaunchType launchType) {
            this.launchType(launchType == null ? null : launchType.toString());
            return this;
        }

        public final Instant getLastRefreshTimestamp() {
            return this.lastRefreshTimestamp;
        }

        public final void setLastRefreshTimestamp(Instant lastRefreshTimestamp) {
            this.lastRefreshTimestamp = lastRefreshTimestamp;
        }

        @Override
        public final Builder lastRefreshTimestamp(Instant lastRefreshTimestamp) {
            this.lastRefreshTimestamp = lastRefreshTimestamp;
            return this;
        }

        public final String getFinding() {
            return this.finding;
        }

        public final void setFinding(String finding) {
            this.finding = finding;
        }

        @Override
        public final Builder finding(String finding) {
            this.finding = finding;
            return this;
        }

        @Override
        public final Builder finding(ECSServiceRecommendationFinding finding) {
            this.finding(finding == null ? null : finding.toString());
            return this;
        }

        public final Collection<String> getFindingReasonCodes() {
            if (this.findingReasonCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.findingReasonCodes;
        }

        public final void setFindingReasonCodes(Collection<String> findingReasonCodes) {
            this.findingReasonCodes = ECSServiceRecommendationFindingReasonCodesCopier.copy(findingReasonCodes);
        }

        @Override
        public final Builder findingReasonCodesWithStrings(Collection<String> findingReasonCodes) {
            this.findingReasonCodes = ECSServiceRecommendationFindingReasonCodesCopier.copy(findingReasonCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingReasonCodesWithStrings(String ... findingReasonCodes) {
            this.findingReasonCodesWithStrings(Arrays.asList(findingReasonCodes));
            return this;
        }

        @Override
        public final Builder findingReasonCodes(Collection<ECSServiceRecommendationFindingReasonCode> findingReasonCodes) {
            this.findingReasonCodes = ECSServiceRecommendationFindingReasonCodesCopier.copyEnumToString(findingReasonCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingReasonCodes(ECSServiceRecommendationFindingReasonCode ... findingReasonCodes) {
            this.findingReasonCodes(Arrays.asList(findingReasonCodes));
            return this;
        }

        public final List<ECSServiceRecommendationOption.Builder> getServiceRecommendationOptions() {
            List<ECSServiceRecommendationOption.Builder> result = ECSServiceRecommendationOptionsCopier.copyToBuilder(this.serviceRecommendationOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceRecommendationOptions(Collection<ECSServiceRecommendationOption.BuilderImpl> serviceRecommendationOptions) {
            this.serviceRecommendationOptions = ECSServiceRecommendationOptionsCopier.copyFromBuilder(serviceRecommendationOptions);
        }

        @Override
        public final Builder serviceRecommendationOptions(Collection<ECSServiceRecommendationOption> serviceRecommendationOptions) {
            this.serviceRecommendationOptions = ECSServiceRecommendationOptionsCopier.copy(serviceRecommendationOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceRecommendationOptions(ECSServiceRecommendationOption ... serviceRecommendationOptions) {
            this.serviceRecommendationOptions(Arrays.asList(serviceRecommendationOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceRecommendationOptions(Consumer<ECSServiceRecommendationOption.Builder> ... serviceRecommendationOptions) {
            this.serviceRecommendationOptions(Stream.of(serviceRecommendationOptions).map(c -> (ECSServiceRecommendationOption)((ECSServiceRecommendationOption.Builder)ECSServiceRecommendationOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCurrentPerformanceRisk() {
            return this.currentPerformanceRisk;
        }

        public final void setCurrentPerformanceRisk(String currentPerformanceRisk) {
            this.currentPerformanceRisk = currentPerformanceRisk;
        }

        @Override
        public final Builder currentPerformanceRisk(String currentPerformanceRisk) {
            this.currentPerformanceRisk = currentPerformanceRisk;
            return this;
        }

        @Override
        public final Builder currentPerformanceRisk(CurrentPerformanceRisk currentPerformanceRisk) {
            this.currentPerformanceRisk(currentPerformanceRisk == null ? null : currentPerformanceRisk.toString());
            return this;
        }

        public final ECSEffectiveRecommendationPreferences.Builder getEffectiveRecommendationPreferences() {
            return this.effectiveRecommendationPreferences != null ? this.effectiveRecommendationPreferences.toBuilder() : null;
        }

        public final void setEffectiveRecommendationPreferences(ECSEffectiveRecommendationPreferences.BuilderImpl effectiveRecommendationPreferences) {
            this.effectiveRecommendationPreferences = effectiveRecommendationPreferences != null ? effectiveRecommendationPreferences.build() : null;
        }

        @Override
        public final Builder effectiveRecommendationPreferences(ECSEffectiveRecommendationPreferences effectiveRecommendationPreferences) {
            this.effectiveRecommendationPreferences = effectiveRecommendationPreferences;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ECSServiceRecommendation build() {
            return new ECSServiceRecommendation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ECSServiceRecommendation> {
        public Builder serviceArn(String var1);

        public Builder accountId(String var1);

        public Builder currentServiceConfiguration(ServiceConfiguration var1);

        default public Builder currentServiceConfiguration(Consumer<ServiceConfiguration.Builder> currentServiceConfiguration) {
            return this.currentServiceConfiguration((ServiceConfiguration)((ServiceConfiguration.Builder)ServiceConfiguration.builder().applyMutation(currentServiceConfiguration)).build());
        }

        public Builder utilizationMetrics(Collection<ECSServiceUtilizationMetric> var1);

        public Builder utilizationMetrics(ECSServiceUtilizationMetric ... var1);

        public Builder utilizationMetrics(Consumer<ECSServiceUtilizationMetric.Builder> ... var1);

        public Builder lookbackPeriodInDays(Double var1);

        public Builder launchType(String var1);

        public Builder launchType(ECSServiceLaunchType var1);

        public Builder lastRefreshTimestamp(Instant var1);

        public Builder finding(String var1);

        public Builder finding(ECSServiceRecommendationFinding var1);

        public Builder findingReasonCodesWithStrings(Collection<String> var1);

        public Builder findingReasonCodesWithStrings(String ... var1);

        public Builder findingReasonCodes(Collection<ECSServiceRecommendationFindingReasonCode> var1);

        public Builder findingReasonCodes(ECSServiceRecommendationFindingReasonCode ... var1);

        public Builder serviceRecommendationOptions(Collection<ECSServiceRecommendationOption> var1);

        public Builder serviceRecommendationOptions(ECSServiceRecommendationOption ... var1);

        public Builder serviceRecommendationOptions(Consumer<ECSServiceRecommendationOption.Builder> ... var1);

        public Builder currentPerformanceRisk(String var1);

        public Builder currentPerformanceRisk(CurrentPerformanceRisk var1);

        public Builder effectiveRecommendationPreferences(ECSEffectiveRecommendationPreferences var1);

        default public Builder effectiveRecommendationPreferences(Consumer<ECSEffectiveRecommendationPreferences.Builder> effectiveRecommendationPreferences) {
            return this.effectiveRecommendationPreferences((ECSEffectiveRecommendationPreferences)((ECSEffectiveRecommendationPreferences.Builder)ECSEffectiveRecommendationPreferences.builder().applyMutation(effectiveRecommendationPreferences)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

