/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.computeoptimizer.model.IdleMetricName;
import software.amazon.awssdk.services.computeoptimizer.model.MetricStatistic;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IdleUtilizationMetric
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IdleUtilizationMetric> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(IdleUtilizationMetric.getter(IdleUtilizationMetric::nameAsString)).setter(IdleUtilizationMetric.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STATISTIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statistic").getter(IdleUtilizationMetric.getter(IdleUtilizationMetric::statisticAsString)).setter(IdleUtilizationMetric.setter(Builder::statistic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistic").build()}).build();
    private static final SdkField<Double> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("value").getter(IdleUtilizationMetric.getter(IdleUtilizationMetric::value)).setter(IdleUtilizationMetric.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATISTIC_FIELD, VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IdleUtilizationMetric.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String statistic;
    private final Double value;

    private IdleUtilizationMetric(BuilderImpl builder) {
        this.name = builder.name;
        this.statistic = builder.statistic;
        this.value = builder.value;
    }

    public final IdleMetricName name() {
        return IdleMetricName.fromValue(this.name);
    }

    public final String nameAsString() {
        return this.name;
    }

    public final MetricStatistic statistic() {
        return MetricStatistic.fromValue(this.statistic);
    }

    public final String statisticAsString() {
        return this.statistic;
    }

    public final Double value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statisticAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdleUtilizationMetric)) {
            return false;
        }
        IdleUtilizationMetric other = (IdleUtilizationMetric)obj;
        return Objects.equals(this.nameAsString(), other.nameAsString()) && Objects.equals(this.statisticAsString(), other.statisticAsString()) && Objects.equals(this.value(), other.value());
    }

    public final String toString() {
        return ToString.builder((String)"IdleUtilizationMetric").add("Name", (Object)this.nameAsString()).add("Statistic", (Object)this.statisticAsString()).add("Value", (Object)this.value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.nameAsString()));
            }
            case "statistic": {
                return Optional.ofNullable(clazz.cast(this.statisticAsString()));
            }
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("statistic", STATISTIC_FIELD);
        map.put("value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdleUtilizationMetric, T> g) {
        return obj -> g.apply((IdleUtilizationMetric)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String statistic;
        private Double value;

        private BuilderImpl() {
        }

        private BuilderImpl(IdleUtilizationMetric model) {
            this.name(model.name);
            this.statistic(model.statistic);
            this.value(model.value);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(IdleMetricName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final String getStatistic() {
            return this.statistic;
        }

        public final void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        @Override
        public final Builder statistic(String statistic) {
            this.statistic = statistic;
            return this;
        }

        @Override
        public final Builder statistic(MetricStatistic statistic) {
            this.statistic(statistic == null ? null : statistic.toString());
            return this;
        }

        public final Double getValue() {
            return this.value;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        @Override
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        public IdleUtilizationMetric build() {
            return new IdleUtilizationMetric(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IdleUtilizationMetric> {
        public Builder name(String var1);

        public Builder name(IdleMetricName var1);

        public Builder statistic(String var1);

        public Builder statistic(MetricStatistic var1);

        public Builder value(Double var1);
    }
}

