/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.Gpu;
import software.amazon.awssdk.services.computeoptimizer.model.GpusCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GpuInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GpuInfo> {
    private static final SdkField<List<Gpu>> GPUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("gpus").getter(GpuInfo.getter(GpuInfo::gpus)).setter(GpuInfo.setter(Builder::gpus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gpus").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Gpu::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GPUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("gpus", GPUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<Gpu> gpus;

    private GpuInfo(BuilderImpl builder) {
        this.gpus = builder.gpus;
    }

    public final boolean hasGpus() {
        return this.gpus != null && !(this.gpus instanceof SdkAutoConstructList);
    }

    public final List<Gpu> gpus() {
        return this.gpus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGpus() ? this.gpus() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GpuInfo)) {
            return false;
        }
        GpuInfo other = (GpuInfo)obj;
        return this.hasGpus() == other.hasGpus() && Objects.equals(this.gpus(), other.gpus());
    }

    public final String toString() {
        return ToString.builder((String)"GpuInfo").add("Gpus", this.hasGpus() ? this.gpus() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "gpus": {
                return Optional.ofNullable(clazz.cast(this.gpus()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GpuInfo, T> g) {
        return obj -> g.apply((GpuInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Gpu> gpus = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GpuInfo model) {
            this.gpus(model.gpus);
        }

        public final List<Gpu.Builder> getGpus() {
            List<Gpu.Builder> result = GpusCopier.copyToBuilder(this.gpus);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGpus(Collection<Gpu.BuilderImpl> gpus) {
            this.gpus = GpusCopier.copyFromBuilder(gpus);
        }

        @Override
        public final Builder gpus(Collection<Gpu> gpus) {
            this.gpus = GpusCopier.copy(gpus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gpus(Gpu ... gpus) {
            this.gpus(Arrays.asList(gpus));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gpus(Consumer<Gpu.Builder> ... gpus) {
            this.gpus(Stream.of(gpus).map(c -> (Gpu)((Gpu.Builder)Gpu.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public GpuInfo build() {
            return new GpuInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GpuInfo> {
        public Builder gpus(Collection<Gpu> var1);

        public Builder gpus(Gpu ... var1);

        public Builder gpus(Consumer<Gpu.Builder> ... var1);
    }
}

