/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.ComputeOptimizerResponse;
import software.amazon.awssdk.services.computeoptimizer.model.EffectivePreferredResource;
import software.amazon.awssdk.services.computeoptimizer.model.EffectivePreferredResourcesCopier;
import software.amazon.awssdk.services.computeoptimizer.model.EnhancedInfrastructureMetrics;
import software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricsPreference;
import software.amazon.awssdk.services.computeoptimizer.model.LookBackPeriodPreference;
import software.amazon.awssdk.services.computeoptimizer.model.UtilizationPreference;
import software.amazon.awssdk.services.computeoptimizer.model.UtilizationPreferencesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEffectiveRecommendationPreferencesResponse
extends ComputeOptimizerResponse
implements ToCopyableBuilder<Builder, GetEffectiveRecommendationPreferencesResponse> {
    private static final SdkField<String> ENHANCED_INFRASTRUCTURE_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("enhancedInfrastructureMetrics").getter(GetEffectiveRecommendationPreferencesResponse.getter(GetEffectiveRecommendationPreferencesResponse::enhancedInfrastructureMetricsAsString)).setter(GetEffectiveRecommendationPreferencesResponse.setter(Builder::enhancedInfrastructureMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enhancedInfrastructureMetrics").build()}).build();
    private static final SdkField<ExternalMetricsPreference> EXTERNAL_METRICS_PREFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("externalMetricsPreference").getter(GetEffectiveRecommendationPreferencesResponse.getter(GetEffectiveRecommendationPreferencesResponse::externalMetricsPreference)).setter(GetEffectiveRecommendationPreferencesResponse.setter(Builder::externalMetricsPreference)).constructor(ExternalMetricsPreference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalMetricsPreference").build()}).build();
    private static final SdkField<String> LOOK_BACK_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lookBackPeriod").getter(GetEffectiveRecommendationPreferencesResponse.getter(GetEffectiveRecommendationPreferencesResponse::lookBackPeriodAsString)).setter(GetEffectiveRecommendationPreferencesResponse.setter(Builder::lookBackPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lookBackPeriod").build()}).build();
    private static final SdkField<List<UtilizationPreference>> UTILIZATION_PREFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("utilizationPreferences").getter(GetEffectiveRecommendationPreferencesResponse.getter(GetEffectiveRecommendationPreferencesResponse::utilizationPreferences)).setter(GetEffectiveRecommendationPreferencesResponse.setter(Builder::utilizationPreferences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("utilizationPreferences").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UtilizationPreference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<EffectivePreferredResource>> PREFERRED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("preferredResources").getter(GetEffectiveRecommendationPreferencesResponse.getter(GetEffectiveRecommendationPreferencesResponse::preferredResources)).setter(GetEffectiveRecommendationPreferencesResponse.setter(Builder::preferredResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preferredResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EffectivePreferredResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENHANCED_INFRASTRUCTURE_METRICS_FIELD, EXTERNAL_METRICS_PREFERENCE_FIELD, LOOK_BACK_PERIOD_FIELD, UTILIZATION_PREFERENCES_FIELD, PREFERRED_RESOURCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("enhancedInfrastructureMetrics", ENHANCED_INFRASTRUCTURE_METRICS_FIELD);
            this.put("externalMetricsPreference", EXTERNAL_METRICS_PREFERENCE_FIELD);
            this.put("lookBackPeriod", LOOK_BACK_PERIOD_FIELD);
            this.put("utilizationPreferences", UTILIZATION_PREFERENCES_FIELD);
            this.put("preferredResources", PREFERRED_RESOURCES_FIELD);
        }
    });
    private final String enhancedInfrastructureMetrics;
    private final ExternalMetricsPreference externalMetricsPreference;
    private final String lookBackPeriod;
    private final List<UtilizationPreference> utilizationPreferences;
    private final List<EffectivePreferredResource> preferredResources;

    private GetEffectiveRecommendationPreferencesResponse(BuilderImpl builder) {
        super(builder);
        this.enhancedInfrastructureMetrics = builder.enhancedInfrastructureMetrics;
        this.externalMetricsPreference = builder.externalMetricsPreference;
        this.lookBackPeriod = builder.lookBackPeriod;
        this.utilizationPreferences = builder.utilizationPreferences;
        this.preferredResources = builder.preferredResources;
    }

    public final EnhancedInfrastructureMetrics enhancedInfrastructureMetrics() {
        return EnhancedInfrastructureMetrics.fromValue(this.enhancedInfrastructureMetrics);
    }

    public final String enhancedInfrastructureMetricsAsString() {
        return this.enhancedInfrastructureMetrics;
    }

    public final ExternalMetricsPreference externalMetricsPreference() {
        return this.externalMetricsPreference;
    }

    public final LookBackPeriodPreference lookBackPeriod() {
        return LookBackPeriodPreference.fromValue(this.lookBackPeriod);
    }

    public final String lookBackPeriodAsString() {
        return this.lookBackPeriod;
    }

    public final boolean hasUtilizationPreferences() {
        return this.utilizationPreferences != null && !(this.utilizationPreferences instanceof SdkAutoConstructList);
    }

    public final List<UtilizationPreference> utilizationPreferences() {
        return this.utilizationPreferences;
    }

    public final boolean hasPreferredResources() {
        return this.preferredResources != null && !(this.preferredResources instanceof SdkAutoConstructList);
    }

    public final List<EffectivePreferredResource> preferredResources() {
        return this.preferredResources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.enhancedInfrastructureMetricsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalMetricsPreference());
        hashCode = 31 * hashCode + Objects.hashCode(this.lookBackPeriodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUtilizationPreferences() ? this.utilizationPreferences() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPreferredResources() ? this.preferredResources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEffectiveRecommendationPreferencesResponse)) {
            return false;
        }
        GetEffectiveRecommendationPreferencesResponse other = (GetEffectiveRecommendationPreferencesResponse)((Object)obj);
        return Objects.equals(this.enhancedInfrastructureMetricsAsString(), other.enhancedInfrastructureMetricsAsString()) && Objects.equals(this.externalMetricsPreference(), other.externalMetricsPreference()) && Objects.equals(this.lookBackPeriodAsString(), other.lookBackPeriodAsString()) && this.hasUtilizationPreferences() == other.hasUtilizationPreferences() && Objects.equals(this.utilizationPreferences(), other.utilizationPreferences()) && this.hasPreferredResources() == other.hasPreferredResources() && Objects.equals(this.preferredResources(), other.preferredResources());
    }

    public final String toString() {
        return ToString.builder((String)"GetEffectiveRecommendationPreferencesResponse").add("EnhancedInfrastructureMetrics", (Object)this.enhancedInfrastructureMetricsAsString()).add("ExternalMetricsPreference", (Object)this.externalMetricsPreference()).add("LookBackPeriod", (Object)this.lookBackPeriodAsString()).add("UtilizationPreferences", this.hasUtilizationPreferences() ? this.utilizationPreferences() : null).add("PreferredResources", this.hasPreferredResources() ? this.preferredResources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "enhancedInfrastructureMetrics": {
                return Optional.ofNullable(clazz.cast(this.enhancedInfrastructureMetricsAsString()));
            }
            case "externalMetricsPreference": {
                return Optional.ofNullable(clazz.cast(this.externalMetricsPreference()));
            }
            case "lookBackPeriod": {
                return Optional.ofNullable(clazz.cast(this.lookBackPeriodAsString()));
            }
            case "utilizationPreferences": {
                return Optional.ofNullable(clazz.cast(this.utilizationPreferences()));
            }
            case "preferredResources": {
                return Optional.ofNullable(clazz.cast(this.preferredResources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetEffectiveRecommendationPreferencesResponse, T> g) {
        return obj -> g.apply((GetEffectiveRecommendationPreferencesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComputeOptimizerResponse.BuilderImpl
    implements Builder {
        private String enhancedInfrastructureMetrics;
        private ExternalMetricsPreference externalMetricsPreference;
        private String lookBackPeriod;
        private List<UtilizationPreference> utilizationPreferences = DefaultSdkAutoConstructList.getInstance();
        private List<EffectivePreferredResource> preferredResources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetEffectiveRecommendationPreferencesResponse model) {
            super(model);
            this.enhancedInfrastructureMetrics(model.enhancedInfrastructureMetrics);
            this.externalMetricsPreference(model.externalMetricsPreference);
            this.lookBackPeriod(model.lookBackPeriod);
            this.utilizationPreferences(model.utilizationPreferences);
            this.preferredResources(model.preferredResources);
        }

        public final String getEnhancedInfrastructureMetrics() {
            return this.enhancedInfrastructureMetrics;
        }

        public final void setEnhancedInfrastructureMetrics(String enhancedInfrastructureMetrics) {
            this.enhancedInfrastructureMetrics = enhancedInfrastructureMetrics;
        }

        @Override
        public final Builder enhancedInfrastructureMetrics(String enhancedInfrastructureMetrics) {
            this.enhancedInfrastructureMetrics = enhancedInfrastructureMetrics;
            return this;
        }

        @Override
        public final Builder enhancedInfrastructureMetrics(EnhancedInfrastructureMetrics enhancedInfrastructureMetrics) {
            this.enhancedInfrastructureMetrics(enhancedInfrastructureMetrics == null ? null : enhancedInfrastructureMetrics.toString());
            return this;
        }

        public final ExternalMetricsPreference.Builder getExternalMetricsPreference() {
            return this.externalMetricsPreference != null ? this.externalMetricsPreference.toBuilder() : null;
        }

        public final void setExternalMetricsPreference(ExternalMetricsPreference.BuilderImpl externalMetricsPreference) {
            this.externalMetricsPreference = externalMetricsPreference != null ? externalMetricsPreference.build() : null;
        }

        @Override
        public final Builder externalMetricsPreference(ExternalMetricsPreference externalMetricsPreference) {
            this.externalMetricsPreference = externalMetricsPreference;
            return this;
        }

        public final String getLookBackPeriod() {
            return this.lookBackPeriod;
        }

        public final void setLookBackPeriod(String lookBackPeriod) {
            this.lookBackPeriod = lookBackPeriod;
        }

        @Override
        public final Builder lookBackPeriod(String lookBackPeriod) {
            this.lookBackPeriod = lookBackPeriod;
            return this;
        }

        @Override
        public final Builder lookBackPeriod(LookBackPeriodPreference lookBackPeriod) {
            this.lookBackPeriod(lookBackPeriod == null ? null : lookBackPeriod.toString());
            return this;
        }

        public final List<UtilizationPreference.Builder> getUtilizationPreferences() {
            List<UtilizationPreference.Builder> result = UtilizationPreferencesCopier.copyToBuilder(this.utilizationPreferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUtilizationPreferences(Collection<UtilizationPreference.BuilderImpl> utilizationPreferences) {
            this.utilizationPreferences = UtilizationPreferencesCopier.copyFromBuilder(utilizationPreferences);
        }

        @Override
        public final Builder utilizationPreferences(Collection<UtilizationPreference> utilizationPreferences) {
            this.utilizationPreferences = UtilizationPreferencesCopier.copy(utilizationPreferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utilizationPreferences(UtilizationPreference ... utilizationPreferences) {
            this.utilizationPreferences(Arrays.asList(utilizationPreferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utilizationPreferences(Consumer<UtilizationPreference.Builder> ... utilizationPreferences) {
            this.utilizationPreferences(Stream.of(utilizationPreferences).map(c -> (UtilizationPreference)((UtilizationPreference.Builder)UtilizationPreference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<EffectivePreferredResource.Builder> getPreferredResources() {
            List<EffectivePreferredResource.Builder> result = EffectivePreferredResourcesCopier.copyToBuilder(this.preferredResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPreferredResources(Collection<EffectivePreferredResource.BuilderImpl> preferredResources) {
            this.preferredResources = EffectivePreferredResourcesCopier.copyFromBuilder(preferredResources);
        }

        @Override
        public final Builder preferredResources(Collection<EffectivePreferredResource> preferredResources) {
            this.preferredResources = EffectivePreferredResourcesCopier.copy(preferredResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder preferredResources(EffectivePreferredResource ... preferredResources) {
            this.preferredResources(Arrays.asList(preferredResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder preferredResources(Consumer<EffectivePreferredResource.Builder> ... preferredResources) {
            this.preferredResources(Stream.of(preferredResources).map(c -> (EffectivePreferredResource)((EffectivePreferredResource.Builder)EffectivePreferredResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetEffectiveRecommendationPreferencesResponse build() {
            return new GetEffectiveRecommendationPreferencesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ComputeOptimizerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEffectiveRecommendationPreferencesResponse> {
        public Builder enhancedInfrastructureMetrics(String var1);

        public Builder enhancedInfrastructureMetrics(EnhancedInfrastructureMetrics var1);

        public Builder externalMetricsPreference(ExternalMetricsPreference var1);

        default public Builder externalMetricsPreference(Consumer<ExternalMetricsPreference.Builder> externalMetricsPreference) {
            return this.externalMetricsPreference((ExternalMetricsPreference)((ExternalMetricsPreference.Builder)ExternalMetricsPreference.builder().applyMutation(externalMetricsPreference)).build());
        }

        public Builder lookBackPeriod(String var1);

        public Builder lookBackPeriod(LookBackPeriodPreference var1);

        public Builder utilizationPreferences(Collection<UtilizationPreference> var1);

        public Builder utilizationPreferences(UtilizationPreference ... var1);

        public Builder utilizationPreferences(Consumer<UtilizationPreference.Builder> ... var1);

        public Builder preferredResources(Collection<EffectivePreferredResource> var1);

        public Builder preferredResources(EffectivePreferredResource ... var1);

        public Builder preferredResources(Consumer<EffectivePreferredResource.Builder> ... var1);
    }
}

