/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.RDSDatabaseProjectedMetric;
import software.amazon.awssdk.services.computeoptimizer.model.RDSDatabaseProjectedMetricsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RDSDatabaseRecommendedOptionProjectedMetric
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RDSDatabaseRecommendedOptionProjectedMetric> {
    private static final SdkField<String> RECOMMENDED_DB_INSTANCE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recommendedDBInstanceClass").getter(RDSDatabaseRecommendedOptionProjectedMetric.getter(RDSDatabaseRecommendedOptionProjectedMetric::recommendedDBInstanceClass)).setter(RDSDatabaseRecommendedOptionProjectedMetric.setter(Builder::recommendedDBInstanceClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendedDBInstanceClass").build()}).build();
    private static final SdkField<Integer> RANK_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("rank").getter(RDSDatabaseRecommendedOptionProjectedMetric.getter(RDSDatabaseRecommendedOptionProjectedMetric::rank)).setter(RDSDatabaseRecommendedOptionProjectedMetric.setter(Builder::rank)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rank").build()}).build();
    private static final SdkField<List<RDSDatabaseProjectedMetric>> PROJECTED_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("projectedMetrics").getter(RDSDatabaseRecommendedOptionProjectedMetric.getter(RDSDatabaseRecommendedOptionProjectedMetric::projectedMetrics)).setter(RDSDatabaseRecommendedOptionProjectedMetric.setter(Builder::projectedMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectedMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RDSDatabaseProjectedMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDED_DB_INSTANCE_CLASS_FIELD, RANK_FIELD, PROJECTED_METRICS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("recommendedDBInstanceClass", RECOMMENDED_DB_INSTANCE_CLASS_FIELD);
            this.put("rank", RANK_FIELD);
            this.put("projectedMetrics", PROJECTED_METRICS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String recommendedDBInstanceClass;
    private final Integer rank;
    private final List<RDSDatabaseProjectedMetric> projectedMetrics;

    private RDSDatabaseRecommendedOptionProjectedMetric(BuilderImpl builder) {
        this.recommendedDBInstanceClass = builder.recommendedDBInstanceClass;
        this.rank = builder.rank;
        this.projectedMetrics = builder.projectedMetrics;
    }

    public final String recommendedDBInstanceClass() {
        return this.recommendedDBInstanceClass;
    }

    public final Integer rank() {
        return this.rank;
    }

    public final boolean hasProjectedMetrics() {
        return this.projectedMetrics != null && !(this.projectedMetrics instanceof SdkAutoConstructList);
    }

    public final List<RDSDatabaseProjectedMetric> projectedMetrics() {
        return this.projectedMetrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendedDBInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.rank());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProjectedMetrics() ? this.projectedMetrics() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RDSDatabaseRecommendedOptionProjectedMetric)) {
            return false;
        }
        RDSDatabaseRecommendedOptionProjectedMetric other = (RDSDatabaseRecommendedOptionProjectedMetric)obj;
        return Objects.equals(this.recommendedDBInstanceClass(), other.recommendedDBInstanceClass()) && Objects.equals(this.rank(), other.rank()) && this.hasProjectedMetrics() == other.hasProjectedMetrics() && Objects.equals(this.projectedMetrics(), other.projectedMetrics());
    }

    public final String toString() {
        return ToString.builder((String)"RDSDatabaseRecommendedOptionProjectedMetric").add("RecommendedDBInstanceClass", (Object)this.recommendedDBInstanceClass()).add("Rank", (Object)this.rank()).add("ProjectedMetrics", this.hasProjectedMetrics() ? this.projectedMetrics() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "recommendedDBInstanceClass": {
                return Optional.ofNullable(clazz.cast(this.recommendedDBInstanceClass()));
            }
            case "rank": {
                return Optional.ofNullable(clazz.cast(this.rank()));
            }
            case "projectedMetrics": {
                return Optional.ofNullable(clazz.cast(this.projectedMetrics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RDSDatabaseRecommendedOptionProjectedMetric, T> g) {
        return obj -> g.apply((RDSDatabaseRecommendedOptionProjectedMetric)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String recommendedDBInstanceClass;
        private Integer rank;
        private List<RDSDatabaseProjectedMetric> projectedMetrics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RDSDatabaseRecommendedOptionProjectedMetric model) {
            this.recommendedDBInstanceClass(model.recommendedDBInstanceClass);
            this.rank(model.rank);
            this.projectedMetrics(model.projectedMetrics);
        }

        public final String getRecommendedDBInstanceClass() {
            return this.recommendedDBInstanceClass;
        }

        public final void setRecommendedDBInstanceClass(String recommendedDBInstanceClass) {
            this.recommendedDBInstanceClass = recommendedDBInstanceClass;
        }

        @Override
        public final Builder recommendedDBInstanceClass(String recommendedDBInstanceClass) {
            this.recommendedDBInstanceClass = recommendedDBInstanceClass;
            return this;
        }

        public final Integer getRank() {
            return this.rank;
        }

        public final void setRank(Integer rank) {
            this.rank = rank;
        }

        @Override
        public final Builder rank(Integer rank) {
            this.rank = rank;
            return this;
        }

        public final List<RDSDatabaseProjectedMetric.Builder> getProjectedMetrics() {
            List<RDSDatabaseProjectedMetric.Builder> result = RDSDatabaseProjectedMetricsCopier.copyToBuilder(this.projectedMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProjectedMetrics(Collection<RDSDatabaseProjectedMetric.BuilderImpl> projectedMetrics) {
            this.projectedMetrics = RDSDatabaseProjectedMetricsCopier.copyFromBuilder(projectedMetrics);
        }

        @Override
        public final Builder projectedMetrics(Collection<RDSDatabaseProjectedMetric> projectedMetrics) {
            this.projectedMetrics = RDSDatabaseProjectedMetricsCopier.copy(projectedMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectedMetrics(RDSDatabaseProjectedMetric ... projectedMetrics) {
            this.projectedMetrics(Arrays.asList(projectedMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectedMetrics(Consumer<RDSDatabaseProjectedMetric.Builder> ... projectedMetrics) {
            this.projectedMetrics(Stream.of(projectedMetrics).map(c -> (RDSDatabaseProjectedMetric)((RDSDatabaseProjectedMetric.Builder)RDSDatabaseProjectedMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RDSDatabaseRecommendedOptionProjectedMetric build() {
            return new RDSDatabaseRecommendedOptionProjectedMetric(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RDSDatabaseRecommendedOptionProjectedMetric> {
        public Builder recommendedDBInstanceClass(String var1);

        public Builder rank(Integer var1);

        public Builder projectedMetrics(Collection<RDSDatabaseProjectedMetric> var1);

        public Builder projectedMetrics(RDSDatabaseProjectedMetric ... var1);

        public Builder projectedMetrics(Consumer<RDSDatabaseProjectedMetric.Builder> ... var1);
    }
}

