/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RDSDBMetricName {
    CPU("CPU"),
    MEMORY("Memory"),
    EBS_VOLUME_STORAGE_SPACE_UTILIZATION("EBSVolumeStorageSpaceUtilization"),
    NETWORK_RECEIVE_THROUGHPUT("NetworkReceiveThroughput"),
    NETWORK_TRANSMIT_THROUGHPUT("NetworkTransmitThroughput"),
    EBS_VOLUME_READ_IOPS("EBSVolumeReadIOPS"),
    EBS_VOLUME_WRITE_IOPS("EBSVolumeWriteIOPS"),
    EBS_VOLUME_READ_THROUGHPUT("EBSVolumeReadThroughput"),
    EBS_VOLUME_WRITE_THROUGHPUT("EBSVolumeWriteThroughput"),
    DATABASE_CONNECTIONS("DatabaseConnections"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RDSDBMetricName> VALUE_MAP;
    private final String value;

    private RDSDBMetricName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RDSDBMetricName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RDSDBMetricName> knownValues() {
        EnumSet<RDSDBMetricName> knownValues = EnumSet.allOf(RDSDBMetricName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RDSDBMetricName.class, RDSDBMetricName::toString);
    }
}

