/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.AutoScalingGroupConfiguration;
import software.amazon.awssdk.services.computeoptimizer.model.AutoScalingGroupSavingsOpportunityAfterDiscounts;
import software.amazon.awssdk.services.computeoptimizer.model.GpuInfo;
import software.amazon.awssdk.services.computeoptimizer.model.MigrationEffort;
import software.amazon.awssdk.services.computeoptimizer.model.ProjectedUtilizationMetricsCopier;
import software.amazon.awssdk.services.computeoptimizer.model.SavingsOpportunity;
import software.amazon.awssdk.services.computeoptimizer.model.UtilizationMetric;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoScalingGroupRecommendationOption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoScalingGroupRecommendationOption> {
    private static final SdkField<AutoScalingGroupConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(AutoScalingGroupRecommendationOption.getter(AutoScalingGroupRecommendationOption::configuration)).setter(AutoScalingGroupRecommendationOption.setter(Builder::configuration)).constructor(AutoScalingGroupConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<GpuInfo> INSTANCE_GPU_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("instanceGpuInfo").getter(AutoScalingGroupRecommendationOption.getter(AutoScalingGroupRecommendationOption::instanceGpuInfo)).setter(AutoScalingGroupRecommendationOption.setter(Builder::instanceGpuInfo)).constructor(GpuInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceGpuInfo").build()}).build();
    private static final SdkField<List<UtilizationMetric>> PROJECTED_UTILIZATION_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("projectedUtilizationMetrics").getter(AutoScalingGroupRecommendationOption.getter(AutoScalingGroupRecommendationOption::projectedUtilizationMetrics)).setter(AutoScalingGroupRecommendationOption.setter(Builder::projectedUtilizationMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectedUtilizationMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UtilizationMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> PERFORMANCE_RISK_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("performanceRisk").getter(AutoScalingGroupRecommendationOption.getter(AutoScalingGroupRecommendationOption::performanceRisk)).setter(AutoScalingGroupRecommendationOption.setter(Builder::performanceRisk)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("performanceRisk").build()}).build();
    private static final SdkField<Integer> RANK_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("rank").getter(AutoScalingGroupRecommendationOption.getter(AutoScalingGroupRecommendationOption::rank)).setter(AutoScalingGroupRecommendationOption.setter(Builder::rank)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rank").build()}).build();
    private static final SdkField<SavingsOpportunity> SAVINGS_OPPORTUNITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("savingsOpportunity").getter(AutoScalingGroupRecommendationOption.getter(AutoScalingGroupRecommendationOption::savingsOpportunity)).setter(AutoScalingGroupRecommendationOption.setter(Builder::savingsOpportunity)).constructor(SavingsOpportunity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsOpportunity").build()}).build();
    private static final SdkField<AutoScalingGroupSavingsOpportunityAfterDiscounts> SAVINGS_OPPORTUNITY_AFTER_DISCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("savingsOpportunityAfterDiscounts").getter(AutoScalingGroupRecommendationOption.getter(AutoScalingGroupRecommendationOption::savingsOpportunityAfterDiscounts)).setter(AutoScalingGroupRecommendationOption.setter(Builder::savingsOpportunityAfterDiscounts)).constructor(AutoScalingGroupSavingsOpportunityAfterDiscounts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsOpportunityAfterDiscounts").build()}).build();
    private static final SdkField<String> MIGRATION_EFFORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("migrationEffort").getter(AutoScalingGroupRecommendationOption.getter(AutoScalingGroupRecommendationOption::migrationEffortAsString)).setter(AutoScalingGroupRecommendationOption.setter(Builder::migrationEffort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("migrationEffort").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD, INSTANCE_GPU_INFO_FIELD, PROJECTED_UTILIZATION_METRICS_FIELD, PERFORMANCE_RISK_FIELD, RANK_FIELD, SAVINGS_OPPORTUNITY_FIELD, SAVINGS_OPPORTUNITY_AFTER_DISCOUNTS_FIELD, MIGRATION_EFFORT_FIELD));
    private static final long serialVersionUID = 1L;
    private final AutoScalingGroupConfiguration configuration;
    private final GpuInfo instanceGpuInfo;
    private final List<UtilizationMetric> projectedUtilizationMetrics;
    private final Double performanceRisk;
    private final Integer rank;
    private final SavingsOpportunity savingsOpportunity;
    private final AutoScalingGroupSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts;
    private final String migrationEffort;

    private AutoScalingGroupRecommendationOption(BuilderImpl builder) {
        this.configuration = builder.configuration;
        this.instanceGpuInfo = builder.instanceGpuInfo;
        this.projectedUtilizationMetrics = builder.projectedUtilizationMetrics;
        this.performanceRisk = builder.performanceRisk;
        this.rank = builder.rank;
        this.savingsOpportunity = builder.savingsOpportunity;
        this.savingsOpportunityAfterDiscounts = builder.savingsOpportunityAfterDiscounts;
        this.migrationEffort = builder.migrationEffort;
    }

    public final AutoScalingGroupConfiguration configuration() {
        return this.configuration;
    }

    public final GpuInfo instanceGpuInfo() {
        return this.instanceGpuInfo;
    }

    public final boolean hasProjectedUtilizationMetrics() {
        return this.projectedUtilizationMetrics != null && !(this.projectedUtilizationMetrics instanceof SdkAutoConstructList);
    }

    public final List<UtilizationMetric> projectedUtilizationMetrics() {
        return this.projectedUtilizationMetrics;
    }

    public final Double performanceRisk() {
        return this.performanceRisk;
    }

    public final Integer rank() {
        return this.rank;
    }

    public final SavingsOpportunity savingsOpportunity() {
        return this.savingsOpportunity;
    }

    public final AutoScalingGroupSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts() {
        return this.savingsOpportunityAfterDiscounts;
    }

    public final MigrationEffort migrationEffort() {
        return MigrationEffort.fromValue(this.migrationEffort);
    }

    public final String migrationEffortAsString() {
        return this.migrationEffort;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceGpuInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProjectedUtilizationMetrics() ? this.projectedUtilizationMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.performanceRisk());
        hashCode = 31 * hashCode + Objects.hashCode(this.rank());
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsOpportunity());
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsOpportunityAfterDiscounts());
        hashCode = 31 * hashCode + Objects.hashCode(this.migrationEffortAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingGroupRecommendationOption)) {
            return false;
        }
        AutoScalingGroupRecommendationOption other = (AutoScalingGroupRecommendationOption)obj;
        return Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.instanceGpuInfo(), other.instanceGpuInfo()) && this.hasProjectedUtilizationMetrics() == other.hasProjectedUtilizationMetrics() && Objects.equals(this.projectedUtilizationMetrics(), other.projectedUtilizationMetrics()) && Objects.equals(this.performanceRisk(), other.performanceRisk()) && Objects.equals(this.rank(), other.rank()) && Objects.equals(this.savingsOpportunity(), other.savingsOpportunity()) && Objects.equals(this.savingsOpportunityAfterDiscounts(), other.savingsOpportunityAfterDiscounts()) && Objects.equals(this.migrationEffortAsString(), other.migrationEffortAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AutoScalingGroupRecommendationOption").add("Configuration", (Object)this.configuration()).add("InstanceGpuInfo", (Object)this.instanceGpuInfo()).add("ProjectedUtilizationMetrics", this.hasProjectedUtilizationMetrics() ? this.projectedUtilizationMetrics() : null).add("PerformanceRisk", (Object)this.performanceRisk()).add("Rank", (Object)this.rank()).add("SavingsOpportunity", (Object)this.savingsOpportunity()).add("SavingsOpportunityAfterDiscounts", (Object)this.savingsOpportunityAfterDiscounts()).add("MigrationEffort", (Object)this.migrationEffortAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "instanceGpuInfo": {
                return Optional.ofNullable(clazz.cast(this.instanceGpuInfo()));
            }
            case "projectedUtilizationMetrics": {
                return Optional.ofNullable(clazz.cast(this.projectedUtilizationMetrics()));
            }
            case "performanceRisk": {
                return Optional.ofNullable(clazz.cast(this.performanceRisk()));
            }
            case "rank": {
                return Optional.ofNullable(clazz.cast(this.rank()));
            }
            case "savingsOpportunity": {
                return Optional.ofNullable(clazz.cast(this.savingsOpportunity()));
            }
            case "savingsOpportunityAfterDiscounts": {
                return Optional.ofNullable(clazz.cast(this.savingsOpportunityAfterDiscounts()));
            }
            case "migrationEffort": {
                return Optional.ofNullable(clazz.cast(this.migrationEffortAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingGroupRecommendationOption, T> g) {
        return obj -> g.apply((AutoScalingGroupRecommendationOption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AutoScalingGroupConfiguration configuration;
        private GpuInfo instanceGpuInfo;
        private List<UtilizationMetric> projectedUtilizationMetrics = DefaultSdkAutoConstructList.getInstance();
        private Double performanceRisk;
        private Integer rank;
        private SavingsOpportunity savingsOpportunity;
        private AutoScalingGroupSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts;
        private String migrationEffort;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingGroupRecommendationOption model) {
            this.configuration(model.configuration);
            this.instanceGpuInfo(model.instanceGpuInfo);
            this.projectedUtilizationMetrics(model.projectedUtilizationMetrics);
            this.performanceRisk(model.performanceRisk);
            this.rank(model.rank);
            this.savingsOpportunity(model.savingsOpportunity);
            this.savingsOpportunityAfterDiscounts(model.savingsOpportunityAfterDiscounts);
            this.migrationEffort(model.migrationEffort);
        }

        public final AutoScalingGroupConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(AutoScalingGroupConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(AutoScalingGroupConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final GpuInfo.Builder getInstanceGpuInfo() {
            return this.instanceGpuInfo != null ? this.instanceGpuInfo.toBuilder() : null;
        }

        public final void setInstanceGpuInfo(GpuInfo.BuilderImpl instanceGpuInfo) {
            this.instanceGpuInfo = instanceGpuInfo != null ? instanceGpuInfo.build() : null;
        }

        @Override
        public final Builder instanceGpuInfo(GpuInfo instanceGpuInfo) {
            this.instanceGpuInfo = instanceGpuInfo;
            return this;
        }

        public final List<UtilizationMetric.Builder> getProjectedUtilizationMetrics() {
            List<UtilizationMetric.Builder> result = ProjectedUtilizationMetricsCopier.copyToBuilder(this.projectedUtilizationMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProjectedUtilizationMetrics(Collection<UtilizationMetric.BuilderImpl> projectedUtilizationMetrics) {
            this.projectedUtilizationMetrics = ProjectedUtilizationMetricsCopier.copyFromBuilder(projectedUtilizationMetrics);
        }

        @Override
        public final Builder projectedUtilizationMetrics(Collection<UtilizationMetric> projectedUtilizationMetrics) {
            this.projectedUtilizationMetrics = ProjectedUtilizationMetricsCopier.copy(projectedUtilizationMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectedUtilizationMetrics(UtilizationMetric ... projectedUtilizationMetrics) {
            this.projectedUtilizationMetrics(Arrays.asList(projectedUtilizationMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectedUtilizationMetrics(Consumer<UtilizationMetric.Builder> ... projectedUtilizationMetrics) {
            this.projectedUtilizationMetrics(Stream.of(projectedUtilizationMetrics).map(c -> (UtilizationMetric)((UtilizationMetric.Builder)UtilizationMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Double getPerformanceRisk() {
            return this.performanceRisk;
        }

        public final void setPerformanceRisk(Double performanceRisk) {
            this.performanceRisk = performanceRisk;
        }

        @Override
        public final Builder performanceRisk(Double performanceRisk) {
            this.performanceRisk = performanceRisk;
            return this;
        }

        public final Integer getRank() {
            return this.rank;
        }

        public final void setRank(Integer rank) {
            this.rank = rank;
        }

        @Override
        public final Builder rank(Integer rank) {
            this.rank = rank;
            return this;
        }

        public final SavingsOpportunity.Builder getSavingsOpportunity() {
            return this.savingsOpportunity != null ? this.savingsOpportunity.toBuilder() : null;
        }

        public final void setSavingsOpportunity(SavingsOpportunity.BuilderImpl savingsOpportunity) {
            this.savingsOpportunity = savingsOpportunity != null ? savingsOpportunity.build() : null;
        }

        @Override
        public final Builder savingsOpportunity(SavingsOpportunity savingsOpportunity) {
            this.savingsOpportunity = savingsOpportunity;
            return this;
        }

        public final AutoScalingGroupSavingsOpportunityAfterDiscounts.Builder getSavingsOpportunityAfterDiscounts() {
            return this.savingsOpportunityAfterDiscounts != null ? this.savingsOpportunityAfterDiscounts.toBuilder() : null;
        }

        public final void setSavingsOpportunityAfterDiscounts(AutoScalingGroupSavingsOpportunityAfterDiscounts.BuilderImpl savingsOpportunityAfterDiscounts) {
            this.savingsOpportunityAfterDiscounts = savingsOpportunityAfterDiscounts != null ? savingsOpportunityAfterDiscounts.build() : null;
        }

        @Override
        public final Builder savingsOpportunityAfterDiscounts(AutoScalingGroupSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts) {
            this.savingsOpportunityAfterDiscounts = savingsOpportunityAfterDiscounts;
            return this;
        }

        public final String getMigrationEffort() {
            return this.migrationEffort;
        }

        public final void setMigrationEffort(String migrationEffort) {
            this.migrationEffort = migrationEffort;
        }

        @Override
        public final Builder migrationEffort(String migrationEffort) {
            this.migrationEffort = migrationEffort;
            return this;
        }

        @Override
        public final Builder migrationEffort(MigrationEffort migrationEffort) {
            this.migrationEffort(migrationEffort == null ? null : migrationEffort.toString());
            return this;
        }

        public AutoScalingGroupRecommendationOption build() {
            return new AutoScalingGroupRecommendationOption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoScalingGroupRecommendationOption> {
        public Builder configuration(AutoScalingGroupConfiguration var1);

        default public Builder configuration(Consumer<AutoScalingGroupConfiguration.Builder> configuration) {
            return this.configuration((AutoScalingGroupConfiguration)((AutoScalingGroupConfiguration.Builder)AutoScalingGroupConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder instanceGpuInfo(GpuInfo var1);

        default public Builder instanceGpuInfo(Consumer<GpuInfo.Builder> instanceGpuInfo) {
            return this.instanceGpuInfo((GpuInfo)((GpuInfo.Builder)GpuInfo.builder().applyMutation(instanceGpuInfo)).build());
        }

        public Builder projectedUtilizationMetrics(Collection<UtilizationMetric> var1);

        public Builder projectedUtilizationMetrics(UtilizationMetric ... var1);

        public Builder projectedUtilizationMetrics(Consumer<UtilizationMetric.Builder> ... var1);

        public Builder performanceRisk(Double var1);

        public Builder rank(Integer var1);

        public Builder savingsOpportunity(SavingsOpportunity var1);

        default public Builder savingsOpportunity(Consumer<SavingsOpportunity.Builder> savingsOpportunity) {
            return this.savingsOpportunity((SavingsOpportunity)((SavingsOpportunity.Builder)SavingsOpportunity.builder().applyMutation(savingsOpportunity)).build());
        }

        public Builder savingsOpportunityAfterDiscounts(AutoScalingGroupSavingsOpportunityAfterDiscounts var1);

        default public Builder savingsOpportunityAfterDiscounts(Consumer<AutoScalingGroupSavingsOpportunityAfterDiscounts.Builder> savingsOpportunityAfterDiscounts) {
            return this.savingsOpportunityAfterDiscounts((AutoScalingGroupSavingsOpportunityAfterDiscounts)((AutoScalingGroupSavingsOpportunityAfterDiscounts.Builder)AutoScalingGroupSavingsOpportunityAfterDiscounts.builder().applyMutation(savingsOpportunityAfterDiscounts)).build());
        }

        public Builder migrationEffort(String var1);

        public Builder migrationEffort(MigrationEffort var1);
    }
}

