/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ECSServiceMetricName {
    CPU("Cpu"),
    MEMORY("Memory"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ECSServiceMetricName> VALUE_MAP;
    private final String value;

    private ECSServiceMetricName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ECSServiceMetricName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ECSServiceMetricName> knownValues() {
        EnumSet<ECSServiceMetricName> knownValues = EnumSet.allOf(ECSServiceMetricName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ECSServiceMetricName.class, ECSServiceMetricName::toString);
    }
}

