/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.computeoptimizer.ComputeOptimizerClient;
import software.amazon.awssdk.services.computeoptimizer.ComputeOptimizerClientBuilder;
import software.amazon.awssdk.services.computeoptimizer.ComputeOptimizerServiceClientConfiguration;
import software.amazon.awssdk.services.computeoptimizer.DefaultComputeOptimizerBaseClientBuilder;
import software.amazon.awssdk.services.computeoptimizer.DefaultComputeOptimizerClient;
import software.amazon.awssdk.services.computeoptimizer.endpoints.ComputeOptimizerEndpointProvider;

@SdkInternalApi
final class DefaultComputeOptimizerClientBuilder
extends DefaultComputeOptimizerBaseClientBuilder<ComputeOptimizerClientBuilder, ComputeOptimizerClient>
implements ComputeOptimizerClientBuilder {
    DefaultComputeOptimizerClientBuilder() {
    }

    @Override
    public DefaultComputeOptimizerClientBuilder endpointProvider(ComputeOptimizerEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ComputeOptimizerClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultComputeOptimizerClientBuilder.validateClientOptions(clientConfiguration);
        ComputeOptimizerServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultComputeOptimizerClient client = new DefaultComputeOptimizerClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ComputeOptimizerServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ComputeOptimizerServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

