/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon ECS service configurations used for recommendations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceConfiguration.Builder, ServiceConfiguration> {
    private static final SdkField<Integer> MEMORY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("memory").getter(getter(ServiceConfiguration::memory)).setter(setter(Builder::memory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memory").build()).build();

    private static final SdkField<Integer> CPU_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("cpu")
            .getter(getter(ServiceConfiguration::cpu)).setter(setter(Builder::cpu))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpu").build()).build();

    private static final SdkField<List<ContainerConfiguration>> CONTAINER_CONFIGURATIONS_FIELD = SdkField
            .<List<ContainerConfiguration>> builder(MarshallingType.LIST)
            .memberName("containerConfigurations")
            .getter(getter(ServiceConfiguration::containerConfigurations))
            .setter(setter(Builder::containerConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContainerConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContainerConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> AUTO_SCALING_CONFIGURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("autoScalingConfiguration").getter(getter(ServiceConfiguration::autoScalingConfigurationAsString))
            .setter(setter(Builder::autoScalingConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingConfiguration").build())
            .build();

    private static final SdkField<String> TASK_DEFINITION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskDefinitionArn").getter(getter(ServiceConfiguration::taskDefinitionArn))
            .setter(setter(Builder::taskDefinitionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskDefinitionArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMORY_FIELD, CPU_FIELD,
            CONTAINER_CONFIGURATIONS_FIELD, AUTO_SCALING_CONFIGURATION_FIELD, TASK_DEFINITION_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer memory;

    private final Integer cpu;

    private final List<ContainerConfiguration> containerConfigurations;

    private final String autoScalingConfiguration;

    private final String taskDefinitionArn;

    private ServiceConfiguration(BuilderImpl builder) {
        this.memory = builder.memory;
        this.cpu = builder.cpu;
        this.containerConfigurations = builder.containerConfigurations;
        this.autoScalingConfiguration = builder.autoScalingConfiguration;
        this.taskDefinitionArn = builder.taskDefinitionArn;
    }

    /**
     * <p>
     * The amount of memory used by the tasks in the Amazon ECS service.
     * </p>
     * 
     * @return The amount of memory used by the tasks in the Amazon ECS service.
     */
    public final Integer memory() {
        return memory;
    }

    /**
     * <p>
     * The number of CPU units used by the tasks in the Amazon ECS service.
     * </p>
     * 
     * @return The number of CPU units used by the tasks in the Amazon ECS service.
     */
    public final Integer cpu() {
        return cpu;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContainerConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasContainerConfigurations() {
        return containerConfigurations != null && !(containerConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The container configurations within a task of an Amazon ECS service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContainerConfigurations} method.
     * </p>
     * 
     * @return The container configurations within a task of an Amazon ECS service.
     */
    public final List<ContainerConfiguration> containerConfigurations() {
        return containerConfigurations;
    }

    /**
     * <p>
     * Describes the Auto Scaling configuration methods for an Amazon ECS service. This affects the generated
     * recommendations. For example, if Auto Scaling is configured on a service’s CPU, then Compute Optimizer doesn’t
     * generate CPU size recommendations.
     * </p>
     * <p>
     * The Auto Scaling configuration methods include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TARGET_TRACKING_SCALING_CPU</code> — If the Amazon ECS service is configured to use target scaling on CPU,
     * Compute Optimizer doesn't generate CPU recommendations.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TARGET_TRACKING_SCALING_MEMORY</code> — If the Amazon ECS service is configured to use target scaling on
     * memory, Compute Optimizer doesn't generate memory recommendations.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about step scaling and target scaling, see <a href=
     * "https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html"
     * > Step scaling policies for Application Auto Scaling</a> and <a href=
     * "https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html">
     * Target tracking scaling policies for Application Auto Scaling</a> in the <i>Application Auto Scaling User
     * Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autoScalingConfiguration} will return {@link AutoScalingConfiguration#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #autoScalingConfigurationAsString}.
     * </p>
     * 
     * @return Describes the Auto Scaling configuration methods for an Amazon ECS service. This affects the generated
     *         recommendations. For example, if Auto Scaling is configured on a service’s CPU, then Compute Optimizer
     *         doesn’t generate CPU size recommendations. </p>
     *         <p>
     *         The Auto Scaling configuration methods include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TARGET_TRACKING_SCALING_CPU</code> — If the Amazon ECS service is configured to use target scaling
     *         on CPU, Compute Optimizer doesn't generate CPU recommendations.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TARGET_TRACKING_SCALING_MEMORY</code> — If the Amazon ECS service is configured to use target
     *         scaling on memory, Compute Optimizer doesn't generate memory recommendations.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about step scaling and target scaling, see <a href=
     *         "https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html"
     *         > Step scaling policies for Application Auto Scaling</a> and <a href=
     *         "https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html"
     *         > Target tracking scaling policies for Application Auto Scaling</a> in the <i>Application Auto Scaling
     *         User Guide</i>.
     * @see AutoScalingConfiguration
     */
    public final AutoScalingConfiguration autoScalingConfiguration() {
        return AutoScalingConfiguration.fromValue(autoScalingConfiguration);
    }

    /**
     * <p>
     * Describes the Auto Scaling configuration methods for an Amazon ECS service. This affects the generated
     * recommendations. For example, if Auto Scaling is configured on a service’s CPU, then Compute Optimizer doesn’t
     * generate CPU size recommendations.
     * </p>
     * <p>
     * The Auto Scaling configuration methods include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TARGET_TRACKING_SCALING_CPU</code> — If the Amazon ECS service is configured to use target scaling on CPU,
     * Compute Optimizer doesn't generate CPU recommendations.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TARGET_TRACKING_SCALING_MEMORY</code> — If the Amazon ECS service is configured to use target scaling on
     * memory, Compute Optimizer doesn't generate memory recommendations.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about step scaling and target scaling, see <a href=
     * "https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html"
     * > Step scaling policies for Application Auto Scaling</a> and <a href=
     * "https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html">
     * Target tracking scaling policies for Application Auto Scaling</a> in the <i>Application Auto Scaling User
     * Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autoScalingConfiguration} will return {@link AutoScalingConfiguration#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #autoScalingConfigurationAsString}.
     * </p>
     * 
     * @return Describes the Auto Scaling configuration methods for an Amazon ECS service. This affects the generated
     *         recommendations. For example, if Auto Scaling is configured on a service’s CPU, then Compute Optimizer
     *         doesn’t generate CPU size recommendations. </p>
     *         <p>
     *         The Auto Scaling configuration methods include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TARGET_TRACKING_SCALING_CPU</code> — If the Amazon ECS service is configured to use target scaling
     *         on CPU, Compute Optimizer doesn't generate CPU recommendations.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TARGET_TRACKING_SCALING_MEMORY</code> — If the Amazon ECS service is configured to use target
     *         scaling on memory, Compute Optimizer doesn't generate memory recommendations.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about step scaling and target scaling, see <a href=
     *         "https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html"
     *         > Step scaling policies for Application Auto Scaling</a> and <a href=
     *         "https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html"
     *         > Target tracking scaling policies for Application Auto Scaling</a> in the <i>Application Auto Scaling
     *         User Guide</i>.
     * @see AutoScalingConfiguration
     */
    public final String autoScalingConfigurationAsString() {
        return autoScalingConfiguration;
    }

    /**
     * <p>
     * The task definition ARN used by the tasks in the Amazon ECS service.
     * </p>
     * 
     * @return The task definition ARN used by the tasks in the Amazon ECS service.
     */
    public final String taskDefinitionArn() {
        return taskDefinitionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(memory());
        hashCode = 31 * hashCode + Objects.hashCode(cpu());
        hashCode = 31 * hashCode + Objects.hashCode(hasContainerConfigurations() ? containerConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingConfigurationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(taskDefinitionArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceConfiguration)) {
            return false;
        }
        ServiceConfiguration other = (ServiceConfiguration) obj;
        return Objects.equals(memory(), other.memory()) && Objects.equals(cpu(), other.cpu())
                && hasContainerConfigurations() == other.hasContainerConfigurations()
                && Objects.equals(containerConfigurations(), other.containerConfigurations())
                && Objects.equals(autoScalingConfigurationAsString(), other.autoScalingConfigurationAsString())
                && Objects.equals(taskDefinitionArn(), other.taskDefinitionArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceConfiguration").add("Memory", memory()).add("Cpu", cpu())
                .add("ContainerConfigurations", hasContainerConfigurations() ? containerConfigurations() : null)
                .add("AutoScalingConfiguration", autoScalingConfigurationAsString())
                .add("TaskDefinitionArn", taskDefinitionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "memory":
            return Optional.ofNullable(clazz.cast(memory()));
        case "cpu":
            return Optional.ofNullable(clazz.cast(cpu()));
        case "containerConfigurations":
            return Optional.ofNullable(clazz.cast(containerConfigurations()));
        case "autoScalingConfiguration":
            return Optional.ofNullable(clazz.cast(autoScalingConfigurationAsString()));
        case "taskDefinitionArn":
            return Optional.ofNullable(clazz.cast(taskDefinitionArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceConfiguration, T> g) {
        return obj -> g.apply((ServiceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceConfiguration> {
        /**
         * <p>
         * The amount of memory used by the tasks in the Amazon ECS service.
         * </p>
         * 
         * @param memory
         *        The amount of memory used by the tasks in the Amazon ECS service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memory(Integer memory);

        /**
         * <p>
         * The number of CPU units used by the tasks in the Amazon ECS service.
         * </p>
         * 
         * @param cpu
         *        The number of CPU units used by the tasks in the Amazon ECS service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpu(Integer cpu);

        /**
         * <p>
         * The container configurations within a task of an Amazon ECS service.
         * </p>
         * 
         * @param containerConfigurations
         *        The container configurations within a task of an Amazon ECS service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerConfigurations(Collection<ContainerConfiguration> containerConfigurations);

        /**
         * <p>
         * The container configurations within a task of an Amazon ECS service.
         * </p>
         * 
         * @param containerConfigurations
         *        The container configurations within a task of an Amazon ECS service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerConfigurations(ContainerConfiguration... containerConfigurations);

        /**
         * <p>
         * The container configurations within a task of an Amazon ECS service.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.computeoptimizer.model.ContainerConfiguration.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.computeoptimizer.model.ContainerConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.computeoptimizer.model.ContainerConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link #containerConfigurations(List<ContainerConfiguration>)}.
         * 
         * @param containerConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.computeoptimizer.model.ContainerConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerConfigurations(java.util.Collection<ContainerConfiguration>)
         */
        Builder containerConfigurations(Consumer<ContainerConfiguration.Builder>... containerConfigurations);

        /**
         * <p>
         * Describes the Auto Scaling configuration methods for an Amazon ECS service. This affects the generated
         * recommendations. For example, if Auto Scaling is configured on a service’s CPU, then Compute Optimizer
         * doesn’t generate CPU size recommendations.
         * </p>
         * <p>
         * The Auto Scaling configuration methods include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TARGET_TRACKING_SCALING_CPU</code> — If the Amazon ECS service is configured to use target scaling on
         * CPU, Compute Optimizer doesn't generate CPU recommendations.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TARGET_TRACKING_SCALING_MEMORY</code> — If the Amazon ECS service is configured to use target scaling
         * on memory, Compute Optimizer doesn't generate memory recommendations.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about step scaling and target scaling, see <a href=
         * "https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html"
         * > Step scaling policies for Application Auto Scaling</a> and <a href=
         * "https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html"
         * > Target tracking scaling policies for Application Auto Scaling</a> in the <i>Application Auto Scaling User
         * Guide</i>.
         * </p>
         * 
         * @param autoScalingConfiguration
         *        Describes the Auto Scaling configuration methods for an Amazon ECS service. This affects the generated
         *        recommendations. For example, if Auto Scaling is configured on a service’s CPU, then Compute Optimizer
         *        doesn’t generate CPU size recommendations. </p>
         *        <p>
         *        The Auto Scaling configuration methods include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TARGET_TRACKING_SCALING_CPU</code> — If the Amazon ECS service is configured to use target
         *        scaling on CPU, Compute Optimizer doesn't generate CPU recommendations.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TARGET_TRACKING_SCALING_MEMORY</code> — If the Amazon ECS service is configured to use target
         *        scaling on memory, Compute Optimizer doesn't generate memory recommendations.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about step scaling and target scaling, see <a href=
         *        "https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html"
         *        > Step scaling policies for Application Auto Scaling</a> and <a href=
         *        "https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html"
         *        > Target tracking scaling policies for Application Auto Scaling</a> in the <i>Application Auto Scaling
         *        User Guide</i>.
         * @see AutoScalingConfiguration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoScalingConfiguration
         */
        Builder autoScalingConfiguration(String autoScalingConfiguration);

        /**
         * <p>
         * Describes the Auto Scaling configuration methods for an Amazon ECS service. This affects the generated
         * recommendations. For example, if Auto Scaling is configured on a service’s CPU, then Compute Optimizer
         * doesn’t generate CPU size recommendations.
         * </p>
         * <p>
         * The Auto Scaling configuration methods include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TARGET_TRACKING_SCALING_CPU</code> — If the Amazon ECS service is configured to use target scaling on
         * CPU, Compute Optimizer doesn't generate CPU recommendations.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TARGET_TRACKING_SCALING_MEMORY</code> — If the Amazon ECS service is configured to use target scaling
         * on memory, Compute Optimizer doesn't generate memory recommendations.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about step scaling and target scaling, see <a href=
         * "https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html"
         * > Step scaling policies for Application Auto Scaling</a> and <a href=
         * "https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html"
         * > Target tracking scaling policies for Application Auto Scaling</a> in the <i>Application Auto Scaling User
         * Guide</i>.
         * </p>
         * 
         * @param autoScalingConfiguration
         *        Describes the Auto Scaling configuration methods for an Amazon ECS service. This affects the generated
         *        recommendations. For example, if Auto Scaling is configured on a service’s CPU, then Compute Optimizer
         *        doesn’t generate CPU size recommendations. </p>
         *        <p>
         *        The Auto Scaling configuration methods include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TARGET_TRACKING_SCALING_CPU</code> — If the Amazon ECS service is configured to use target
         *        scaling on CPU, Compute Optimizer doesn't generate CPU recommendations.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TARGET_TRACKING_SCALING_MEMORY</code> — If the Amazon ECS service is configured to use target
         *        scaling on memory, Compute Optimizer doesn't generate memory recommendations.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about step scaling and target scaling, see <a href=
         *        "https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html"
         *        > Step scaling policies for Application Auto Scaling</a> and <a href=
         *        "https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html"
         *        > Target tracking scaling policies for Application Auto Scaling</a> in the <i>Application Auto Scaling
         *        User Guide</i>.
         * @see AutoScalingConfiguration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoScalingConfiguration
         */
        Builder autoScalingConfiguration(AutoScalingConfiguration autoScalingConfiguration);

        /**
         * <p>
         * The task definition ARN used by the tasks in the Amazon ECS service.
         * </p>
         * 
         * @param taskDefinitionArn
         *        The task definition ARN used by the tasks in the Amazon ECS service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskDefinitionArn(String taskDefinitionArn);
    }

    static final class BuilderImpl implements Builder {
        private Integer memory;

        private Integer cpu;

        private List<ContainerConfiguration> containerConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String autoScalingConfiguration;

        private String taskDefinitionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceConfiguration model) {
            memory(model.memory);
            cpu(model.cpu);
            containerConfigurations(model.containerConfigurations);
            autoScalingConfiguration(model.autoScalingConfiguration);
            taskDefinitionArn(model.taskDefinitionArn);
        }

        public final Integer getMemory() {
            return memory;
        }

        public final void setMemory(Integer memory) {
            this.memory = memory;
        }

        @Override
        public final Builder memory(Integer memory) {
            this.memory = memory;
            return this;
        }

        public final Integer getCpu() {
            return cpu;
        }

        public final void setCpu(Integer cpu) {
            this.cpu = cpu;
        }

        @Override
        public final Builder cpu(Integer cpu) {
            this.cpu = cpu;
            return this;
        }

        public final List<ContainerConfiguration.Builder> getContainerConfigurations() {
            List<ContainerConfiguration.Builder> result = ContainerConfigurationsCopier
                    .copyToBuilder(this.containerConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainerConfigurations(Collection<ContainerConfiguration.BuilderImpl> containerConfigurations) {
            this.containerConfigurations = ContainerConfigurationsCopier.copyFromBuilder(containerConfigurations);
        }

        @Override
        public final Builder containerConfigurations(Collection<ContainerConfiguration> containerConfigurations) {
            this.containerConfigurations = ContainerConfigurationsCopier.copy(containerConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerConfigurations(ContainerConfiguration... containerConfigurations) {
            containerConfigurations(Arrays.asList(containerConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerConfigurations(Consumer<ContainerConfiguration.Builder>... containerConfigurations) {
            containerConfigurations(Stream.of(containerConfigurations)
                    .map(c -> ContainerConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAutoScalingConfiguration() {
            return autoScalingConfiguration;
        }

        public final void setAutoScalingConfiguration(String autoScalingConfiguration) {
            this.autoScalingConfiguration = autoScalingConfiguration;
        }

        @Override
        public final Builder autoScalingConfiguration(String autoScalingConfiguration) {
            this.autoScalingConfiguration = autoScalingConfiguration;
            return this;
        }

        @Override
        public final Builder autoScalingConfiguration(AutoScalingConfiguration autoScalingConfiguration) {
            this.autoScalingConfiguration(autoScalingConfiguration == null ? null : autoScalingConfiguration.toString());
            return this;
        }

        public final String getTaskDefinitionArn() {
            return taskDefinitionArn;
        }

        public final void setTaskDefinitionArn(String taskDefinitionArn) {
            this.taskDefinitionArn = taskDefinitionArn;
        }

        @Override
        public final Builder taskDefinitionArn(String taskDefinitionArn) {
            this.taskDefinitionArn = taskDefinitionArn;
            return this;
        }

        @Override
        public ServiceConfiguration build() {
            return new ServiceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
