/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.LicenseEdition;
import software.amazon.awssdk.services.computeoptimizer.model.LicenseModel;
import software.amazon.awssdk.services.computeoptimizer.model.LicenseName;
import software.amazon.awssdk.services.computeoptimizer.model.MetricSource;
import software.amazon.awssdk.services.computeoptimizer.model.MetricsSourceCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LicenseConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LicenseConfiguration> {
    private static final SdkField<Integer> NUMBER_OF_CORES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("numberOfCores").getter(LicenseConfiguration.getter(LicenseConfiguration::numberOfCores)).setter(LicenseConfiguration.setter(Builder::numberOfCores)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfCores").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceType").getter(LicenseConfiguration.getter(LicenseConfiguration::instanceType)).setter(LicenseConfiguration.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()}).build();
    private static final SdkField<String> OPERATING_SYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operatingSystem").getter(LicenseConfiguration.getter(LicenseConfiguration::operatingSystem)).setter(LicenseConfiguration.setter(Builder::operatingSystem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operatingSystem").build()}).build();
    private static final SdkField<String> LICENSE_EDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("licenseEdition").getter(LicenseConfiguration.getter(LicenseConfiguration::licenseEditionAsString)).setter(LicenseConfiguration.setter(Builder::licenseEdition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseEdition").build()}).build();
    private static final SdkField<String> LICENSE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("licenseName").getter(LicenseConfiguration.getter(LicenseConfiguration::licenseNameAsString)).setter(LicenseConfiguration.setter(Builder::licenseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseName").build()}).build();
    private static final SdkField<String> LICENSE_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("licenseModel").getter(LicenseConfiguration.getter(LicenseConfiguration::licenseModelAsString)).setter(LicenseConfiguration.setter(Builder::licenseModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseModel").build()}).build();
    private static final SdkField<String> LICENSE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("licenseVersion").getter(LicenseConfiguration.getter(LicenseConfiguration::licenseVersion)).setter(LicenseConfiguration.setter(Builder::licenseVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseVersion").build()}).build();
    private static final SdkField<List<MetricSource>> METRICS_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metricsSource").getter(LicenseConfiguration.getter(LicenseConfiguration::metricsSource)).setter(LicenseConfiguration.setter(Builder::metricsSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricsSource").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMBER_OF_CORES_FIELD, INSTANCE_TYPE_FIELD, OPERATING_SYSTEM_FIELD, LICENSE_EDITION_FIELD, LICENSE_NAME_FIELD, LICENSE_MODEL_FIELD, LICENSE_VERSION_FIELD, METRICS_SOURCE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer numberOfCores;
    private final String instanceType;
    private final String operatingSystem;
    private final String licenseEdition;
    private final String licenseName;
    private final String licenseModel;
    private final String licenseVersion;
    private final List<MetricSource> metricsSource;

    private LicenseConfiguration(BuilderImpl builder) {
        this.numberOfCores = builder.numberOfCores;
        this.instanceType = builder.instanceType;
        this.operatingSystem = builder.operatingSystem;
        this.licenseEdition = builder.licenseEdition;
        this.licenseName = builder.licenseName;
        this.licenseModel = builder.licenseModel;
        this.licenseVersion = builder.licenseVersion;
        this.metricsSource = builder.metricsSource;
    }

    public final Integer numberOfCores() {
        return this.numberOfCores;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final String operatingSystem() {
        return this.operatingSystem;
    }

    public final LicenseEdition licenseEdition() {
        return LicenseEdition.fromValue(this.licenseEdition);
    }

    public final String licenseEditionAsString() {
        return this.licenseEdition;
    }

    public final LicenseName licenseName() {
        return LicenseName.fromValue(this.licenseName);
    }

    public final String licenseNameAsString() {
        return this.licenseName;
    }

    public final LicenseModel licenseModel() {
        return LicenseModel.fromValue(this.licenseModel);
    }

    public final String licenseModelAsString() {
        return this.licenseModel;
    }

    public final String licenseVersion() {
        return this.licenseVersion;
    }

    public final boolean hasMetricsSource() {
        return this.metricsSource != null && !(this.metricsSource instanceof SdkAutoConstructList);
    }

    public final List<MetricSource> metricsSource() {
        return this.metricsSource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfCores());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystem());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseEditionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricsSource() ? this.metricsSource() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LicenseConfiguration)) {
            return false;
        }
        LicenseConfiguration other = (LicenseConfiguration)obj;
        return Objects.equals(this.numberOfCores(), other.numberOfCores()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.operatingSystem(), other.operatingSystem()) && Objects.equals(this.licenseEditionAsString(), other.licenseEditionAsString()) && Objects.equals(this.licenseNameAsString(), other.licenseNameAsString()) && Objects.equals(this.licenseModelAsString(), other.licenseModelAsString()) && Objects.equals(this.licenseVersion(), other.licenseVersion()) && this.hasMetricsSource() == other.hasMetricsSource() && Objects.equals(this.metricsSource(), other.metricsSource());
    }

    public final String toString() {
        return ToString.builder((String)"LicenseConfiguration").add("NumberOfCores", (Object)this.numberOfCores()).add("InstanceType", (Object)this.instanceType()).add("OperatingSystem", (Object)this.operatingSystem()).add("LicenseEdition", (Object)this.licenseEditionAsString()).add("LicenseName", (Object)this.licenseNameAsString()).add("LicenseModel", (Object)this.licenseModelAsString()).add("LicenseVersion", (Object)this.licenseVersion()).add("MetricsSource", this.hasMetricsSource() ? this.metricsSource() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "numberOfCores": {
                return Optional.ofNullable(clazz.cast(this.numberOfCores()));
            }
            case "instanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "operatingSystem": {
                return Optional.ofNullable(clazz.cast(this.operatingSystem()));
            }
            case "licenseEdition": {
                return Optional.ofNullable(clazz.cast(this.licenseEditionAsString()));
            }
            case "licenseName": {
                return Optional.ofNullable(clazz.cast(this.licenseNameAsString()));
            }
            case "licenseModel": {
                return Optional.ofNullable(clazz.cast(this.licenseModelAsString()));
            }
            case "licenseVersion": {
                return Optional.ofNullable(clazz.cast(this.licenseVersion()));
            }
            case "metricsSource": {
                return Optional.ofNullable(clazz.cast(this.metricsSource()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LicenseConfiguration, T> g) {
        return obj -> g.apply((LicenseConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer numberOfCores;
        private String instanceType;
        private String operatingSystem;
        private String licenseEdition;
        private String licenseName;
        private String licenseModel;
        private String licenseVersion;
        private List<MetricSource> metricsSource = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LicenseConfiguration model) {
            this.numberOfCores(model.numberOfCores);
            this.instanceType(model.instanceType);
            this.operatingSystem(model.operatingSystem);
            this.licenseEdition(model.licenseEdition);
            this.licenseName(model.licenseName);
            this.licenseModel(model.licenseModel);
            this.licenseVersion(model.licenseVersion);
            this.metricsSource(model.metricsSource);
        }

        public final Integer getNumberOfCores() {
            return this.numberOfCores;
        }

        public final void setNumberOfCores(Integer numberOfCores) {
            this.numberOfCores = numberOfCores;
        }

        @Override
        public final Builder numberOfCores(Integer numberOfCores) {
            this.numberOfCores = numberOfCores;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getOperatingSystem() {
            return this.operatingSystem;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        public final String getLicenseEdition() {
            return this.licenseEdition;
        }

        public final void setLicenseEdition(String licenseEdition) {
            this.licenseEdition = licenseEdition;
        }

        @Override
        public final Builder licenseEdition(String licenseEdition) {
            this.licenseEdition = licenseEdition;
            return this;
        }

        @Override
        public final Builder licenseEdition(LicenseEdition licenseEdition) {
            this.licenseEdition(licenseEdition == null ? null : licenseEdition.toString());
            return this;
        }

        public final String getLicenseName() {
            return this.licenseName;
        }

        public final void setLicenseName(String licenseName) {
            this.licenseName = licenseName;
        }

        @Override
        public final Builder licenseName(String licenseName) {
            this.licenseName = licenseName;
            return this;
        }

        @Override
        public final Builder licenseName(LicenseName licenseName) {
            this.licenseName(licenseName == null ? null : licenseName.toString());
            return this;
        }

        public final String getLicenseModel() {
            return this.licenseModel;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        @Override
        public final Builder licenseModel(LicenseModel licenseModel) {
            this.licenseModel(licenseModel == null ? null : licenseModel.toString());
            return this;
        }

        public final String getLicenseVersion() {
            return this.licenseVersion;
        }

        public final void setLicenseVersion(String licenseVersion) {
            this.licenseVersion = licenseVersion;
        }

        @Override
        public final Builder licenseVersion(String licenseVersion) {
            this.licenseVersion = licenseVersion;
            return this;
        }

        public final List<MetricSource.Builder> getMetricsSource() {
            List<MetricSource.Builder> result = MetricsSourceCopier.copyToBuilder(this.metricsSource);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricsSource(Collection<MetricSource.BuilderImpl> metricsSource) {
            this.metricsSource = MetricsSourceCopier.copyFromBuilder(metricsSource);
        }

        @Override
        public final Builder metricsSource(Collection<MetricSource> metricsSource) {
            this.metricsSource = MetricsSourceCopier.copy(metricsSource);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricsSource(MetricSource ... metricsSource) {
            this.metricsSource(Arrays.asList(metricsSource));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricsSource(Consumer<MetricSource.Builder> ... metricsSource) {
            this.metricsSource(Stream.of(metricsSource).map(c -> (MetricSource)((MetricSource.Builder)MetricSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public LicenseConfiguration build() {
            return new LicenseConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LicenseConfiguration> {
        public Builder numberOfCores(Integer var1);

        public Builder instanceType(String var1);

        public Builder operatingSystem(String var1);

        public Builder licenseEdition(String var1);

        public Builder licenseEdition(LicenseEdition var1);

        public Builder licenseName(String var1);

        public Builder licenseName(LicenseName var1);

        public Builder licenseModel(String var1);

        public Builder licenseModel(LicenseModel var1);

        public Builder licenseVersion(String var1);

        public Builder metricsSource(Collection<MetricSource> var1);

        public Builder metricsSource(MetricSource ... var1);

        public Builder metricsSource(Consumer<MetricSource.Builder> ... var1);
    }
}

