/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MetricName {
    CPU("Cpu"),
    MEMORY("Memory"),
    EBS_READ_OPS_PER_SECOND("EBS_READ_OPS_PER_SECOND"),
    EBS_WRITE_OPS_PER_SECOND("EBS_WRITE_OPS_PER_SECOND"),
    EBS_READ_BYTES_PER_SECOND("EBS_READ_BYTES_PER_SECOND"),
    EBS_WRITE_BYTES_PER_SECOND("EBS_WRITE_BYTES_PER_SECOND"),
    DISK_READ_OPS_PER_SECOND("DISK_READ_OPS_PER_SECOND"),
    DISK_WRITE_OPS_PER_SECOND("DISK_WRITE_OPS_PER_SECOND"),
    DISK_READ_BYTES_PER_SECOND("DISK_READ_BYTES_PER_SECOND"),
    DISK_WRITE_BYTES_PER_SECOND("DISK_WRITE_BYTES_PER_SECOND"),
    NETWORK_IN_BYTES_PER_SECOND("NETWORK_IN_BYTES_PER_SECOND"),
    NETWORK_OUT_BYTES_PER_SECOND("NETWORK_OUT_BYTES_PER_SECOND"),
    NETWORK_PACKETS_IN_PER_SECOND("NETWORK_PACKETS_IN_PER_SECOND"),
    NETWORK_PACKETS_OUT_PER_SECOND("NETWORK_PACKETS_OUT_PER_SECOND"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MetricName> VALUE_MAP;
    private final String value;

    private MetricName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MetricName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MetricName> knownValues() {
        EnumSet<MetricName> knownValues = EnumSet.allOf(MetricName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MetricName.class, MetricName::toString);
    }
}

