/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.computeoptimizer.model.EnhancedInfrastructureMetrics;
import software.amazon.awssdk.services.computeoptimizer.model.ResourceType;
import software.amazon.awssdk.services.computeoptimizer.model.Scope;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecommendationPreferencesDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecommendationPreferencesDetail> {
    private static final SdkField<Scope> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scope").getter(RecommendationPreferencesDetail.getter(RecommendationPreferencesDetail::scope)).setter(RecommendationPreferencesDetail.setter(Builder::scope)).constructor(Scope::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scope").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(RecommendationPreferencesDetail.getter(RecommendationPreferencesDetail::resourceTypeAsString)).setter(RecommendationPreferencesDetail.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<String> ENHANCED_INFRASTRUCTURE_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("enhancedInfrastructureMetrics").getter(RecommendationPreferencesDetail.getter(RecommendationPreferencesDetail::enhancedInfrastructureMetricsAsString)).setter(RecommendationPreferencesDetail.setter(Builder::enhancedInfrastructureMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enhancedInfrastructureMetrics").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCOPE_FIELD, RESOURCE_TYPE_FIELD, ENHANCED_INFRASTRUCTURE_METRICS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Scope scope;
    private final String resourceType;
    private final String enhancedInfrastructureMetrics;

    private RecommendationPreferencesDetail(BuilderImpl builder) {
        this.scope = builder.scope;
        this.resourceType = builder.resourceType;
        this.enhancedInfrastructureMetrics = builder.enhancedInfrastructureMetrics;
    }

    public final Scope scope() {
        return this.scope;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final EnhancedInfrastructureMetrics enhancedInfrastructureMetrics() {
        return EnhancedInfrastructureMetrics.fromValue(this.enhancedInfrastructureMetrics);
    }

    public final String enhancedInfrastructureMetricsAsString() {
        return this.enhancedInfrastructureMetrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scope());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enhancedInfrastructureMetricsAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationPreferencesDetail)) {
            return false;
        }
        RecommendationPreferencesDetail other = (RecommendationPreferencesDetail)obj;
        return Objects.equals(this.scope(), other.scope()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.enhancedInfrastructureMetricsAsString(), other.enhancedInfrastructureMetricsAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RecommendationPreferencesDetail").add("Scope", (Object)this.scope()).add("ResourceType", (Object)this.resourceTypeAsString()).add("EnhancedInfrastructureMetrics", (Object)this.enhancedInfrastructureMetricsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "scope": {
                return Optional.ofNullable(clazz.cast(this.scope()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "enhancedInfrastructureMetrics": {
                return Optional.ofNullable(clazz.cast(this.enhancedInfrastructureMetricsAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationPreferencesDetail, T> g) {
        return obj -> g.apply((RecommendationPreferencesDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Scope scope;
        private String resourceType;
        private String enhancedInfrastructureMetrics;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationPreferencesDetail model) {
            this.scope(model.scope);
            this.resourceType(model.resourceType);
            this.enhancedInfrastructureMetrics(model.enhancedInfrastructureMetrics);
        }

        public final Scope.Builder getScope() {
            return this.scope != null ? this.scope.toBuilder() : null;
        }

        public final void setScope(Scope.BuilderImpl scope) {
            this.scope = scope != null ? scope.build() : null;
        }

        @Override
        @Transient
        public final Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        @Transient
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        @Transient
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getEnhancedInfrastructureMetrics() {
            return this.enhancedInfrastructureMetrics;
        }

        public final void setEnhancedInfrastructureMetrics(String enhancedInfrastructureMetrics) {
            this.enhancedInfrastructureMetrics = enhancedInfrastructureMetrics;
        }

        @Override
        @Transient
        public final Builder enhancedInfrastructureMetrics(String enhancedInfrastructureMetrics) {
            this.enhancedInfrastructureMetrics = enhancedInfrastructureMetrics;
            return this;
        }

        @Override
        @Transient
        public final Builder enhancedInfrastructureMetrics(EnhancedInfrastructureMetrics enhancedInfrastructureMetrics) {
            this.enhancedInfrastructureMetrics(enhancedInfrastructureMetrics == null ? null : enhancedInfrastructureMetrics.toString());
            return this;
        }

        public RecommendationPreferencesDetail build() {
            return new RecommendationPreferencesDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecommendationPreferencesDetail> {
        public Builder scope(Scope var1);

        default public Builder scope(Consumer<Scope.Builder> scope) {
            return this.scope((Scope)((Scope.Builder)Scope.builder().applyMutation(scope)).build());
        }

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder enhancedInfrastructureMetrics(String var1);

        public Builder enhancedInfrastructureMetrics(EnhancedInfrastructureMetrics var1);
    }
}

