/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EBSMetricName {
    VOLUME_READ_OPS_PER_SECOND("VolumeReadOpsPerSecond"),
    VOLUME_WRITE_OPS_PER_SECOND("VolumeWriteOpsPerSecond"),
    VOLUME_READ_BYTES_PER_SECOND("VolumeReadBytesPerSecond"),
    VOLUME_WRITE_BYTES_PER_SECOND("VolumeWriteBytesPerSecond"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EBSMetricName> VALUE_MAP;
    private final String value;

    private EBSMetricName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EBSMetricName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EBSMetricName> knownValues() {
        EnumSet<EBSMetricName> knownValues = EnumSet.allOf(EBSMetricName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EBSMetricName.class, EBSMetricName::toString);
    }
}

