/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ExportableInstanceField {
    ACCOUNT_ID("AccountId"),
    INSTANCE_ARN("InstanceArn"),
    INSTANCE_NAME("InstanceName"),
    FINDING("Finding"),
    FINDING_REASON_CODES("FindingReasonCodes"),
    LOOKBACK_PERIOD_IN_DAYS("LookbackPeriodInDays"),
    CURRENT_INSTANCE_TYPE("CurrentInstanceType"),
    UTILIZATION_METRICS_CPU_MAXIMUM("UtilizationMetricsCpuMaximum"),
    UTILIZATION_METRICS_MEMORY_MAXIMUM("UtilizationMetricsMemoryMaximum"),
    UTILIZATION_METRICS_EBS_READ_OPS_PER_SECOND_MAXIMUM("UtilizationMetricsEbsReadOpsPerSecondMaximum"),
    UTILIZATION_METRICS_EBS_WRITE_OPS_PER_SECOND_MAXIMUM("UtilizationMetricsEbsWriteOpsPerSecondMaximum"),
    UTILIZATION_METRICS_EBS_READ_BYTES_PER_SECOND_MAXIMUM("UtilizationMetricsEbsReadBytesPerSecondMaximum"),
    UTILIZATION_METRICS_EBS_WRITE_BYTES_PER_SECOND_MAXIMUM("UtilizationMetricsEbsWriteBytesPerSecondMaximum"),
    UTILIZATION_METRICS_DISK_READ_OPS_PER_SECOND_MAXIMUM("UtilizationMetricsDiskReadOpsPerSecondMaximum"),
    UTILIZATION_METRICS_DISK_WRITE_OPS_PER_SECOND_MAXIMUM("UtilizationMetricsDiskWriteOpsPerSecondMaximum"),
    UTILIZATION_METRICS_DISK_READ_BYTES_PER_SECOND_MAXIMUM("UtilizationMetricsDiskReadBytesPerSecondMaximum"),
    UTILIZATION_METRICS_DISK_WRITE_BYTES_PER_SECOND_MAXIMUM("UtilizationMetricsDiskWriteBytesPerSecondMaximum"),
    UTILIZATION_METRICS_NETWORK_IN_BYTES_PER_SECOND_MAXIMUM("UtilizationMetricsNetworkInBytesPerSecondMaximum"),
    UTILIZATION_METRICS_NETWORK_OUT_BYTES_PER_SECOND_MAXIMUM("UtilizationMetricsNetworkOutBytesPerSecondMaximum"),
    UTILIZATION_METRICS_NETWORK_PACKETS_IN_PER_SECOND_MAXIMUM("UtilizationMetricsNetworkPacketsInPerSecondMaximum"),
    UTILIZATION_METRICS_NETWORK_PACKETS_OUT_PER_SECOND_MAXIMUM("UtilizationMetricsNetworkPacketsOutPerSecondMaximum"),
    CURRENT_ON_DEMAND_PRICE("CurrentOnDemandPrice"),
    CURRENT_STANDARD_ONE_YEAR_NO_UPFRONT_RESERVED_PRICE("CurrentStandardOneYearNoUpfrontReservedPrice"),
    CURRENT_STANDARD_THREE_YEAR_NO_UPFRONT_RESERVED_PRICE("CurrentStandardThreeYearNoUpfrontReservedPrice"),
    CURRENT_V_CPUS("CurrentVCpus"),
    CURRENT_MEMORY("CurrentMemory"),
    CURRENT_STORAGE("CurrentStorage"),
    CURRENT_NETWORK("CurrentNetwork"),
    RECOMMENDATION_OPTIONS_INSTANCE_TYPE("RecommendationOptionsInstanceType"),
    RECOMMENDATION_OPTIONS_PROJECTED_UTILIZATION_METRICS_CPU_MAXIMUM("RecommendationOptionsProjectedUtilizationMetricsCpuMaximum"),
    RECOMMENDATION_OPTIONS_PROJECTED_UTILIZATION_METRICS_MEMORY_MAXIMUM("RecommendationOptionsProjectedUtilizationMetricsMemoryMaximum"),
    RECOMMENDATION_OPTIONS_PLATFORM_DIFFERENCES("RecommendationOptionsPlatformDifferences"),
    RECOMMENDATION_OPTIONS_PERFORMANCE_RISK("RecommendationOptionsPerformanceRisk"),
    RECOMMENDATION_OPTIONS_VCPUS("RecommendationOptionsVcpus"),
    RECOMMENDATION_OPTIONS_MEMORY("RecommendationOptionsMemory"),
    RECOMMENDATION_OPTIONS_STORAGE("RecommendationOptionsStorage"),
    RECOMMENDATION_OPTIONS_NETWORK("RecommendationOptionsNetwork"),
    RECOMMENDATION_OPTIONS_ON_DEMAND_PRICE("RecommendationOptionsOnDemandPrice"),
    RECOMMENDATION_OPTIONS_STANDARD_ONE_YEAR_NO_UPFRONT_RESERVED_PRICE("RecommendationOptionsStandardOneYearNoUpfrontReservedPrice"),
    RECOMMENDATION_OPTIONS_STANDARD_THREE_YEAR_NO_UPFRONT_RESERVED_PRICE("RecommendationOptionsStandardThreeYearNoUpfrontReservedPrice"),
    RECOMMENDATIONS_SOURCES_RECOMMENDATION_SOURCE_ARN("RecommendationsSourcesRecommendationSourceArn"),
    RECOMMENDATIONS_SOURCES_RECOMMENDATION_SOURCE_TYPE("RecommendationsSourcesRecommendationSourceType"),
    LAST_REFRESH_TIMESTAMP("LastRefreshTimestamp"),
    CURRENT_PERFORMANCE_RISK("CurrentPerformanceRisk"),
    RECOMMENDATION_OPTIONS_SAVINGS_OPPORTUNITY_PERCENTAGE("RecommendationOptionsSavingsOpportunityPercentage"),
    RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_CURRENCY("RecommendationOptionsEstimatedMonthlySavingsCurrency"),
    RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_VALUE("RecommendationOptionsEstimatedMonthlySavingsValue"),
    EFFECTIVE_RECOMMENDATION_PREFERENCES_CPU_VENDOR_ARCHITECTURES("EffectiveRecommendationPreferencesCpuVendorArchitectures"),
    EFFECTIVE_RECOMMENDATION_PREFERENCES_ENHANCED_INFRASTRUCTURE_METRICS("EffectiveRecommendationPreferencesEnhancedInfrastructureMetrics"),
    EFFECTIVE_RECOMMENDATION_PREFERENCES_INFERRED_WORKLOAD_TYPES("EffectiveRecommendationPreferencesInferredWorkloadTypes"),
    INFERRED_WORKLOAD_TYPES("InferredWorkloadTypes"),
    RECOMMENDATION_OPTIONS_MIGRATION_EFFORT("RecommendationOptionsMigrationEffort"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExportableInstanceField> VALUE_MAP;
    private final String value;

    private ExportableInstanceField(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExportableInstanceField fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExportableInstanceField> knownValues() {
        EnumSet<ExportableInstanceField> knownValues = EnumSet.allOf(ExportableInstanceField.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ExportableInstanceField.class, ExportableInstanceField::toString);
    }
}

